/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.mytest.debug;

import java.io.PrintStream;
import java.util.Calendar;
import net.dialang.mytest.debug.Debug;

public abstract class BasicDebug
implements Debug {
    private int debugLevel;
    protected PrintStream output;

    public synchronized void setLevel(int n) {
        this.debugLevel = n;
        if (this.isDebug()) {
            this.output.println("Debug level=Ox" + Integer.toHexString(this.debugLevel));
        }
    }

    public void setOutput(PrintStream printStream) {
        this.output = printStream;
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public int getLevel() {
        return this.debugLevel;
    }

    public boolean isDebug() {
        return this.debugLevel != 0;
    }

    public boolean isDebug(int n) {
        return (this.debugLevel & n) != 0;
    }

    protected abstract String getName(int var1);

    public int getLevel(String string) {
        if (string == null) {
            return -1;
        }
        int n = 0x40000000;
        int n2 = 1;
        while (n2 < n) {
            if (string.equals(this.getName(n2))) {
                return n2;
            }
            n2 <<= 1;
        }
        return -1;
    }

    public void prettyPrintLevel() {
        this.prettyPrintLevel(this.getLevel());
    }

    public synchronized void prettyPrintLevel(int n) {
        int n2 = Integer.MIN_VALUE;
        this.output.print("Debug is enabled for:");
        int n3 = 32;
        while (n3 > 0) {
            if ((n & n2) > 0) {
                if (n3 % 4 == 0) {
                    this.output.println();
                    this.output.print('\t');
                }
                this.output.print(this.getName(n2));
                this.output.print(" | ");
            }
            n2 >>>= 1;
            --n3;
        }
        this.output.println('\n');
    }

    public void println(Object object) {
        if (this.isDebug(1)) {
            this.println(1, new Object[]{object});
        }
    }

    public void println(int n, Object object) {
        if (this.isDebug(n)) {
            this.println(n, new Object[]{object});
        }
    }

    public void println(int n, Object object, Object object2) {
        if (this.isDebug(n)) {
            this.println(n, new Object[]{object, object2});
        }
    }

    public void println(int n, Object object, Object object2, Object object3) {
        if (this.isDebug(n)) {
            this.println(n, new Object[]{object, object2, object3});
        }
    }

    public void println(int n, Object object, Object object2, Object object3, Object object4) {
        if (this.isDebug(n)) {
            this.println(n, new Object[]{object, object2, object3, object4});
        }
    }

    public void println(int n, Object object, Object object2, Object object3, Object object4, Object object5) {
        if (this.isDebug(n)) {
            this.println(n, new Object[]{object, object2, object3, object4, object5});
        }
    }

    public void println(int n, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        if (this.isDebug(n)) {
            this.println(n, new Object[]{object, object2, object3, object4, object5, object6});
        }
    }

    public void println(int n, Object[] objectArray) {
        if (!this.isDebug(n)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(96);
        Calendar calendar = Calendar.getInstance();
        stringBuffer.append(calendar.get(5) + "/");
        int n2 = calendar.get(2);
        if (n2 == 0) {
            n2 = 1;
        }
        stringBuffer.append(n2 + "/");
        stringBuffer.append(calendar.get(1) + " ");
        stringBuffer.append(calendar.get(11) + ":");
        stringBuffer.append(calendar.get(12) + ":");
        stringBuffer.append(calendar.get(13));
        stringBuffer.append(" (");
        stringBuffer.append(this.getName(n));
        stringBuffer.append("):");
        int n3 = 0;
        int n4 = objectArray.length;
        while (n3 < n4) {
            stringBuffer.append(' ');
            stringBuffer.append(objectArray[n3] == null ? "null" : objectArray[n3]);
            ++n3;
        }
        PrintStream printStream = this.output;
        synchronized (printStream) {
            this.output.println(stringBuffer.toString());
            this.output.flush();
        }
    }

    public void close() {
    }

    public BasicDebug() {
        this(0);
    }

    public BasicDebug(int n) {
        this(n, System.out);
    }

    public BasicDebug(int n, PrintStream printStream) {
        this.debugLevel = n;
        this.output = printStream;
    }
}

