/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.mytest.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import net.dialang.mytest.io.RecordReader;

public class MultiLineRecordReader
extends BufferedReader {
    private char FS;
    private char FW;
    private int fieldCounter = 0;
    private Vector record;
    private String buffer;
    private boolean dbg = false;
    private String file;

    public void getFile() throws IOException {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = new String("not null");
        while (string != null) {
            string = this.readLine();
            if (string == null) continue;
            stringBuffer.append(string);
        }
        this.file = stringBuffer.toString();
    }

    public boolean ready() {
        return this.file.length() > 0 && this.file.indexOf(64) != -1;
    }

    public String getNextRecord() {
        int n = this.file.indexOf(64);
        n = this.file.indexOf(64, n + 1);
        String string = this.file.substring(0, n + 1);
        this.file = this.file.substring(n + 1);
        return string;
    }

    public void setFieldSeparator(char c) {
        this.FS = c;
    }

    public char getFieldSeparator() {
        return this.FS;
    }

    public void setFieldWrapper(char c) {
        this.FW = c;
    }

    public char getFieldWrapper() {
        return this.FW;
    }

    public void setDebug(boolean bl) {
        this.dbg = bl;
    }

    public Vector readRecord() throws IOException {
        this.record = new Vector();
        this.buffer = this.getNextRecord();
        if (this.buffer == null) {
            return this.record;
        }
        if (this.buffer.length() == 0) {
            return this.record;
        }
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.buffer.length()) {
            char c = this.buffer.charAt(n3);
            this.debug("read char [" + c + "]");
            if (c == this.FS) {
                this.debug("fs");
                if (n2 == -1) {
                    n2 = n3;
                    this.debug("end " + n2);
                }
                this.newField(n, n2);
                n2 = -1;
                n = -1;
            } else if (c == ' ' || c == '\t') {
                this.debug("whsp");
                if (n != -1 && n2 == -1) {
                    n2 = n3;
                }
            } else if (c == '#') {
                if (n == -1) {
                    this.debug("comment");
                    return this.record;
                }
            } else if (c == this.FW) {
                this.debug("fw");
                n = n3 + 1;
                n2 = this.buffer.indexOf(this.FW, n);
                if (n2 == -1) {
                    throw new RuntimeException("Parse Error: missing field wrapper (" + this.FW + ") [" + this.buffer + "]");
                }
                n3 = n2;
            } else {
                this.debug("not claimed");
                if (n == -1) {
                    n = n3;
                    this.debug("field start " + n);
                }
            }
            ++n3;
        }
        if (n != -1) {
            this.newField(n, n2 != -1 ? n2 : this.buffer.length());
        }
        return this.record;
    }

    private final void newField(int n, int n2) {
        this.debug("new field: start " + n + " end " + n2);
        String string = n == -1 ? new String() : this.buffer.substring(n, n2);
        this.debug(" [" + string + "]");
        this.record.add(string);
        ++this.fieldCounter;
    }

    public static void main(String[] stringArray) {
        RecordReader recordReader;
        if (stringArray.length != 3) {
            System.out.println("Usage: RecordReader fs fw file");
            System.exit(0);
        }
        try {
            recordReader = new RecordReader(new FileReader(stringArray[2]));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        recordReader.setFieldSeparator(stringArray[0].charAt(0));
        recordReader.setFieldWrapper(stringArray[1].charAt(0));
        int n = 0;
        try {
            while (recordReader.ready()) {
                Vector vector = recordReader.readRecord();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("record ");
                stringBuffer.append(n++);
                stringBuffer.append(" fields ");
                stringBuffer.append(vector.size());
                stringBuffer.append("\n");
                int n2 = 0;
                Iterator iterator = ((AbstractList)vector).iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append("\tfield");
                    stringBuffer.append(n2++);
                    stringBuffer.append(" [");
                    stringBuffer.append((String)iterator.next());
                    stringBuffer.append("]\n");
                }
            }
            recordReader.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private final void debug(String string) {
        if (this.dbg) {
            System.err.println(string);
        }
    }

    public MultiLineRecordReader(Reader reader) throws IOException {
        super(reader);
        this.getFile();
    }

    public MultiLineRecordReader(Reader reader, int n) throws IOException {
        super(reader, n);
        this.getFile();
    }
}

