/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.mytest.io;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import net.dialang.mytest.io.MeasuredInputStream;
import net.dialang.mytest.io.ThrottledInputStream;
import net.dialang.mytest.io.TimedInputStream;

public class TestIO {
    static TimedInputStream tis;
    static ThrottledInputStream thris;
    static FileInputStream fis;
    static MeasuredInputStream mis;
    static FileOutputStream fos;
    static BufferedOutputStream bos;
    static String fin;
    static String fout;
    static int timeout;
    static int varience;
    static int buffsize;
    static final String[] testTypes;
    static int test;
    static volatile Thread bwMonitor;

    public static void main(String[] stringArray) {
        if (stringArray.length < 6) {
            System.out.println("usage: test input output timout variance buffsize");
            System.out.println("test types are: r, rb, rbol");
            System.exit(1);
        }
        try {
            int n = 0;
            while (n < testTypes.length) {
                if (testTypes[n].equals(stringArray[0])) {
                    test = n;
                    break;
                }
                ++n;
            }
            if (test == -1) {
                System.out.println("invalid testType " + stringArray[0]);
                System.exit(1);
            }
            fin = stringArray[1];
            fout = stringArray[2];
            timeout = Integer.parseInt(stringArray[3]);
            varience = Integer.parseInt(stringArray[4]);
            buffsize = Integer.parseInt(stringArray[5]);
            fis = new FileInputStream(fin);
            thris = new ThrottledInputStream(fis, varience);
            mis = new MeasuredInputStream(thris);
            tis = new TimedInputStream(mis, timeout);
            bos = new BufferedOutputStream(new FileOutputStream(fout));
        }
        catch (Exception exception) {
            System.out.println("argument exception " + exception);
            System.exit(1);
        }
        bwMonitor = new Thread(new Runnable(){

            public void run() {
                Thread thread = Thread.currentThread();
                while (bwMonitor == thread) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println(mis.getBandwidth() + "k/s " + mis.getMarginOfError() + "%");
                }
                System.out.println("bwMonitor termimating");
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        if (mis != null) {
            bwMonitor.start();
        }
        switch (test) {
            case 0: {
                TestIO.readTest();
                break;
            }
            case 1: {
                TestIO.readBTest();
                break;
            }
            case 2: {
                TestIO.readBOLTest();
                break;
            }
        }
        try {
            bwMonitor = null;
            System.out.println("total delay " + thris.getTotalDelay());
            bos.flush();
            bos.close();
            tis.close();
        }
        catch (IOException iOException) {
            System.out.println("problems in shutdown " + iOException);
        }
    }

    private static void readTest() {
        try {
            int n;
            while (-1 != (n = tis.read())) {
                bos.write(n);
            }
        }
        catch (Exception exception) {
            System.out.println("testIO caught " + exception);
            System.exit(1);
        }
    }

    private static void readBTest() {
        try {
            int n;
            byte[] byArray = new byte[buffsize];
            while (-1 != (n = tis.read(byArray))) {
                bos.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            System.out.println("testIO caught " + exception);
            System.exit(1);
        }
    }

    private static void readBOLTest() {
        System.out.println("readBOLTest");
        try {
            int n;
            byte[] byArray = new byte[buffsize];
            while (-1 != (n = tis.read(byArray, 0, byArray.length))) {
                bos.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            System.out.println("testIO caught " + exception);
            System.exit(1);
        }
    }

    static {
        testTypes = new String[]{"r", "rb", "rbol"};
        test = -1;
    }
}

