/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.mytest.jam;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JWindow;
import net.dialang.mytest.debug.Debug;
import net.dialang.mytest.jam.Application;
import net.dialang.mytest.jam.Display;
import net.dialang.mytest.jam.ErrorHandler;
import net.dialang.mytest.jam.JamException;
import net.dialang.mytest.jam.JamWrapperException;
import net.dialang.mytest.jam.Kernel;
import net.dialang.mytest.jam.Navigator;
import net.dialang.mytest.jam.Page;
import net.dialang.mytest.jam.PageNotFoundException;
import net.dialang.mytest.jam.StatusValue;

class Kernel {
    private static Hashtable pages;
    private static Hashtable displays;
    private static Page currentPage;
    private static Hashtable frames;
    private static Hashtable windows;
    private static Navigator navigator;
    private static ErrorHandler eHandle;
    private static Application application;
    private static Kernel identity;
    private static boolean inError;
    static Debug debug;
    static int debugID;
    private static final Runnable AWT_refresh;
    private static final Runnable AWT_unMap;
    private static final Runnable AWT_showPage;
    static /* synthetic */ Class class$net$dialang$mytest$jam$Quit;
    static /* synthetic */ Class class$net$dialang$mytest$jam$Page;

    static final void setDebug(Debug debug, int n) {
        Kernel.debug = debug;
        debugID = n;
    }

    static final Page getCurrentPage() {
        return currentPage;
    }

    static final void register(Object object) {
        if (debug != null) {
            debug.println(debugID, object.getClass().getName());
        }
        if (object instanceof ErrorHandler) {
            eHandle = (ErrorHandler)object;
            if (debug != null) {
                debug.println(debugID, "- registered errorhandler");
            }
            try {
                eHandle.build();
                if (debug != null) {
                    debug.println(debugID, "errorhandler built ok");
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (application != null) {
                    application.quit();
                }
                System.exit(1);
            }
            return;
        }
        if (object instanceof Page) {
            pages.put(object.getClass(), object);
            if (debug != null) {
                debug.println(debugID, "- registered page");
            }
            return;
        }
        if (object instanceof Display) {
            displays.put(object.getClass(), object);
            if (debug != null) {
                debug.println(debugID, "- registered display");
            }
            return;
        }
        if (object instanceof Navigator) {
            navigator = (Navigator)object;
            if (debug != null) {
                debug.println(debugID, "- registered navigator");
            }
            return;
        }
        if (object instanceof Application) {
            application = (Application)object;
            if (debug != null) {
                debug.println(debugID, "- registered application");
            }
            return;
        }
        if (debug != null) {
            debug.println(debugID, "- not registered");
        }
    }

    static Navigator getNavigator() {
        return navigator;
    }

    static Application getApplication() {
        return application;
    }

    static void start(Class clazz) {
        Kernel.toPage(clazz == null ? navigator.getFirstPage() : clazz);
    }

    static final void showError() {
        try {
            if (currentPage != null) {
                Kernel.invokeAndWait(AWT_unMap);
            }
            currentPage = eHandle;
            Kernel.invokeAndWait(AWT_showPage);
        }
        catch (Throwable throwable) {
            System.err.println("Kernel: Unable to show error page - aborting");
            throwable.printStackTrace();
            application.quit();
        }
    }

    static final boolean isError() {
        return inError;
    }

    static final synchronized void fatalError(Page page, String string, Throwable throwable) {
        if (inError) {
            if (debug != null) {
                debug.println(debugID, "Kernel - error handler busy!");
            }
            return;
        }
        inError = true;
        if (eHandle == null) {
            System.err.println("NO ERROR HANDLER SET");
            System.err.print("Who ");
            System.err.println(page.getClass().getName());
            System.err.print("What ");
            System.err.println(string);
            System.err.print("Why ");
            System.err.println(throwable);
            throwable.printStackTrace();
            application.quit();
        }
        eHandle.fatal(page, string, throwable);
        Kernel.showError();
    }

    static final void navigate(Page page, StatusValue statusValue) {
        Class clazz;
        if (page == eHandle) {
            if (debug != null) {
                debug.println(debugID, "Kernel - error handler free");
            }
            inError = false;
        }
        if (inError) {
            if (debug != null) {
                debug.println(debugID, "Kernel navigate - error handler busy");
            }
            page.getDisplay().setWaitCursor(false);
            return;
        }
        try {
            clazz = navigator.navigate(page.getClass(), statusValue);
        }
        catch (Throwable throwable) {
            if (debug != null) {
                debug.println(debugID, "Kernel/navigate: trapped navigate exception", throwable);
            }
            Kernel.fatalError(currentPage, "refresh", throwable);
            return;
        }
        if (page.getClass() == clazz) {
            if (debug != null) {
                debug.println(debugID, "Kernel/navigate: called is same as callee");
            }
            try {
                try {
                    Kernel.invokeAndWait(AWT_refresh);
                }
                catch (Throwable throwable) {
                    if (debug != null) {
                        debug.println(debugID, "Kernel/navigate: trapped refresh exception", throwable);
                    }
                    Kernel.fatalError(currentPage, "refresh", throwable);
                }
            }
            catch (Throwable throwable) {}
            return;
        }
        application.propertyChange(new PropertyChangeEvent(identity, "navigate", page.getClass(), clazz));
        Class clazz2 = class$net$dialang$mytest$jam$Quit;
        if (clazz2 == null) {
            clazz2 = class$net$dialang$mytest$jam$Quit = Kernel.class$("[Lnet.dialang.mytest.jam.Quit;", false);
        }
        if (clazz == clazz2) {
            application.quit();
            return;
        }
        Class clazz3 = class$net$dialang$mytest$jam$Page;
        if (clazz3 == null) {
            clazz3 = class$net$dialang$mytest$jam$Page = Kernel.class$("[Lnet.dialang.mytest.jam.Page;", false);
        }
        if (!Kernel.isInterface(clazz, clazz3)) {
            throw new JamException("navigator returned class is not a page: " + clazz);
        }
        Kernel.toPage(clazz);
    }

    static void toPage(Class clazz) {
        try {
            Page page = Kernel.getPage(clazz);
            if (!page.isBuilt()) {
                if (debug != null) {
                    debug.println(debugID, "page build");
                }
                page.build();
            }
            if (currentPage != null) {
                Kernel.invokeAndWait(AWT_unMap);
            }
            currentPage = page;
            Kernel.invokeAndWait(AWT_showPage);
        }
        catch (Throwable throwable) {
            Kernel.fatalError(currentPage, "toPage", throwable);
        }
    }

    static Page getPage(Class clazz) {
        Page page = (Page)pages.get(clazz);
        if (page == null) {
            if (debug != null) {
                debug.println(debugID, "page cache miss", clazz.getName());
            }
            try {
                page = (Page)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new PageNotFoundException(clazz.getName());
            }
            catch (InstantiationException instantiationException) {
                throw new PageNotFoundException(clazz.getName());
            }
        } else if (debug != null) {
            debug.println(debugID, "page cache hit", clazz.getName());
        }
        return page;
    }

    static Display getDisplay(Class clazz) {
        Display display = (Display)displays.get(clazz);
        if (display == null) {
            try {
                display = (Display)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new PageNotFoundException(clazz.getName());
            }
            catch (InstantiationException instantiationException) {
                throw new PageNotFoundException(clazz.getName());
            }
        }
        return display;
    }

    static JFrame createFrame(Display display, String string) {
        JFrame jFrame = new JFrame(string);
        frames.put(display, jFrame);
        return jFrame;
    }

    static JWindow createWindow(Display display) {
        JWindow jWindow = new JWindow();
        windows.put(display, jWindow);
        return jWindow;
    }

    static JFrame getFrame(Display display) {
        return (JFrame)frames.get(display);
    }

    static JWindow getWindow(Display display) {
        return (JWindow)windows.get(display);
    }

    static void dispose() {
        Enumeration enumeration = frames.elements();
        while (enumeration.hasMoreElements()) {
            ((JFrame)enumeration.nextElement()).dispose();
        }
        enumeration = windows.elements();
        while (enumeration.hasMoreElements()) {
            ((JWindow)enumeration.nextElement()).dispose();
        }
    }

    static boolean isInterface(Class clazz, Class clazz2) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n] == clazz2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static final void invokeAndWait(Runnable runnable) throws Throwable {
        try {
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeAndWait(runnable);
            }
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof JamWrapperException) {
                throwable = ((JamWrapperException)throwable).getTargetException();
            }
            throw throwable;
        }
    }

    static final void invokeLater(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    static /* synthetic */ Page access$0() {
        return currentPage;
    }

    static /* synthetic */ Navigator access$1() {
        return navigator;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    Kernel() {
    }

    static {
        identity = new Kernel();
        inError = false;
        debugID = 0;
        pages = new Hashtable();
        frames = new Hashtable();
        windows = new Hashtable();
        displays = new Hashtable();
        AWT_refresh = new 1();
        AWT_unMap = new 2();
        AWT_showPage = new 3();
    }
}

