/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.mytest.mux;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.dialang.mytest.mux.MuxEvent;
import net.dialang.mytest.mux.MuxEventListener;
import net.dialang.mytest.mux.MuxInput;
import net.dialang.mytest.mux.MuxOutput;

public class Mux
implements MuxEventListener,
MuxOutput,
MuxInput {
    private Vector inputs = new Vector();
    private Vector outputs = new Vector();
    private boolean triggered = false;
    private Hashtable triggers = new Hashtable();
    private String name;

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void addMuxEventListener(MuxEventListener muxEventListener) {
        this.addOutput((MuxOutput)((Object)muxEventListener));
    }

    public void addOutput(MuxOutput muxOutput) {
        if (this.equals(muxOutput)) {
            throw new IllegalArgumentException("output is self");
        }
        if (this.outputs.contains(muxOutput)) {
            return;
        }
        this.outputs.add(muxOutput);
        if (muxOutput instanceof Mux) {
            ((Mux)muxOutput).addInput(this);
        }
    }

    public void removeAll() {
        this.inputs.clear();
        this.reset();
    }

    public void addInput(MuxInput muxInput) {
        if (this.equals(muxInput)) {
            throw new IllegalArgumentException("input is self");
        }
        if (this.inputs.contains(muxInput)) {
            return;
        }
        this.inputs.addElement(muxInput);
        muxInput.addMuxEventListener(this);
        if (muxInput instanceof Mux) {
            ((Mux)muxInput).addOutput(this);
        }
    }

    public void reset() {
        this.triggers.clear();
        this.triggered = false;
    }

    public int numInputs() {
        return this.inputs.size();
    }

    public int numOutputs() {
        return this.outputs.size();
    }

    public Enumeration getInputs() {
        return this.inputs.elements();
    }

    public void fireEvent(MuxEvent muxEvent) {
        if (this.triggered) {
            return;
        }
        this.triggers.put(muxEvent.getSource(), muxEvent.getSource());
        if (this.triggers.size() != this.inputs.size()) {
            return;
        }
        if (this.triggered) {
            return;
        }
        Mux mux = this;
        synchronized (mux) {
            this.triggered = true;
            muxEvent = new MuxEvent(this);
            Enumeration enumeration = this.outputs.elements();
            while (enumeration.hasMoreElements()) {
                MuxOutput muxOutput = (MuxOutput)enumeration.nextElement();
                muxOutput.fireEvent(muxEvent);
            }
        }
    }

    public Mux() {
    }

    public Mux(MuxOutput muxOutput) {
        this();
        this.outputs.add(muxOutput);
        if (muxOutput instanceof Mux) {
            ((Mux)muxOutput).addInput(this);
        }
    }
}

