/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.mytest.queue;

import java.io.PrintStream;
import java.util.Vector;
import net.dialang.mytest.queue.QueueEvent;
import net.dialang.mytest.queue.QueueListener;

public class Queue {
    private Vector monitorQueue = new Vector();
    private Thread queueManager;
    private boolean hardStop;
    private boolean softStop;
    private QueueEvent qe = new QueueEvent(this);
    private QueueListener queueListener;
    private boolean finished;
    private Object stopObject = new Object();
    private Runnable runner;
    private int priority = 5;
    private PrintStream out;

    public void setDebug(PrintStream printStream) {
        this.out = printStream;
    }

    public QueueListener addQueueListener(QueueListener queueListener) {
        QueueListener queueListener2 = this.queueListener;
        this.queueListener = queueListener;
        return queueListener2;
    }

    private void notifier() {
        Object object;
        block8: while (true) {
            if (this.hardStop) {
                this.debug("hardstop detected");
                break;
            }
            object = this.monitorQueue;
            synchronized (object) {
                while (this.monitorQueue.size() == 0) {
                    if (this.softStop) {
                        this.debug("softstop detected");
                    } else {
                        try {
                            this.monitorQueue.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!this.hardStop) continue;
                        this.debug("hardstop detected");
                    }
                    Object var2_3 = null;
                    break block8;
                }
            }
            this.queueListener.objectAvailable(this.qe);
        }
        this.debug("notifier - finishing");
        this.finished = true;
        object = this.stopObject;
        synchronized (object) {
            this.stopObject.notify();
        }
    }

    public void flush() {
        if (!this.finished) {
            this.stop();
        }
        this.monitorQueue.clear();
    }

    public void start() {
        if (this.queueListener == null) {
            throw new RuntimeException("no listener set");
        }
        this.stop();
        this.finished = false;
        this.hardStop = false;
        this.softStop = false;
        this.queueManager = new Thread(this.runner);
        this.queueManager.setPriority(this.priority);
        this.queueManager.start();
    }

    public void stop() {
        this.debug("stop");
        this.hardStop = true;
        this.waitForFinish();
        this.queueManager = null;
    }

    public void stopWait() {
        this.debug("stopWait");
        this.softStop = true;
        this.waitForFinish();
        this.queueManager = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForFinish() {
        if (this.queueManager == null) {
            return;
        }
        if (!this.queueManager.isAlive()) {
            return;
        }
        Object object = this.monitorQueue;
        synchronized (object) {
            this.monitorQueue.notify();
        }
        object = this.stopObject;
        synchronized (object) {
            while (true) {
                if (this.finished) {
                    return;
                }
                try {
                    this.debug("stop - wait for notify");
                    this.stopObject.wait();
                    this.debug("stop - got notify");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public Object pop() {
        if (this.monitorQueue.isEmpty()) {
            return null;
        }
        return this.monitorQueue.remove(0);
    }

    public void push(Object object) {
        this.monitorQueue.add(object);
        Vector vector = this.monitorQueue;
        synchronized (vector) {
            this.monitorQueue.notify();
        }
    }

    public int getSize() {
        return this.monitorQueue.size();
    }

    public void setPriority(int n) {
        this.priority = n;
        if (this.queueManager != null) {
            this.queueManager.setPriority(this.priority);
        }
    }

    private void debug(String string) {
        if (this.out != null) {
            this.out.println("queue: " + string);
        }
    }

    static /* synthetic */ void access$0(Queue queue) {
        queue.notifier();
    }

    public Queue() {
        Queue queue = this;
        if (queue == null) {
            throw null;
        }
        this.runner = new Runnable(queue){
            private final /* synthetic */ Queue this$0;

            public void run() {
                Queue.access$0(this.this$0);
            }
            {
                this.this$0 = queue;
                this.constructor$0(queue);
            }

            private final void constructor$0(Queue queue) {
            }
        };
    }

    public Queue(QueueListener queueListener) {
        this();
        this.queueListener = queueListener;
    }
}

