/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.mytest.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Iterator;
import net.dialang.common.Answer;
import net.dialang.common.GapDropItem;
import net.dialang.common.GapTextItem;
import net.dialang.mytest.io.Utils;
import net.dialang.mytest.util.ItemUtils;
import uk.ac.lancs.ling.proto.common.Item;
import uk.ac.lancs.ling.proto.common.MCQItem;
import uk.ac.lancs.ling.proto.common.ShortAnswerItem;
import uk.ac.lancs.ling.proto.entity.GapTextModel;
import uk.ac.lancs.ling.proto.entity.MCQModel;
import uk.ac.lancs.ling.proto.entity.ShortAnswerModel;
import uk.ac.lancs.ling.proto.entity.SubSkill;

public class ItemConverter {
    public final void convertItem(File file, File file2) throws ClassNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        Object object = Utils.readGZIPObject(fileInputStream);
        net.dialang.common.Item item = null;
        if (object instanceof uk.ac.lancs.ling.proto.common.GapDropItem) {
            object = (uk.ac.lancs.ling.proto.common.GapDropItem)object;
            item = new GapDropItem(ItemUtils.getProtoItemID((Item)object));
            item = (GapDropItem)this.copyItem(item, object);
        } else if (object instanceof GapTextModel) {
            object = (uk.ac.lancs.ling.proto.common.GapTextItem)object;
            item = new GapTextItem(ItemUtils.getProtoItemID((Item)object));
            item = (GapTextItem)this.copyItem(item, object);
        } else if (object instanceof MCQModel) {
            object = (MCQItem)object;
            item = new net.dialang.common.MCQItem(ItemUtils.getProtoItemID((Item)object));
            item = (net.dialang.common.MCQItem)this.copyItem(item, object);
        } else if (object instanceof ShortAnswerModel) {
            object = (ShortAnswerItem)object;
            item = new net.dialang.common.ShortAnswerItem(ItemUtils.getProtoItemID((Item)object));
            item = (net.dialang.common.ShortAnswerItem)this.copyItem(item, object);
        } else {
            System.out.print("Unrecognized Class: ");
            System.out.println(object.getClass().toString());
            this.printDetails(file.getAbsolutePath(), file2.getAbsolutePath());
        }
        this.printDetails(file.getAbsolutePath(), file2.getAbsolutePath());
        Utils.writeGZIPObject((Object)item, fileOutputStream);
    }

    private final void printDetails(String string, String string2) {
        System.out.println("Porting " + string + " to " + string2);
    }

    private final void dumpObject(String string, Object object) {
        System.out.println(string);
        System.out.println("Object Class Type: " + object.getClass().toString());
        System.out.println("Object Data: \n" + object);
    }

    private final net.dialang.common.Item copyItem(Object object, Object object2) {
        net.dialang.common.Item item = (net.dialang.common.Item)object;
        Item item2 = (Item)object2;
        String string = item2.getText();
        if (string != null) {
            item.setText(string);
        }
        item.setWeight(item2.getWeight());
        net.dialang.entity.SubSkill subSkill = null;
        SubSkill subSkill2 = item2.getSubSkill();
        if (subSkill2 != null) {
            subSkill = new net.dialang.entity.SubSkill(subSkill2.getSkillKey(), subSkill2.getSubKey());
            subSkill.setEnabled(subSkill2.isEnabled());
        }
        item.setSubSkill(subSkill);
        Answer answer = null;
        Iterator iterator = item2.getAnswers();
        while (iterator.hasNext()) {
            uk.ac.lancs.ling.proto.common.Answer answer2 = (uk.ac.lancs.ling.proto.common.Answer)iterator.next();
            answer = new Answer(answer2.getText(), answer2.isCorrect());
            item.addAnswer(answer);
        }
        return item;
    }

    public static void straightCopy(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        int n = -1;
        while ((n = fileInputStream.read()) != -1) {
            fileOutputStream.write(n);
        }
        fileOutputStream.close();
        fileInputStream.close();
    }

    public static void main(String[] stringArray) {
        File file;
        String string = null;
        String string2 = null;
        if (stringArray.length != 2) {
            string = "/home/dialang/projects/dialangv1/initcache.old";
            string2 = "/home/dialang/projects/dialangv1/initcache";
            System.out.println("Usage: ItemConverter [sourcedir] [targetdir]");
            System.out.println("Using default source directory: " + string);
            System.out.println("Using default target directory: " + string2);
        } else {
            string = stringArray[0];
            string2 = stringArray[1];
        }
        File file2 = new File(string);
        if (!file2.isDirectory()) {
            System.out.println("The source directory supplied is invalid");
            System.exit(0);
        }
        if (!(file = new File(string2)).isDirectory()) {
            System.out.println("The target directory supplied is invalid");
            System.exit(0);
        }
        File[] fileArray = file2.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".dcf") || string.endsWith(".gzo") || string.endsWith(".jpg") || string.endsWith(".mp2") || string.endsWith(".html");
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        ItemConverter itemConverter = new ItemConverter();
        int n = 0;
        while (n < fileArray.length) {
            String string3 = fileArray[n].getName();
            File file3 = new File(file, string3);
            try {
                if (string3.endsWith(".jpg") || string3.endsWith(".mp2") || string3.endsWith(".html")) {
                    ItemConverter.straightCopy(fileArray[n], file3);
                } else {
                    itemConverter.convertItem(fileArray[n], file3);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("ClassNotFoundException while porting file '" + fileArray[n].getName() + "'");
            }
            catch (IOException iOException) {
                System.out.println("IOException while porting file '" + fileArray[n].getName() + "'");
                try {
                    ItemConverter.straightCopy(fileArray[n], file3);
                }
                catch (IOException iOException2) {
                    System.out.println("Failed to copy file: " + string3);
                }
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("NullPointerException while porting file '" + fileArray[n].getName() + "'");
                nullPointerException.printStackTrace();
            }
            ++n;
        }
    }
}

