/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.mytest.xmltools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import net.dialang.common.Answer;
import net.dialang.common.Item;
import net.dialang.entity.GapDropModel;
import net.dialang.entity.GapTextModel;
import net.dialang.entity.ImageMediaModel;
import net.dialang.entity.ItemTypeModel;
import net.dialang.entity.MCQModel;
import net.dialang.entity.MediaModel;
import net.dialang.entity.NoMediaModel;
import net.dialang.entity.ShortAnswerModel;
import net.dialang.entity.SoundMediaModel;
import net.dialang.entity.SubSkill;
import net.dialang.entity.TabbedPaneModel;
import net.dialang.entity.TextMediaModel;

public final class ItemToXML {
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!DOCTYPE questestinterop SYSTEM \"http://ambu.lancs.ac.uk/dtd/ims_qtiv1p1_dialang.dtd\">\n<!-- This xml file was machine generated by net.dialang.admin.xmltools.ItemToXML -->\n<questestinterop>\n";
    public static boolean debug = false;

    public static final void exportItem(ItemTypeModel itemTypeModel, String string, OutputStream outputStream) throws Exception {
        try {
            if (itemTypeModel instanceof MCQModel) {
                ItemToXML.exportMCQModel((MCQModel)itemTypeModel, string, outputStream);
            } else if (itemTypeModel instanceof GapTextModel) {
                ItemToXML.exportGapTextModel((GapTextModel)itemTypeModel, string, outputStream);
            } else if (itemTypeModel instanceof GapDropModel) {
                ItemToXML.exportGapDropModel((GapDropModel)itemTypeModel, string, outputStream);
            } else if (itemTypeModel instanceof ShortAnswerModel) {
                ItemToXML.exportShortAnswerModel((ShortAnswerModel)itemTypeModel, string, outputStream);
            } else if (itemTypeModel instanceof TabbedPaneModel) {
                ItemToXML.exportTabbedPaneModel((TabbedPaneModel)itemTypeModel, string, outputStream);
            }
        }
        catch (IOException iOException) {
            if (debug) {
                System.err.println(iOException.getMessage());
            }
            throw new Exception(iOException.getMessage());
        }
    }

    public static final void exportItem(File file, OutputStream outputStream) throws Exception {
        String string = file.getName();
        if (debug) {
            System.out.println("Processing " + string);
        }
        ItemTypeModel itemTypeModel = ItemToXML.getItemTypeModel(file);
        ItemToXML.exportItem(itemTypeModel, string, outputStream);
    }

    private static final ItemTypeModel getItemTypeModel(File file) throws Exception {
        try {
            ItemTypeModel itemTypeModel = (ItemTypeModel)ItemToXML.readGZIPObject(new FileInputStream(file));
            return itemTypeModel;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (debug) {
                System.err.println(fileNotFoundException.getMessage());
            }
            throw new Exception(fileNotFoundException.getMessage());
        }
        catch (SecurityException securityException) {
            if (debug) {
                System.err.println(securityException.getMessage());
            }
            throw new Exception(securityException.getMessage());
        }
        catch (IOException iOException) {
            if (debug) {
                System.err.println(iOException.getMessage());
            }
            throw new Exception(iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (debug) {
                System.err.println(classNotFoundException.getMessage());
            }
            throw new Exception(classNotFoundException.getMessage());
        }
    }

    private static final void exportMCQModel(MCQModel mCQModel, String string, OutputStream outputStream) throws IOException {
        if (debug) {
            System.out.println("Exporting MCQ Model: " + string);
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write(XML_HEADER);
        outputStreamWriter.write("<section title=\"MCQModel ");
        outputStreamWriter.write(string);
        outputStreamWriter.write("\" ident=\"");
        outputStreamWriter.write(mCQModel.getID() + "\">\n");
        ItemToXML.writeMediaBlock(mCQModel, outputStreamWriter);
        ItemToXML.dumpMCQItem(mCQModel.getItem(), string, outputStreamWriter);
        outputStreamWriter.write("</section>\n</questestinterop>\n");
        outputStreamWriter.close();
    }

    private static final void dumpMCQItem(Item item, String string, OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write("<item title=\"MCQItem ");
        outputStreamWriter.write(string);
        outputStreamWriter.write("\" ident=\"");
        outputStreamWriter.write(Integer.toString(item.getID()) + "\">\n");
        outputStreamWriter.write("<itemmetadata>\n<qmd_itemtype>");
        outputStreamWriter.write("Logical Identifier</qmd_itemtype>\n");
        outputStreamWriter.write("<qmd_renderingtype>Choice</qmd_renderingtype>\n");
        outputStreamWriter.write("<qmd_responsetype>Single</qmd_responsetype>\n");
        ItemToXML.writeTopicBlock(item, outputStreamWriter);
        outputStreamWriter.write("<qmd_weighting>");
        outputStreamWriter.write(Integer.toString(item.getWeight()));
        outputStreamWriter.write("</qmd_weighting>\n");
        outputStreamWriter.write("</itemmetadata>\n");
        outputStreamWriter.write("<presentation>\n<flow>\n");
        String string2 = item.getText();
        if (string2 != null && string2.length() > 0) {
            outputStreamWriter.write("<material label=\"Stem\">\n<mattext>");
            outputStreamWriter.write(ItemToXML.convertHTMLTags(string2));
            outputStreamWriter.write("</mattext>\n</material>\n");
        }
        outputStreamWriter.write("<flow>\n<response_lid ident=\"MC01\">\n");
        outputStreamWriter.write("<render_choice shuffle=\"Yes\">\n");
        int n = 1;
        int n2 = -1;
        int n3 = 0;
        Iterator iterator = item.getAnswers();
        while (iterator.hasNext()) {
            ++n3;
            outputStreamWriter.write("<response_label ident=\"");
            outputStreamWriter.write(Integer.toString(n++));
            outputStreamWriter.write("\">\n<material>\n<mattext>");
            Answer answer = (Answer)iterator.next();
            if (answer.isCorrect()) {
                n2 = n3;
            }
            outputStreamWriter.write(answer.getText());
            outputStreamWriter.write("</mattext>\n</material>\n</response_label>\n");
        }
        outputStreamWriter.write("</render_choice>\n</response_lid>\n");
        outputStreamWriter.write("</flow>\n</flow>\n</presentation>\n");
        outputStreamWriter.write("<resprocessing>\n<outcomes>\n");
        outputStreamWriter.write("<decvar vartype=\"Integer\" defaultval=\"0\"/>\n</outcomes>\n");
        outputStreamWriter.write("<respcondition title=\"Correct\">\n<conditionvar>\n");
        outputStreamWriter.write("<varequal respident=\"MC01\">");
        outputStreamWriter.write(Integer.toString(n2));
        outputStreamWriter.write("</varequal>\n</conditionvar>\n");
        outputStreamWriter.write("<setvar action=\"Set\">1</setvar>\n");
        outputStreamWriter.write("</respcondition>\n</resprocessing>\n");
        outputStreamWriter.write("</item>\n");
    }

    private static final void exportShortAnswerModel(ShortAnswerModel shortAnswerModel, String string, OutputStream outputStream) throws IOException {
        if (debug) {
            System.out.println("Exporting Short Answer Model: " + string);
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write(XML_HEADER);
        outputStreamWriter.write("<section title=\"ShortAnswerModel ");
        outputStreamWriter.write(string);
        outputStreamWriter.write("\" ident=\"");
        outputStreamWriter.write(shortAnswerModel.getID() + "\">\n");
        ItemToXML.writeMediaBlock(shortAnswerModel, outputStreamWriter);
        String string2 = shortAnswerModel.getPrompt();
        if (string2 != null) {
            outputStreamWriter.write("<rubric>\n<material label=\"Stem\">\n<mattext>");
            outputStreamWriter.write(string2);
            outputStreamWriter.write("</mattext>\n</material>\n</rubric>\n");
        }
        Iterator iterator = shortAnswerModel.items();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            outputStreamWriter.write("<item title=\"ShortAnswerItem\"");
            outputStreamWriter.write(" ident=\"");
            outputStreamWriter.write(item.getID() + "\">\n");
            outputStreamWriter.write("<itemmetadata>\n<qmd_itemtype>");
            outputStreamWriter.write("String</qmd_itemtype>\n");
            outputStreamWriter.write("<qmd_renderingtype>String</qmd_renderingtype>\n");
            outputStreamWriter.write("<qmd_responsetype>Single</qmd_responsetype>\n");
            ItemToXML.writeTopicBlock(item, outputStreamWriter);
            outputStreamWriter.write("<qmd_weighting>");
            outputStreamWriter.write(Integer.toString(item.getWeight()));
            outputStreamWriter.write("</qmd_weighting>\n");
            outputStreamWriter.write("</itemmetadata>\n");
            outputStreamWriter.write("<presentation>\n<flow>\n");
            outputStreamWriter.write("<material label=\"Question\">\n<mattext>");
            outputStreamWriter.write(item.getText());
            outputStreamWriter.write("</mattext>\n</material>\n");
            outputStreamWriter.write("<response_str ident=\"1\">\n");
            outputStreamWriter.write("<render_fib fibtype=\"String\"/>\n");
            outputStreamWriter.write("</response_str>\n");
            outputStreamWriter.write("</flow>\n</presentation>\n");
            outputStreamWriter.write("<resprocessing>\n<outcomes>\n");
            outputStreamWriter.write("<decvar varname=\"SCORE\" vartype=\"Integer\"");
            outputStreamWriter.write(" defaultval=\"0\"/>\n</outcomes>\n");
            ItemToXML.writeResConditionBlock(item, "SCORE", "1", false, outputStreamWriter);
            outputStreamWriter.write("</resprocessing>\n");
            outputStreamWriter.write("</item>\n");
        }
        outputStreamWriter.write("</section>\n</questestinterop>\n");
        outputStreamWriter.close();
    }

    private static final void exportGapDropModel(GapDropModel gapDropModel, String string, OutputStream outputStream) throws IOException {
        if (debug) {
            System.out.println("Exporting Gap Drop item: " + string);
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write(XML_HEADER);
        outputStreamWriter.write("<section title=\"GapDropModel ");
        outputStreamWriter.write(string);
        outputStreamWriter.write("\" ident=\"");
        outputStreamWriter.write(gapDropModel.getID() + "\">\n");
        ItemToXML.writeMediaBlock(gapDropModel, outputStreamWriter);
        String string2 = gapDropModel.getPrompt();
        if (string2 != null) {
            outputStreamWriter.write("<rubric>\n<material label=\"Stem\">\n<mattext>");
            outputStreamWriter.write(string2);
            outputStreamWriter.write("</mattext>\n</material>\n</rubric>\n");
        }
        outputStreamWriter.write("<presentation>\n<flow>\n");
        Object[] objectArray = gapDropModel.getGapText().toArray();
        if (objectArray.length <= 0) {
            outputStreamWriter.write("</flow>\n");
            outputStreamWriter.write("</presentation>\n</section>\n</questestinterop>\n");
            outputStreamWriter.close();
            return;
        }
        Iterator iterator = gapDropModel.items();
        int n = 0;
        while (n < objectArray.length) {
            Object object;
            if (objectArray[n] instanceof String) {
                object = (String)objectArray[n];
                if (((String)object).trim().length() != 0) {
                    outputStreamWriter.write("<material>\n<mattext>");
                    outputStreamWriter.write((String)objectArray[n]);
                    outputStreamWriter.write("</mattext>\n</material>\n");
                }
            } else if (objectArray[n] instanceof Integer && iterator.hasNext()) {
                object = (Item)iterator.next();
                ItemToXML.dumpMCQItem((Item)object, string, outputStreamWriter);
            }
            ++n;
        }
        outputStreamWriter.write("</flow>\n</presentation>\n");
        outputStreamWriter.write("</section>\n</questestinterop>\n");
        outputStreamWriter.close();
    }

    private static final void exportGapTextModel(GapTextModel gapTextModel, String string, OutputStream outputStream) throws IOException {
        if (debug) {
            System.out.println("Exporting Gap Text item: " + string);
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write(XML_HEADER);
        outputStreamWriter.write("<section title=\"GapTextModel ");
        outputStreamWriter.write(string);
        outputStreamWriter.write("\" ident=\"");
        outputStreamWriter.write(gapTextModel.getID() + "\">\n");
        ItemToXML.writeMediaBlock(gapTextModel, outputStreamWriter);
        String string2 = gapTextModel.getPrompt();
        if (string2 != null) {
            outputStreamWriter.write("<rubric>\n<material label=\"Stem\">\n<mattext>");
            outputStreamWriter.write(string2);
            outputStreamWriter.write("</mattext>\n</material>\n</rubric>\n");
        }
        outputStreamWriter.write("<presentation>\n<flow>\n");
        Object[] objectArray = gapTextModel.getGapText().toArray();
        if (objectArray.length <= 0) {
            outputStreamWriter.write("</flow>\n");
            outputStreamWriter.write("</presentation>\n</section>\n</questestinterop>\n");
            outputStreamWriter.close();
            return;
        }
        Iterator iterator = gapTextModel.items();
        int n = 0;
        while (n < objectArray.length) {
            Object object;
            if (objectArray[n] instanceof String) {
                object = (String)objectArray[n];
                if (((String)object).trim().length() != 0) {
                    outputStreamWriter.write("<material>\n<mattext>");
                    outputStreamWriter.write((String)objectArray[n]);
                    outputStreamWriter.write("</mattext>\n</material>\n");
                }
            } else if (objectArray[n] instanceof Integer && iterator.hasNext()) {
                object = (Item)iterator.next();
                outputStreamWriter.write("<item ident=\"" + Integer.toString(((Item)object).getID()) + "\">\n");
                outputStreamWriter.write("<itemmetadata>\n<qmd_itemtype>");
                outputStreamWriter.write("String</qmd_itemtype>\n");
                outputStreamWriter.write("<qmd_renderingtype>String</qmd_renderingtype>\n");
                outputStreamWriter.write("<qmd_responsetype>Single</qmd_responsetype>\n");
                ItemToXML.writeTopicBlock((Item)object, outputStreamWriter);
                outputStreamWriter.write("<qmd_weighting>");
                outputStreamWriter.write(Integer.toString(((Item)object).getWeight()));
                outputStreamWriter.write("</qmd_weighting>\n");
                outputStreamWriter.write("</itemmetadata>\n");
                outputStreamWriter.write("<presentation>\n<response_str ident=\"" + ((Integer)objectArray[n]).toString() + "\">\n");
                outputStreamWriter.write("<render_fib fibtype=\"String\"/>\n");
                outputStreamWriter.write("</response_str>\n</presentation>\n");
                outputStreamWriter.write("<resprocessing>\n<outcomes>\n");
                outputStreamWriter.write("<decvar varname=\"SCORE\" vartype=\"Integer\"");
                outputStreamWriter.write(" defaultval=\"0\"/>\n</outcomes>\n");
                ItemToXML.writeResConditionBlock((Item)object, "SCORE", "1", false, outputStreamWriter);
                outputStreamWriter.write("</resprocessing>\n");
                outputStreamWriter.write("</item>\n");
            }
            ++n;
        }
        outputStreamWriter.write("</flow>\n</presentation>\n");
        outputStreamWriter.write("</section>\n</questestinterop>\n");
        outputStreamWriter.close();
    }

    private static final void exportTabbedPaneModel(TabbedPaneModel tabbedPaneModel, String string, OutputStream outputStream) throws IOException {
        if (debug) {
            System.out.println("Exporting Tabbed Pane Model: " + string);
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write(XML_HEADER);
        outputStreamWriter.write("<section title=\"TabbedPaneModel ");
        outputStreamWriter.write(string);
        outputStreamWriter.write("\" ident=\"");
        outputStreamWriter.write(tabbedPaneModel.getID() + "\">\n");
        ItemToXML.writeMediaBlock(tabbedPaneModel, outputStreamWriter);
        Iterator iterator = tabbedPaneModel.children();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof MCQModel)) continue;
            ItemToXML.dumpMCQItem(((MCQModel)e).getItem(), string, outputStreamWriter);
            outputStreamWriter.write("");
        }
        outputStreamWriter.write("</section>\n</questestinterop>\n");
        outputStreamWriter.close();
    }

    private static final String convertHTMLTags(String string) {
        if (string.indexOf(60) == -1 && string.indexOf(62) == -1 && string.indexOf(38) == -1) {
            return string;
        }
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(60, n2 + 1)) != -1) {
            ++n;
        }
        int n3 = 0;
        n2 = -1;
        while ((n2 = string.indexOf(62, n2 + 1)) != -1) {
            ++n3;
        }
        int n4 = 0;
        n2 = -1;
        while ((n2 = string.indexOf(62, n2 + 1)) != -1) {
            ++n4;
        }
        int n5 = string.length() + n * 3 + n3 * 3 + n4 * 4;
        StringBuffer stringBuffer = new StringBuffer(n5);
        int n6 = 0;
        while (n6 < string.length()) {
            char c = string.charAt(n6);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else {
                stringBuffer.append(c);
            }
            ++n6;
        }
        return stringBuffer.toString();
    }

    private static final void writeMediaBlock(ItemTypeModel itemTypeModel, OutputStreamWriter outputStreamWriter) throws IOException {
        String string;
        MediaModel mediaModel = itemTypeModel.getMediaModel();
        if (mediaModel == null || mediaModel instanceof NoMediaModel) {
            return;
        }
        outputStreamWriter.write("<rubric>\n");
        if (mediaModel instanceof TextMediaModel) {
            String string2 = ((TextMediaModel)mediaModel).getText();
            if (string2.endsWith(".wav")) {
                ItemToXML.writeWavTextMediaBlock(string2, outputStreamWriter);
                return;
            }
            string2 = ItemToXML.convertHTMLTags(string2);
            outputStreamWriter.write("<material label=\"Text Media Stem\">\n");
            outputStreamWriter.write("<mattext texttype=\"text/html\">");
            outputStreamWriter.write(string2);
            outputStreamWriter.write("</mattext>\n</material>\n");
        } else if (mediaModel instanceof ImageMediaModel) {
            String string3 = mediaModel.getRef();
            if (string3 != null) {
                outputStreamWriter.write("<material label=\"Image Media\">\n");
                outputStreamWriter.write("<matimage imagtype=\"image/jpeg\" uri=\"");
                outputStreamWriter.write("http://www.ling.lancs.ac.uk/istest/audiofiles/");
                outputStreamWriter.write(string3);
                outputStreamWriter.write("\"/>\n</material>\n");
            }
        } else if (mediaModel instanceof SoundMediaModel && (string = mediaModel.getRef()) != null) {
            outputStreamWriter.write("<material label=\"Sound Media\">\n");
            outputStreamWriter.write("<mataudio audiotype=\"audio/mp2\"");
            outputStreamWriter.write(" uri=\"http://www.ling.lancs.ac.uk/istest/audiofiles/");
            outputStreamWriter.write(string);
            outputStreamWriter.write("\"/>\n</material>\n");
        }
        outputStreamWriter.write("</rubric>\n");
    }

    private static final void writeWavTextMediaBlock(String string, OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write("<material label=\"Sound Media\">\n");
        outputStreamWriter.write("<mataudio audiotype=\"audio/wav\"");
        outputStreamWriter.write(" uri=\"http://www.ling.lancs.ac.uk/istest/audiofiles/");
        outputStreamWriter.write(string);
        outputStreamWriter.write("\"/>\n</material>\n");
    }

    public static final void dumpFailureMessage(String string, Exception exception) {
        System.out.println("Failed to process " + string);
        exception.printStackTrace(System.out);
    }

    private static final void writeResConditionBlock(Item item, String string, String string2, boolean bl, OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write("<respcondition>\n<conditionvar>\n");
        int n = item.getAnswerCount();
        if (n > 1) {
            outputStreamWriter.write("<or>\n");
        }
        int n2 = 1;
        Iterator iterator = item.getAnswers();
        while (iterator.hasNext()) {
            Answer answer = (Answer)iterator.next();
            outputStreamWriter.write("<varequal respident=\"" + Integer.toString(n2) + "\" case=\"Yes\">");
            if (bl) {
                ++n2;
            }
            outputStreamWriter.write(answer.getText());
            outputStreamWriter.write("</varequal>\n");
        }
        if (n > 1) {
            outputStreamWriter.write("</or>\n");
        }
        outputStreamWriter.write("</conditionvar>\n");
        outputStreamWriter.write("<setvar action=\"Add\" varname=\"");
        outputStreamWriter.write(string + "\">" + string2);
        outputStreamWriter.write("</setvar>\n</respcondition>\n");
    }

    private static final void writeTopicBlock(Item item, OutputStreamWriter outputStreamWriter) throws IOException {
        SubSkill subSkill = item.getSubSkill();
        if (subSkill == null) {
            return;
        }
        String string = subSkill.getVocabSubKey();
        if (string == null || string.length() == 0) {
            return;
        }
        outputStreamWriter.write("<qmd_topic>" + string + "</qmd_topic>\n");
    }

    public static final Object readGZIPObject(InputStream inputStream) throws ClassNotFoundException, IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new GZIPInputStream((InputStream)new BufferedInputStream(inputStream, 1024), 1024));
        return objectInputStream.readObject();
    }

    public static final void main(String[] stringArray) {
        String string;
        File file;
        if (stringArray.length != 2) {
            System.err.print("Usage: ItemToXML");
            System.err.println(" [source directory] [target directory]");
            System.exit(0);
        }
        if (!(file = new File(stringArray[0])).exists()) {
            System.err.println("Invalid source directory");
            System.exit(0);
        }
        if (!new File(string = stringArray[1]).exists()) {
            System.err.println("Invalid target directory");
            System.exit(0);
        }
        File[] fileArray = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".gzo");
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        Date date = new Date();
        int n = 0;
        while (n < fileArray.length) {
            try {
                String string2 = fileArray[n].getName();
                System.out.println("Processing file: " + string2);
                String string3 = string2.substring(0, string2.lastIndexOf(46) + 1) + "xml";
                ItemTypeModel itemTypeModel = (ItemTypeModel)ItemToXML.readGZIPObject(new FileInputStream(fileArray[n]));
                File file2 = new File(string);
                if (!file2.exists()) {
                    file2.mkdir();
                }
                File file3 = new File(file2, string3);
                ItemToXML.exportItem(itemTypeModel, fileArray[n].getName(), new FileOutputStream(file3));
            }
            catch (Exception exception) {
                ItemToXML.dumpFailureMessage(fileArray[n].getName(), exception);
            }
            ++n;
        }
        Date date2 = new Date();
        long l = date2.getTime() - date.getTime();
        System.out.println("Time Taken: " + Long.toString(l) + " milliseconds");
        System.exit(0);
    }
}

