/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.style;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.LineBorder;
import net.dialang.mytest.mux.MuxEvent;
import net.dialang.mytest.mux.MuxEventListener;
import net.dialang.mytest.mux.MuxInput;
import net.dialang.style.StyledToggleButton;

public class StyledTwinToggle
extends JPanel
implements ActionListener,
MuxInput {
    public static final boolean LEFT = false;
    public static final boolean RIGHT = true;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int UNSET = -1;
    private JToggleButton t;
    private JToggleButton f;
    private JPanel p;
    private Insets inset = new Insets(1, 1, 1, 1);
    private ActionListener actionListener;
    private String actionCommand;
    private boolean RHButtons;
    private Container thing;
    private MuxEventListener mel;
    private MuxEvent muxEvent;
    private ActionEvent actionEvent;

    public void setText(String string, String string2) {
        this.t.setText(string);
        this.t.setMnemonic(string.charAt(0));
        this.f.setText(string2);
        this.f.setMnemonic(string2.charAt(0));
    }

    public Container getContainer() {
        return this.thing;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public void addMuxEventListener(MuxEventListener muxEventListener) {
        this.mel = muxEventListener;
        this.muxEvent = new MuxEvent(this);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
        if (jToggleButton.equals(this.t)) {
            this.f.setSelected(!this.t.isSelected());
        } else if (jToggleButton.equals(this.f)) {
            this.t.setSelected(!this.f.isSelected());
        }
        if (this.mel != null) {
            this.mel.fireEvent(this.muxEvent);
        }
        if (this.actionListener != null) {
            this.actionEvent = new ActionEvent(this, 0, this.actionCommand);
            this.actionListener.actionPerformed(this.actionEvent);
        }
    }

    public int isSelected() {
        return this.t.isSelected() ? 1 : (this.f.isSelected() ? 0 : -1);
    }

    public void doClick(int n) {
        switch (n) {
            case 1: {
                this.t.doClick(0);
                break;
            }
            case 0: {
                this.f.doClick(0);
                break;
            }
            case -1: {
                this.f.doClick(0);
                this.t.doClick(0);
                break;
            }
            default: {
                throw new RuntimeException("StyledTwinToggle: invalid state (" + n + ") in doClick");
            }
        }
    }

    public void setSelected(int n) {
        switch (n) {
            case 0: {
                this.t.setSelected(false);
                this.f.setSelected(true);
                break;
            }
            case 1: {
                this.t.setSelected(true);
                this.f.setSelected(false);
                break;
            }
            case -1: {
                this.t.setSelected(false);
                this.f.setSelected(false);
                break;
            }
            default: {
                throw new RuntimeException("StyledTwinToggle: invalid state (" + n + ") in setSelected");
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(this.getName());
        stringBuffer.append(" True: ");
        stringBuffer.append(this.t.getModel().isSelected());
        stringBuffer.append(" False: ");
        stringBuffer.append(this.f.getModel().isSelected());
        return stringBuffer.toString();
    }

    public StyledTwinToggle(boolean bl, Container container) {
        super(new FlowLayout(bl ? 2 : 0));
        new BoxLayout(this, 0);
        this.RHButtons = bl;
        this.thing = container;
        this.p = new JPanel(new GridLayout(1, 2));
        this.t = new StyledToggleButton(null, null, this);
        this.t.setMargin(this.inset);
        StyledTwinToggle styledTwinToggle = this;
        if (styledTwinToggle == null) {
            throw null;
        }
        this.p.addFocusListener(new FocusListener(styledTwinToggle){
            private final /* synthetic */ StyledTwinToggle this$0;

            public void focusGained(FocusEvent focusEvent) {
                this.this$0.setBorder(new LineBorder(Color.black));
            }

            public void focusLost(FocusEvent focusEvent) {
                this.this$0.setBorder(null);
            }
            {
                this.this$0 = styledTwinToggle;
                this.constructor$0(styledTwinToggle);
            }

            private final void constructor$0(StyledTwinToggle styledTwinToggle) {
            }
        });
        this.f = new StyledToggleButton(null, null, this);
        this.f.setMargin(this.inset);
        Font font = this.t.getFont();
        font = new Font(font.getName(), font.getStyle(), 10);
        this.t.setFont(font);
        this.f.setFont(font);
        this.p.add(this.t);
        this.p.add(this.f);
        this.add(bl ? this.thing : this.p);
        this.add(bl ? this.p : this.thing);
    }
}

