/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.dialang.utils.MultiLineRecordReader;
import net.dialang.utils.RecordReader;

public class IOUtils {
    private static final int READBUFFER = 1024;
    private static final int WRITEBUFFER = 1024;

    public static Object readObject(InputStream inputStream) throws ClassNotFoundException, IOException {
        return IOUtils.readObject(inputStream, 1024);
    }

    public static Object readObject(InputStream inputStream, int n) throws ClassNotFoundException, IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream, n));
        return objectInputStream.readObject();
    }

    public static void writeObject(Object object, OutputStream outputStream) throws IOException {
        IOUtils.writeObject(object, outputStream, 1024);
    }

    public static void writeObject(Object object, OutputStream outputStream, int n) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(outputStream, n));
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
    }

    public static Object readObject(File file) throws IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        Object object = IOUtils.readObject(fileInputStream);
        fileInputStream.close();
        return object;
    }

    public static Object readObject(File file, int n) throws IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        Object object = IOUtils.readObject(fileInputStream, n);
        fileInputStream.close();
        return object;
    }

    public static void writeObject(Object object, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        IOUtils.writeObject(object, fileOutputStream);
        fileOutputStream.close();
    }

    public static void writeObject(Object object, File file, int n) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        IOUtils.writeObject(object, fileOutputStream, n);
        fileOutputStream.close();
    }

    public static Object readGZIPObject(InputStream inputStream) throws ClassNotFoundException, IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new GZIPInputStream((InputStream)new BufferedInputStream(inputStream, 1024), 1024));
        return objectInputStream.readObject();
    }

    public static Object readGZIPObject(InputStream inputStream, int n) throws ClassNotFoundException, IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new GZIPInputStream((InputStream)new BufferedInputStream(inputStream, n), n));
        return objectInputStream.readObject();
    }

    public static void writeGZIPObject(Object object, OutputStream outputStream) throws IOException {
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)new BufferedOutputStream(outputStream, 1024), 1024);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
        objectOutputStream.writeObject(object);
        gZIPOutputStream.finish();
        objectOutputStream.flush();
    }

    public static void writeGZIPObject(Object object, OutputStream outputStream, int n) throws IOException {
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)new BufferedOutputStream(outputStream, n), n);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
        objectOutputStream.writeObject(object);
        gZIPOutputStream.finish();
        objectOutputStream.flush();
    }

    public static Object readGZIPObject(File file) throws IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        Object object = IOUtils.readGZIPObject(fileInputStream);
        fileInputStream.close();
        return object;
    }

    public static Object readGZIPObject(File file, int n) throws IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        Object object = IOUtils.readGZIPObject(fileInputStream, n);
        fileInputStream.close();
        return object;
    }

    public static void writeGZIPObject(Object object, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        IOUtils.writeGZIPObject(object, fileOutputStream);
        fileOutputStream.close();
    }

    public static void writeGZIPObject(Object object, File file, int n) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        IOUtils.writeGZIPObject(object, fileOutputStream, n);
        fileOutputStream.close();
    }

    public static void stream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 1024);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 1024);
        while ((n = bufferedInputStream.read(byArray, 0, 1024)) > 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.flush();
    }

    public static void stream(InputStream inputStream, OutputStream outputStream, int n, int n2) throws IOException {
        int n3;
        byte[] byArray = new byte[n];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, n);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, n2);
        while (-1 != (n3 = bufferedInputStream.read(byArray, 0, n))) {
            int n4;
            do {
                n4 = n3 > n2 ? n2 : n3;
                bufferedOutputStream.write(byArray, 0, n4);
            } while ((n3 -= n4) > 0);
        }
        bufferedOutputStream.flush();
    }

    public static void loadVector(Vector vector, File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while (bufferedReader.ready()) {
            String string = bufferedReader.readLine();
            if (string == null || string.length() == 0 || string.startsWith("#")) continue;
            vector.add(string);
        }
        bufferedReader.close();
    }

    public static void loadRecordsVector(Vector vector, File file, char c, char c2) throws IOException {
        IOUtils.loadRecordsVector(vector, file, c, c2, false);
    }

    public static void loadRecordsVector(Vector vector, File file, char c, char c2, boolean bl) throws IOException {
        RecordReader recordReader = new RecordReader(new FileReader(file));
        recordReader.setDebug(bl);
        recordReader.setFieldSeparator(c);
        recordReader.setFieldWrapper(c2);
        while (recordReader.ready()) {
            Vector vector2 = recordReader.readRecord();
            if (vector2.size() == 0) continue;
            vector.add(vector2);
        }
        recordReader.close();
    }

    public static void loadMultiLineRecordsVector(Vector vector, File file, char c, char c2) throws IOException {
        IOUtils.loadMultiLineRecordsVector(vector, file, c, c2, false);
    }

    public static void loadMultiLineRecordsVector(Vector vector, File file, char c, char c2, boolean bl) throws IOException {
        MultiLineRecordReader multiLineRecordReader = new MultiLineRecordReader(new FileReader(file));
        multiLineRecordReader.setDebug(bl);
        multiLineRecordReader.setFieldSeparator(c);
        multiLineRecordReader.setFieldWrapper(c2);
        while (multiLineRecordReader.ready()) {
            Vector vector2 = multiLineRecordReader.readRecord();
            if (vector2.size() == 0) continue;
            vector.add(vector2);
        }
        multiLineRecordReader.close();
    }

    public static void zip(File file) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file.getPath() + ".zip"));
        zipOutputStream.setLevel(9);
        zipOutputStream.putNextEntry(new ZipEntry(file.getName()));
        FileInputStream fileInputStream = new FileInputStream(file);
        IOUtils.stream(fileInputStream, zipOutputStream);
        zipOutputStream.close();
        fileInputStream.close();
        file.delete();
    }
}

