/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.xmltools;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.dialang.common.DownloadSite;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class VersionInfo {
    private String versionNumber;
    private String versionDate;
    private ArrayList downloadSites = new ArrayList(5);
    private HashMap lowSeverityInstructions = new HashMap(14);
    private HashMap highSeverityInstructions = new HashMap(14);

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public String getVersionDate() {
        return this.versionDate;
    }

    public DownloadSite[] getDownloadSites() {
        DownloadSite[] downloadSiteArray = new DownloadSite[this.downloadSites.size()];
        return this.downloadSites.toArray(downloadSiteArray);
    }

    public HashMap getInstruction(boolean bl) {
        if (bl) {
            return this.highSeverityInstructions;
        }
        return this.lowSeverityInstructions;
    }

    static /* synthetic */ String access$0(VersionInfo versionInfo) {
        return versionInfo.versionNumber;
    }

    static /* synthetic */ String access$2(VersionInfo versionInfo) {
        return versionInfo.versionDate;
    }

    public VersionInfo(File file) throws Exception {
        this(new FileInputStream(file));
    }

    public VersionInfo(InputStream inputStream) throws Exception {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(false);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        VersionInfo versionInfo = this;
        if (versionInfo == null) {
            throw null;
        }
        sAXParser.parse(inputStream, (DefaultHandler)versionInfo.new VersionInfoHandler());
    }

    private class VersionInfoHandler
    extends DefaultHandler {
        private boolean downloadSite;
        private boolean lowSeverity;
        private boolean highSeverity;
        private String language;
        private String locale;

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("current_version")) {
                VersionInfo.this.versionNumber = attributes.getValue("number");
                VersionInfo.this.versionDate = attributes.getValue("date");
                this.downloadSite = false;
                this.lowSeverity = false;
                this.highSeverity = false;
            } else if (string3.equals("download_site")) {
                this.locale = attributes.getValue("locale");
                this.downloadSite = true;
                this.lowSeverity = false;
                this.highSeverity = false;
            } else if (string3.equals("low_severity")) {
                this.language = attributes.getValue("language");
                this.lowSeverity = true;
                this.downloadSite = false;
                this.highSeverity = false;
            } else if (string3.equals("high_severity")) {
                this.language = attributes.getValue("language");
                this.highSeverity = true;
                this.lowSeverity = false;
                this.downloadSite = false;
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.downloadSite) {
                String string = new String(cArray, n, n2);
                if (string.length() == 1) {
                    return;
                }
                VersionInfo.this.downloadSites.add(new DownloadSite(new String(cArray, n, n2), this.locale));
            } else if (this.lowSeverity) {
                if (!VersionInfo.this.lowSeverityInstructions.containsKey(this.language)) {
                    VersionInfo.this.lowSeverityInstructions.put(this.language, new String(cArray, n, n2));
                    return;
                }
                String string = (String)VersionInfo.this.lowSeverityInstructions.get(this.language);
                VersionInfo.this.lowSeverityInstructions.put(this.language, string + new String(cArray, n, n2));
            } else if (this.highSeverity) {
                if (!VersionInfo.this.highSeverityInstructions.containsKey(this.language)) {
                    VersionInfo.this.highSeverityInstructions.put(this.language, new String(cArray, n, n2));
                    return;
                }
                String string = (String)VersionInfo.this.highSeverityInstructions.get(this.language);
                VersionInfo.this.highSeverityInstructions.put(this.language, string + new String(cArray, n, n2));
            }
        }

        private VersionInfoHandler() {
        }
    }
}

