/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.video.h263;

import com.ibm.media.codec.video.VideoCodec;
import com.ibm.media.codec.video.h263.BitRateAdapter;
import com.ibm.media.codec.video.h263.EncodeControl;
import com.ibm.media.codec.video.h263.FrameProcessingAdapter;
import com.ibm.media.codec.video.h263.FrameRateAdapter;
import com.ibm.media.codec.video.h263.KeyFrameAdapter;
import com.ibm.media.codec.video.h263.PacketSizeAdapter;
import com.ibm.media.codec.video.h263.QualityAdapter;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.controls.H263Adapter;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class NativeEncoder
extends VideoCodec {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997, 1999.";
    static final int[] widths;
    static final int[] heights;
    private int videoWidth = 176;
    private int videoHeight = 144;
    int nativeFormat = 0;
    static final int DEFAULT_RTP_MTU = 984;
    static final int MAX_RTP_MTU = 1456;
    static final int DEFAULT_MAX_OUTPUT_LENGTH = 40960;
    public int maxOutputLength;
    public int targetOutputLength;
    long timeStamp = -1L;
    long sequenceNumber = 0L;
    long deltaFrames = 33366L;
    boolean useRtp = false;
    Control[] controls = null;
    float sourceFrameRate = 0.0f;
    float targetFrameRate = 0.0f;
    int minBitRate = 5000;
    int maxBitRate = 1000000;
    int useBitRate = 20000;
    int iFramePeriod = 15;
    int frameDecimation = 1;
    int frame2skip = 0;
    boolean initCompleted = false;
    boolean settingsChanged = false;
    boolean dropFrame = false;
    boolean okToDrop = false;
    EncodeControl encodeControl = null;
    public int nativeData = 0;
    int prevTr = 0;
    int tr;
    public boolean frameDone = true;
    int outputLength;
    boolean interFlag;
    VideoFormat h263RTPFormat = new VideoFormat("h263/rtp");

    static {
        int[] nArray = new int[8];
        nArray[1] = 128;
        nArray[2] = 176;
        nArray[3] = 352;
        nArray[4] = 704;
        nArray[5] = 1408;
        widths = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 96;
        nArray2[2] = 144;
        nArray2[3] = 288;
        nArray2[4] = 576;
        nArray2[5] = 1152;
        heights = nArray2;
    }

    public NativeEncoder() {
        this.supportedInputFormats = new VideoFormat[]{new YUVFormat(2)};
        this.defaultOutputFormats = new VideoFormat[]{new VideoFormat("h263"), new VideoFormat("h263/rtp")};
        this.PLUGIN_NAME = "H.263 Encoder";
    }

    public synchronized void close() {
        if (this.encodeControl != null) {
            this.encodeControl.close();
        }
        this.closeNativeEncoder();
        super.close();
    }

    public synchronized void closeNative() {
        this.closeNativeEncoder();
    }

    private native boolean closeNativeEncoder();

    private native boolean encodeFrameNative(Buffer var1, Buffer var2);

    public void finalize() {
        if (this.encodeControl != null) {
            this.encodeControl.frame.dispose();
            this.encodeControl = null;
        }
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[8];
            this.controls[0] = new H263Adapter(this, false, false, false, false, false, 0, 1000, false);
            this.controls[1] = new BitRateAdapter(this, this.useBitRate, this.minBitRate, this.maxBitRate, true);
            this.controls[2] = new KeyFrameAdapter(this, this.iFramePeriod, true);
            this.controls[3] = new QualityAdapter(this, 1.0f, 0.0f, 1.0f, false, true);
            this.controls[4] = new FrameRateAdapter(this, this.targetFrameRate, this.sourceFrameRate / 3.0f, this.sourceFrameRate, true);
            this.controls[5] = new FrameProcessingAdapter(this);
            this.controls[6] = new PacketSizeAdapter(this, this.targetOutputLength, true);
            this.encodeControl = new EncodeControl(this.controls);
            this.controls[7] = this.encodeControl;
        }
        return this.controls;
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension dimension = videoFormat.getSize();
        if (dimension == null) {
            return null;
        }
        this.videoWidth = dimension.width;
        this.videoHeight = dimension.height;
        this.supportedOutputFormats = new VideoFormat[2];
        int n2 = 0;
        while (n2 < 2) {
            float f2 = videoFormat.getFrameRate();
            if (n2 == 2) {
                f2 /= 2.0f;
            }
            if (n2 == 4) {
                f2 /= 3.0f;
            }
            this.supportedOutputFormats[n2++] = new VideoFormat("h263", new Dimension(dimension), -1, Format.byteArray, f2);
            this.supportedOutputFormats[n2++] = new VideoFormat("h263/rtp", new Dimension(dimension), -1, Format.byteArray, f2);
        }
        return this.supportedOutputFormats;
    }

    protected void initEncoder() {
        if (this.maxOutputLength != this.outputFormat.getMaxDataLength()) {
            VideoFormat videoFormat = this.outputFormat;
            this.outputFormat = new VideoFormat(videoFormat.getEncoding(), videoFormat.getSize(), this.maxOutputLength, Format.byteArray, videoFormat.getFrameRate());
        }
        this.closeNative();
        if (this.useRtp) {
            this.initNativeEncoder(this.nativeFormat, this.targetOutputLength, this.sourceFrameRate, this.targetFrameRate, this.useBitRate, this.iFramePeriod);
        } else {
            this.initNativeEncoder(this.nativeFormat, 0, this.sourceFrameRate, this.targetFrameRate, this.useBitRate, this.iFramePeriod);
        }
    }

    private native boolean initNativeEncoder(int var1, int var2, float var3, float var4, int var5, int var6);

    public void open() throws ResourceUnavailableException {
        if (this.videoWidth == 128 && this.videoHeight == 96) {
            this.nativeFormat = 0;
        } else if (this.videoWidth == 176 && this.videoHeight == 144) {
            this.nativeFormat = 1;
        } else if (this.videoWidth == 352 && this.videoHeight == 288) {
            this.nativeFormat = 2;
        } else {
            Log.error("Class: " + this);
            Log.error("  can only encode in sizes: 128x96, 176x144, 352x288.");
            throw new ResourceUnavailableException("could not load jmvh263");
        }
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmh263enc");
            super.open();
            if (this.encodeControl != null) {
                this.encodeControl.open(this.controls);
            }
            return;
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
            throw new ResourceUnavailableException("could not load jmvh263");
        }
    }

    public synchronized int process(Buffer buffer, Buffer buffer2) {
        if (!this.initCompleted) {
            this.initCompleted = true;
            this.initEncoder();
        }
        if (this.okToDrop && this.dropFrame) {
            this.dropFrame = false;
            buffer2.setDiscard(true);
            if (this.settingsChanged) {
                this.reset();
            }
            return 0;
        }
        this.okToDrop = false;
        if (this.frameDone) {
            ++this.frame2skip;
            if (this.frame2skip != this.frameDecimation) {
                this.updateOutput(buffer2, this.outputFormat, 0, 0);
                return 4;
            }
            this.frame2skip = 0;
            if (!this.checkInputBuffer(buffer)) {
                return 1;
            }
            if (this.isEOM(buffer)) {
                this.propagateEOM(buffer2);
                this.okToDrop = true;
                if (this.settingsChanged) {
                    this.reset();
                }
                return 0;
            }
        }
        VideoFormat videoFormat = (VideoFormat)buffer.getFormat();
        int n2 = buffer.getLength();
        int n3 = videoFormat.getMaxDataLength();
        int n4 = this.outputFormat.getMaxDataLength();
        int n5 = buffer.getOffset();
        if (n4 < 1456) {
            n4 = 1456;
        }
        byte[] byArray = (byte[])buffer.getData();
        byte[] byArray2 = this.validateByteArraySize(buffer2, n4);
        boolean bl = this.encodeFrameNative(buffer, buffer2);
        if (this.outputLength >= 0) {
            buffer2.setLength(this.outputLength);
        }
        if (this.useRtp) {
            buffer2.setSequenceNumber(this.sequenceNumber);
            ++this.sequenceNumber;
            if (this.frameDone) {
                this.timeStamp = buffer.getTimeStamp();
                this.prevTr = this.tr;
                int n6 = buffer2.getFlags();
                buffer2.setFlags(n6 |= 0x800);
            }
        } else {
            int n7 = buffer2.getFlags();
            n7 = !this.interFlag ? (n7 |= 0x10) : (n7 &= 0xFFFFFFEF);
            buffer2.setFlags(n7);
        }
        this.updateOutput(buffer2, this.outputFormat, buffer2.getLength(), 0);
        buffer2.setFormat(this.outputFormat);
        if (this.frameDone) {
            if (this.outputLength != -1) {
                this.okToDrop = true;
                if (this.settingsChanged) {
                    this.reset();
                }
                return 0;
            }
            return 4;
        }
        if (this.outputLength == -1) {
            return 6;
        }
        return 2;
    }

    public synchronized void reset() {
        this.initEncoder();
        this.settingsChanged = false;
    }

    protected native boolean setFramesBehind(int var1);

    public Format setInputFormat(Format format) {
        YUVFormat yUVFormat = (YUVFormat)super.setInputFormat(format);
        if (yUVFormat == null) {
            return null;
        }
        Dimension dimension = yUVFormat.getSize();
        if (dimension == null) {
            return null;
        }
        if (yUVFormat.getOffsetU() > yUVFormat.getOffsetV()) {
            return null;
        }
        this.videoWidth = dimension.width;
        this.videoHeight = dimension.height;
        this.sourceFrameRate = yUVFormat.getFrameRate();
        this.deltaFrames = (long)(1000000.0 / (double)yUVFormat.getFrameRate());
        if (this.opened) {
            VideoFormat videoFormat = new VideoFormat(this.outputFormat.getEncoding(), new Dimension(dimension), -1, Format.byteArray, yUVFormat.getFrameRate());
            this.close();
            this.setOutputFormat(videoFormat);
            try {
                this.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                return null;
            }
        }
        return format;
    }

    public Format setOutputFormat(Format format) {
        VideoFormat videoFormat = (VideoFormat)super.setOutputFormat(format);
        if (this.h263RTPFormat.matches(videoFormat)) {
            this.useRtp = true;
            this.maxOutputLength = 1456;
            this.targetOutputLength = 984;
        } else {
            this.useRtp = false;
            this.maxOutputLength = 40960;
            this.targetOutputLength = 40960;
        }
        if (videoFormat.getMaxDataLength() == -1) {
            videoFormat = new VideoFormat(videoFormat.getEncoding(), videoFormat.getSize(), this.maxOutputLength, Format.byteArray, videoFormat.getFrameRate());
            this.targetFrameRate = videoFormat.getFrameRate();
            this.frameDecimation = (int)(this.sourceFrameRate / this.targetFrameRate);
            this.useBitRate = (int)(this.targetFrameRate * (float)videoFormat.getSize().width * (float)videoFormat.getSize().height / 5.0f);
            videoFormat = (VideoFormat)super.setOutputFormat(videoFormat);
        }
        return videoFormat;
    }

    protected native boolean setQuality(float var1);

    protected void videoResized() {
        this.initEncoder();
    }
}

