/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.amovie;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.BasicController;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.MediaTimeBase;
import com.sun.media.SeekFailedEvent;
import com.sun.media.amovie.ActiveMovie;
import com.sun.media.amovie.EventThread;
import com.sun.media.amovie.jdk12CreateThreadAction;
import com.sun.media.content.video.mpeg.Handler;
import com.sun.media.controls.FormatAdapter;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.protocol.file.DataSource;
import com.sun.media.util.MediaThread;
import com.sun.media.util.WindowUtil;
import com.sun.media.util.jdk12;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.ConnectionErrorEvent;
import javax.media.Control;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.MediaLocator;
import javax.media.RateChangeEvent;
import javax.media.StopByRequestEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CachedStream;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceStream;

public class AMController
extends BasicController {
    final int MINVOLUME = -10000;
    ActiveMovie amovie = null;
    protected static final int TRYSET_DONE = 0;
    protected static final int TRYSET_CANT = 1;
    protected static final int TRYSET_PASTEOM = 2;
    private Integer closeLock = new Integer(0);
    private Integer sourceLock = new Integer(1);
    private boolean closed = false;
    private TimeBase amTimeBase = null;
    private int appletWindowHandle = 0;
    int pwidth = -1;
    int pheight = -1;
    int outWidth;
    int outHeight;
    private int width;
    private int height;
    boolean peerExists = false;
    private boolean muted = false;
    private boolean outputSizeSet = false;
    private EventThread eventThread = null;
    private boolean isFileStream = false;
    private boolean isRandomAccess = false;
    private boolean isSeekable = false;
    private boolean hasAudio = false;
    private boolean hasVideo = false;
    private boolean deallocated = false;
    private boolean sourceIsOn = false;
    private javax.media.protocol.DataSource source = null;
    private PullSourceStream stream = null;
    private SourceStream originalStream = null;
    private String mpegFile = null;
    private Handler player;
    private Component visualComponent = null;
    private boolean seekFailed = false;
    private Time timeWhenMediaStopped = null;
    private boolean mediaTimeChanged = false;
    private Time requestedMediaTime = new Time(0L);
    private Time lastMediaTime = new Time(0L);
    private VideoFormat videoFormat = null;
    private AudioFormat audioFormat = null;
    private String id = "JavaActiveMovie_" + this.hashCode();
    private boolean doneDownloading = false;
    private boolean blockedOnRead = false;
    private Thread blockThread = null;
    private boolean abortingRealize = false;
    private boolean setRatePending = false;
    private float setRateValue = 1.0f;
    private GainControl gc = null;
    private Control[] controls = null;
    private FormatControl audioControl = null;
    private FormatControl videoControl = null;
    private static boolean libraryLoaded = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    protected Time eomDuration = Duration.DURATION_UNKNOWN;
    static /* synthetic */ Class class$com$sun$media$amovie$EventThread;
    static /* synthetic */ Class class$com$sun$media$amovie$AMController;

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    public AMController(Handler handler) {
        String string = "jmam";
        if (!libraryLoaded) {
            try {
                JMFSecurityManager.loadLibrary(string);
                libraryLoaded = true;
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Unable to load native MPEG library");
            }
        }
        this.player = handler;
    }

    protected void abortPrefetch() {
        this.startSource(false, true);
    }

    protected void abortRealize() {
        this.abortingRealize = true;
        this.startSource(false, true);
    }

    static /* synthetic */ boolean access$0(AMController aMController) {
        return aMController.outputSizeSet;
    }

    public boolean audioEnabled() {
        if (this.amovie != null) {
            return this.amovie.hasAudio();
        }
        return true;
    }

    public int canRead(int n2) {
        return n2;
    }

    public long canSeek(long l2) {
        return l2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private ActiveMovie createActiveMovie(javax.media.protocol.DataSource dataSource) {
        URL uRL = null;
        if (dataSource == null) {
            return null;
        }
        MediaLocator mediaLocator = dataSource.getLocator();
        if (mediaLocator != null) {
            try {
                uRL = mediaLocator.getURL();
            }
            catch (MalformedURLException malformedURLException) {
                mediaLocator = null;
            }
        }
        if (mediaLocator != null && mediaLocator.getProtocol().equals("file")) {
            this.mpegFile = DataSource.getFileName(mediaLocator);
            this.isFileStream = true;
            this.isRandomAccess = true;
            this.isSeekable = true;
            ActiveMovie activeMovie = new ActiveMovie(this, this.mpegFile);
            this.hasVideo = activeMovie.hasVideo();
            this.hasAudio = activeMovie.hasAudio();
            this.updateControls(activeMovie);
            return activeMovie;
        }
        if (dataSource instanceof PullDataSource) {
            PullSourceStream[] pullSourceStreamArray = ((PullDataSource)dataSource).getStreams();
            if (pullSourceStreamArray != null && pullSourceStreamArray.length > 0) {
                this.stream = pullSourceStreamArray[0];
                this.originalStream = this.stream;
                if (this.stream instanceof Seekable) {
                    this.isSeekable = true;
                    if (((Seekable)((Object)this.stream)).isRandomAccess()) {
                        this.isRandomAccess = true;
                    }
                    if (mediaLocator != null && mediaLocator.getProtocol().startsWith("http") && uRL != null) {
                        this.isRandomAccess = false;
                    }
                }
                ActiveMovie activeMovie = new ActiveMovie(this, this.stream, this.isRandomAccess, this.originalStream.getContentLength());
                this.hasVideo = activeMovie.hasVideo();
                this.hasAudio = activeMovie.hasAudio();
                this.updateControls(activeMovie);
                return activeMovie;
            }
        } else {
            System.err.println("Mpeg Player can only handle pull data sources.");
        }
        return null;
    }

    Component createVisualComponent() {
        Component component = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.sun.media.amovie.MSVisualComponent");
        }
        catch (Throwable throwable) {}
        if (clazz == null) {
            try {
                clazz = Class.forName("com.sun.media.amovie.VisualComponent");
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        Class[] classArray = new Class[]{class$com$sun$media$amovie$AMController != null ? class$com$sun$media$amovie$AMController : (class$com$sun$media$amovie$AMController = AMController.class$("com.sun.media.amovie.AMController"))};
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new AMController[]{this};
            component = (Component)constructor.newInstance(objectArray);
            return component;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void doClose() {
        if (this.getState() == 200) {
            this.abortRealize();
        }
        Integer n2 = this.closeLock;
        synchronized (n2) {
            if (this.closed) {
                Object var2_2 = null;
                return;
            }
            this.doDeallocate();
            if (this.amovie != null) {
                this.amovie.dispose();
                this.amTimeBase = null;
                this.amovie = null;
            }
            if (this.source != null) {
                this.source.disconnect();
            }
            this.source = null;
            this.closed = true;
        }
    }

    protected synchronized void doDeallocate() {
        this.startSource(false, false);
        this.timeWhenMediaStopped = this.getMediaTime();
        this.mediaTimeChanged = true;
        this.requestedMediaTime = new Time(0L);
        this.lastMediaTime = this.timeWhenMediaStopped;
        if (this.amovie != null) {
            this.blockedOnRead = false;
            if (this.amovie.getVolume() == -10000) {
                this.amovie.setVolume(-5000);
            }
            this.amovie.kill();
            if (this.eventThread != null) {
                this.eventThread.kill();
                this.eventThread = null;
            }
        }
    }

    protected boolean doPrefetch() {
        if (this.amovie == null && !this.doRealize()) {
            return false;
        }
        if (this.amovie != null && this.visualComponent != null && this.peerExists) {
            this.setOwner(this.visualComponent);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean doRealize() {
        this.abortingRealize = false;
        if (this.amovie != null) {
            if (this.amTimeBase instanceof AMTimeBase) {
                this.amTimeBase = null;
            }
            this.amovie.kill();
            this.amovie.dispose();
            this.amovie = null;
        }
        this.startSource(true, true);
        Integer n2 = this.closeLock;
        synchronized (n2) {
            this.amovie = this.createActiveMovie(this.source);
            if (this.amovie == null) {
                return false;
            }
            if (!this.amovie.isRealized()) {
                this.amovie = null;
                return false;
            }
            if (this.abortingRealize) {
                this.doDeallocate();
                this.amovie.dispose();
                this.amovie = null;
                return false;
            }
        }
        try {
            this.amovie.amStopWhenReady();
            this.amovie.doneRealize();
            if (this.amTimeBase == null) {
                this.amTimeBase = new AMTimeBase(this);
            }
            this.setMediaLength((long)(this.amovie.getDuration() * 1.0E9));
            this.amovie.setVisible(0);
            this.startSource(false, false);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public float doSetRate(float f2) {
        if (this.amovie == null) {
            return 1.0f;
        }
        if ((double)f2 < 0.1) {
            f2 = 0.1f;
        }
        if ((double)f2 > 10.0) {
            f2 = 10.0f;
        }
        if ((float)this.amovie.getRate() != f2) {
            this.setRatePending = true;
            this.setRateValue = f2;
        }
        return f2;
    }

    protected final void doStart() {
        if (this.amovie == null) {
            this.doPrefetch();
        }
        this.startSource(true, false);
        this.amovie.restart();
        if (this.setRatePending) {
            this.amovie.setRate(this.setRateValue);
            this.setRatePending = false;
            if ((float)this.amovie.getRate() != this.setRateValue) {
                this.sendEvent(new RateChangeEvent(this, (float)this.amovie.getRate()));
            }
        }
        if (this.mediaTimeChanged) {
            int n2 = this.trySetMediaTime(this.requestedMediaTime);
            if (n2 == 1) {
                super.stop();
                this.sendEvent(new SeekFailedEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                return;
            }
            if (n2 == 2) {
                super.stop();
                this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                return;
            }
        }
        this.mediaTimeChanged = false;
        GainControl gainControl = this.player.getGainControl();
        if (gainControl != null) {
            this.amovie.setVolume((int)(gainControl.getDB() * 100.0f));
        }
        this.amovie.amRun();
        if (!this.peerExists) {
            this.amovie.setVisible(0);
        }
        if (gainControl != null) {
            this.muteChange(gainControl.getMute());
        }
        if (this.eventThread == null) {
            if (jmfSecurity != null) {
                String string = null;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        string = "thread";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        string = "thread group";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                    }
                }
                catch (Throwable throwable) {
                    securityPrivelege = false;
                }
            }
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                try {
                    Constructor constructor = jdk12CreateThreadAction.cons;
                    this.eventThread = (EventThread)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(class$com$sun$media$amovie$EventThread != null ? class$com$sun$media$amovie$EventThread : (class$com$sun$media$amovie$EventThread = AMController.class$("com.sun.media.amovie.EventThread"))));
                }
                catch (Exception exception) {}
            } else {
                this.eventThread = new EventThread();
            }
        }
        this.eventThread.setController(this);
        this.eventThread.start();
    }

    public void doStop() {
        super.doStop();
        this.lastMediaTime = this.getMediaTime();
        if (this.amovie != null) {
            this.amovie.amPause();
            this.amovie.pause();
        }
        if (this.eventThread != null) {
            this.eventThread.pause();
        }
        this.startSource(false, false);
        this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    public void finalize() {
        if (this.amovie != null) {
            this.doClose();
        }
    }

    public void gainChange(float f2) {
        if (this.amovie != null && !this.muted && this.gc != null) {
            float f3 = this.gc.getDB();
            if (f3 > 0.0f) {
                f3 = 0.0f;
            }
            if (f3 < -70.0f) {
                f3 = -100.0f;
            }
            this.amovie.setVolume((int)(f3 * 100.0f));
        }
    }

    public Control[] getControls() {
        int n2 = 0;
        if (this.hasAudio) {
            ++n2;
        }
        if (this.audioFormat != null) {
            ++n2;
        }
        if (this.videoFormat != null) {
            ++n2;
        }
        this.controls = new Control[n2];
        n2 = 0;
        if (this.hasAudio) {
            if (this.gc == null) {
                this.gc = new GCA();
            }
            this.controls[n2++] = this.gc;
        }
        if (this.audioFormat != null) {
            if (this.audioControl == null) {
                this.audioControl = new FormatAdapter(this.audioFormat, new Format[]{this.audioFormat}, true, false, false);
            }
            this.controls[n2++] = this.audioControl;
        }
        if (this.videoFormat != null) {
            if (this.videoControl == null) {
                this.videoControl = new FormatAdapter(this.videoFormat, new Format[]{this.videoFormat}, true, false, false);
            }
            this.controls[n2++] = this.videoControl;
        }
        return this.controls;
    }

    public Time getDuration() {
        Time time;
        if (this.eomDuration != Duration.DURATION_UNKNOWN) {
            return this.eomDuration;
        }
        if (this.source instanceof Duration && (time = this.source.getDuration()) != null && time != Duration.DURATION_UNKNOWN && time != Duration.DURATION_UNBOUNDED) {
            return time;
        }
        if (this.amovie == null) {
            return Duration.DURATION_UNKNOWN;
        }
        double d2 = this.amovie.getDuration();
        if (this.isRandomAccess) {
            return new Time((long)(d2 * 1.0E9));
        }
        return Duration.DURATION_UNKNOWN;
    }

    public TimeBase getTimeBase() {
        if (this.amTimeBase == null) {
            this.amTimeBase = new AMTimeBase(this);
        }
        return this.amTimeBase;
    }

    public Component getVisualComponent() {
        if (this.amovie == null) {
            return null;
        }
        if (this.visualComponent == null) {
            if (this.amovie.getVideoWidth() == 0 || this.amovie.getVideoHeight() == 0) {
                this.visualComponent = null;
            } else {
                this.visualComponent = this.createVisualComponent();
                this.visualComponent.addComponentListener(new ComponentAdapter(){
                    private int lastWidth = -1;
                    private int lastHeight = -1;

                    public void componentResized(ComponentEvent componentEvent) {
                        if (AMController.this.amovie != null) {
                            Dimension dimension = componentEvent.getComponent().getSize();
                            if (dimension.width == this.lastWidth && dimension.height == this.lastHeight) {
                                return;
                            }
                            this.lastWidth = dimension.width;
                            this.lastHeight = dimension.height;
                            AMController.this.outputSizeSet = true;
                            AMController.this.zoom(this.lastWidth, this.lastHeight);
                        }
                    }
                });
            }
        }
        return this.visualComponent;
    }

    public boolean isConfigurable() {
        return false;
    }

    public void muteChange(boolean bl) {
        block6: {
            if (this.amovie == null) break block6;
            if (bl) {
                this.muted = true;
                this.amovie.setVolume(-10000);
            } else {
                this.muted = false;
                try {
                    float f2 = this.gc.getDB();
                    if (f2 > 0.0f) {
                        f2 = 0.0f;
                    }
                    if (f2 < -70.0f) {
                        f2 = -100.0f;
                    }
                    this.amovie.setVolume((int)(f2 * 100.0f));
                }
                catch (Exception exception) {}
            }
        }
    }

    public int read(byte[] byArray, int n2, int n3) {
        if (this.abortingRealize) {
            return -1;
        }
        Integer n4 = this.sourceLock;
        synchronized (n4) {
            if (this.stream != null && this.sourceIsOn) {
                try {
                    int n5;
                    int n6 = n5 = this.stream.read(byArray, n2, n3);
                    Object var6_10 = null;
                    return n6;
                }
                catch (IOException iOException) {
                    this.sendEvent(new ConnectionErrorEvent(this, iOException.getMessage()));
                    int n7 = -1;
                    Object var6_11 = null;
                    return n7;
                }
            }
            int n8 = -1;
            Object var6_12 = null;
            return n8;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long seek(long l2) {
        if (this.abortingRealize) {
            return 0L;
        }
        Integer n2 = this.sourceLock;
        synchronized (n2) {
            if (!(this.stream instanceof Seekable)) return 0L;
            if (!this.sourceIsOn) return 0L;
            if (((Seekable)((Object)this.stream)).tell() == l2) {
                return l2;
            }
            if (((Seekable)((Object)this.stream)).isRandomAccess()) {
                long l3 = ((Seekable)((Object)this.stream)).seek(l2);
                return l3;
            }
            if (l2 != 0L) return 0L;
            return ((Seekable)((Object)this.stream)).seek(l2);
        }
    }

    void sendEOM() {
        if (this.amovie != null) {
            this.amovie.amPause();
            this.amovie.pause();
        }
        super.stop();
        Time time = this.eomDuration;
        this.eomDuration = new Time(this.getMediaTime().getNanoseconds());
        this.startSource(false, false);
        this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
        if (time == Duration.DURATION_UNKNOWN) {
            this.sendEvent(new DurationUpdateEvent(this, this.eomDuration));
        }
        if (this.stream instanceof CachedStream && !this.isRandomAccess) {
            this.isRandomAccess = true;
            if (this.amovie != null) {
                this.amovie.setSeekable(true);
            }
        }
    }

    public void setMediaTime(Time time) {
        super.setMediaTime(time);
        AMController aMController = this;
        synchronized (aMController) {
            this.requestedMediaTime = time;
            this.mediaTimeChanged = true;
        }
        if (this.stream == null) {
            this.amovie.restart();
            if (this.trySetMediaTime(time) == 0) {
                this.mediaTimeChanged = false;
            }
        }
    }

    void setOwner(Component component) {
        try {
            if (this.amovie != null && component != null) {
                this.appletWindowHandle = WindowUtil.getWindowHandle(component);
                if (this.appletWindowHandle == 0) {
                    throw new NullPointerException("null peer");
                }
                this.amovie.setOwner(this.appletWindowHandle);
                this.amovie.setVisible(1);
                component.getPreferredSize();
                this.amovie.setWindowPosition(0, 0, this.outWidth, this.outHeight);
            }
        }
        catch (Throwable throwable) {}
    }

    public void setSource(javax.media.protocol.DataSource dataSource) throws IncompatibleSourceException {
        if (!(dataSource instanceof PullDataSource)) {
            throw new IncompatibleSourceException("MPEG Controller requires a PullDataSource");
        }
        this.source = dataSource;
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        super.setTimeBase(timeBase);
        if (timeBase != null && timeBase != this.amTimeBase) {
            Log.warning("the mpeg handler cannot handle the given timebase.");
        }
        this.amTimeBase = timeBase;
    }

    public boolean startSource(boolean bl, boolean bl2) {
        if (this.sourceIsOn == bl) {
            return true;
        }
        Integer n2 = this.sourceLock;
        synchronized (n2) {
            if (bl2) {
                try {
                    if (bl) {
                        this.source.start();
                        if (this.amovie != null) {
                            this.amovie.stopDataFlow(false);
                        }
                    } else {
                        if (this.amovie != null) {
                            this.amovie.stopDataFlow(true);
                        }
                        this.source.stop();
                    }
                }
                catch (Exception exception) {
                    boolean bl3 = false;
                    Object var5_6 = null;
                    return bl3;
                }
                this.sourceIsOn = bl;
            }
            boolean bl4 = true;
            Object var5_7 = null;
            return bl4;
        }
    }

    protected int trySetMediaTime(Time time) {
        if (this.amovie != null) {
            long l2 = this.getDuration().getNanoseconds();
            long l3 = time.getNanoseconds();
            if (this.getDuration() == Duration.DURATION_UNKNOWN && l3 != 0L) {
                return 1;
            }
            if (l3 < 0L) {
                return 1;
            }
            if (l3 > l2) {
                return 2;
            }
            if (!this.isSeekable) {
                return 1;
            }
            double d2 = (double)l3 * 1.0E-9;
            if (this.isRandomAccess) {
                this.amovie.setCurrentPosition(d2);
                return 0;
            }
            if (this.stream != null) {
                if (l3 != 0L) {
                    return 1;
                }
                ((Seekable)((Object)this.stream)).seek(0L);
                this.amovie.setCurrentPosition(0.0);
                return 0;
            }
        }
        return 1;
    }

    private void updateControls(ActiveMovie activeMovie) {
        if (this.hasAudio) {
            this.audioFormat = new AudioFormat("mpegaudio");
        }
        if (this.hasVideo) {
            Dimension dimension = new Dimension(activeMovie.getVideoWidth(), activeMovie.getVideoHeight());
            this.videoFormat = new VideoFormat("mpeg", dimension, -1, Format.byteArray, -1.0f);
        }
    }

    public boolean videoEnabled() {
        if (this.amovie != null) {
            return this.amovie.hasVideo();
        }
        return true;
    }

    private void zoom(int n2, int n3) {
        this.outWidth = n2;
        if (this.outWidth < 120) {
            this.outWidth = 120;
        }
        this.outHeight = n3;
        if (this.outHeight < 1) {
            this.outHeight = 1;
        }
        this.zoomChanged();
    }

    private void zoomChanged() {
        if (this.amovie == null) {
            return;
        }
        int n2 = this.amovie.getVideoWidth();
        int n3 = this.amovie.getVideoHeight();
        if (this.peerExists) {
            this.amovie.setWindowPosition(0, 0, this.outWidth, this.outHeight);
        }
        if (this.pwidth != n2 || this.pheight != n3) {
            this.pwidth = n2;
            this.pheight = n3;
        }
    }

    class AMTimeBase
    extends MediaTimeBase {
        private AMController controller;

        public AMTimeBase(AMController aMController2) {
            this.controller = aMController2;
        }

        public long getMediaTime() {
            long l2 = 0L;
            if (this.controller.amovie != null) {
                l2 = this.controller.amovie.getTime() * 1000L;
            }
            return l2;
        }

        public long getNanoseconds() {
            return this.getMediaTime();
        }
    }

    class GCA
    extends GainControlAdapter {
        GCA() {
            super(1.0f);
        }

        public float setLevel(float f2) {
            float f3 = super.setLevel(f2);
            AMController.this.gainChange(f2);
            return f3;
        }

        public void setMute(boolean bl) {
            super.setMute(bl);
            AMController.this.muteChange(bl);
        }
    }

    class ProgressThread
    extends MediaThread {
        private Handler mp;

        ProgressThread(Handler handler) {
            this.mp = handler;
            this.setName("JMF AMController Progress Thread: " + this.getName());
        }

        public void run() {
        }

        public void start() {
            if (!this.isAlive()) {
                super.start();
            }
        }

        public void tryStop() {
            if (this.isAlive()) {
                super.stop();
            }
        }
    }
}

