/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.colorspace;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.JMFSecurityManager;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class RGBScaler
extends BasicCodec {
    protected float quality = 0.5f;
    private int nativeData = 0;
    private static boolean nativeAvailable = true;

    static {
        try {
            JMFSecurityManager.loadLibrary("jmutil");
        }
        catch (Throwable throwable) {}
    }

    public RGBScaler() {
        this(null);
    }

    public RGBScaler(Dimension dimension) {
        this.inputFormats = new Format[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, -1, 0, -1)};
        if (dimension != null) {
            this.setOutputSize(dimension);
        }
    }

    public void close() {
        block2: {
            super.close();
            if (!nativeAvailable || this.nativeData == 0) break block2;
            try {
                this.nativeClose();
            }
            catch (Throwable throwable) {}
        }
    }

    public String getName() {
        return "RGB Scaler";
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (BasicPlugIn.matches(format, this.inputFormats) != null) {
            float f2 = ((VideoFormat)format).getFrameRate();
            VideoFormat videoFormat = new VideoFormat(null, null, -1, null, f2);
            return new Format[]{this.outputFormats[0].intersects(videoFormat)};
        }
        return new Format[0];
    }

    private native void nativeClose();

    private native void nativeScale(Object var1, long var2, Object var4, long var5, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    protected void nearestNeighbour(Buffer buffer, Buffer buffer2) {
        Object object;
        Object object2;
        RGBFormat rGBFormat = (RGBFormat)buffer.getFormat();
        Dimension dimension = rGBFormat.getSize();
        RGBFormat rGBFormat2 = (RGBFormat)buffer2.getFormat();
        Dimension dimension2 = rGBFormat2.getSize();
        int n2 = rGBFormat.getPixelStride();
        int n3 = rGBFormat2.getPixelStride();
        int n4 = rGBFormat.getLineStride();
        int n5 = rGBFormat2.getLineStride();
        float f2 = (float)dimension.width / (float)dimension2.width;
        float f3 = (float)dimension.height / (float)dimension2.height;
        long l2 = 0L;
        long l3 = 0L;
        if (nativeAvailable) {
            object2 = this.getInputData(buffer);
            object = this.validateData(buffer2, 0, true);
            l2 = this.getNativeData(object2);
            l3 = this.getNativeData(object);
        } else {
            object2 = buffer.getData();
            object = buffer2.getData();
        }
        if (nativeAvailable) {
            try {
                this.nativeScale(object2, l2, object, l3, n2, n4, dimension.width, dimension.height, n3, n5, dimension2.width, dimension2.height);
            }
            catch (Throwable throwable) {
                nativeAvailable = false;
            }
        }
        if (!nativeAvailable) {
            byte[] byArray = (byte[])object2;
            byte[] byArray2 = (byte[])object;
            int n6 = 0;
            while (n6 < dimension2.height) {
                int n7 = n6 * n5;
                int n8 = (int)((float)n6 * f3) * n4;
                int n9 = 0;
                while (n9 < dimension2.width) {
                    int n10 = n8 + (int)((float)n9 * f2) * n2;
                    byArray2[n7] = byArray[n10];
                    byArray2[n7 + 1] = byArray[n10 + 1];
                    byArray2[n7 + 2] = byArray[n10 + 2];
                    n7 += n3;
                    ++n9;
                }
                ++n6;
            }
        }
    }

    public int process(Buffer buffer, Buffer buffer2) {
        int n2 = ((VideoFormat)this.outputFormat).getMaxDataLength();
        buffer2.setLength(n2);
        buffer2.setFormat(this.outputFormat);
        if (this.quality <= 0.5f) {
            this.nearestNeighbour(buffer, buffer2);
        }
        return 0;
    }

    public Format setInputFormat(Format format) {
        if (BasicPlugIn.matches(format, this.inputFormats) == null) {
            return null;
        }
        return format;
    }

    public Format setOutputFormat(Format format) {
        if (format == null || BasicPlugIn.matches(format, this.outputFormats) == null) {
            return null;
        }
        RGBFormat rGBFormat = (RGBFormat)format;
        Dimension dimension = rGBFormat.getSize();
        int n2 = rGBFormat.getMaxDataLength();
        int n3 = rGBFormat.getLineStride();
        float f2 = rGBFormat.getFrameRate();
        int n4 = rGBFormat.getFlipped();
        int n5 = rGBFormat.getEndian();
        if (dimension == null) {
            return null;
        }
        if (n2 < dimension.width * dimension.height * 3) {
            n2 = dimension.width * dimension.height * 3;
        }
        if (n3 < dimension.width * 3) {
            n3 = dimension.width * 3;
        }
        if (n4 != 0) {
            n4 = 0;
        }
        this.outputFormat = this.outputFormats[0].intersects(new RGBFormat(dimension, n2, null, f2, -1, -1, -1, -1, -1, n3, -1, -1));
        return this.outputFormat;
    }

    public void setOutputSize(Dimension dimension) {
        this.outputFormats = new Format[]{new RGBFormat(dimension, dimension.width * dimension.height * 3, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, dimension.width * 3, 0, -1)};
    }
}

