/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.colorspace;

import com.sun.media.BasicCodec;
import com.sun.media.JMFSecurityManager;
import com.sun.media.codec.video.colorspace.YUVToRGB;
import com.sun.media.util.Arch;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import javax.media.format.RGBFormat;
import javax.media.format.YUVFormat;

public class YUVToRGB
extends BasicCodec {
    private static boolean loaded = false;
    private int peer = 0;
    protected Format[] defInputFormats = new Format[1];
    protected Format[] defOutputFormats;
    private YUVFormat inputFormat = null;
    private RGBFormat outputFormat = null;
    private FrameProcessingControl frameControl = null;
    private boolean dropFrame;

    public YUVToRGB() {
        this.defInputFormats[0] = new YUVFormat();
        this.defOutputFormats = new Format[1];
        this.defOutputFormats[0] = new RGBFormat();
        if (this.frameControl == null) {
            class FPC
            implements FrameProcessingControl {
                private final /* synthetic */ YUVToRGB this$0;

                FPC(YUVToRGB yUVToRGB) {
                    this.this$0 = yUVToRGB;
                }

                public Component getControlComponent() {
                    return null;
                }

                public int getFramesDropped() {
                    return 0;
                }

                public void setFramesBehind(float f2) {
                    if (f2 > 0.0f) {
                        YUVToRGB.access$1(this.this$0, true);
                    } else {
                        YUVToRGB.access$1(this.this$0, false);
                    }
                }

                public boolean setMinimalProcessing(boolean bl) {
                    YUVToRGB.access$1(this.this$0, bl);
                    return YUVToRGB.access$0(this.this$0);
                }
            }
            this.frameControl = new FPC(this);
            this.controls = new Control[1];
            this.controls[0] = this.frameControl;
        }
    }

    static /* synthetic */ boolean access$0(YUVToRGB yUVToRGB) {
        return yUVToRGB.dropFrame;
    }

    static /* synthetic */ void access$1(YUVToRGB yUVToRGB, boolean bl) {
        yUVToRGB.dropFrame = bl;
    }

    public synchronized void close() {
        if (this.peer != 0) {
            this.freeConverter(this.peer);
        }
        this.peer = 0;
    }

    private native boolean convert(int var1, Object var2, long var3, Object var5, long var6, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, int var19, int var20);

    public void finalize() {
        this.close();
    }

    private native boolean freeConverter(int var1);

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    public String getName() {
        return "YUV To RGB Converter";
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedInputFormats() {
        return this.defInputFormats;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.defOutputFormats;
        }
        if (format instanceof YUVFormat) {
            YUVFormat yUVFormat = (YUVFormat)format;
            Dimension dimension = yUVFormat.getSize();
            int n2 = 0;
            if (dimension != null && ((n2 = dimension.width) & 1) != 0) {
                ++n2;
            }
            Format[] formatArray = null;
            formatArray = Arch.getAlignment() == 1 ? new RGBFormat[]{new RGBFormat(dimension, n2 * dimension.height, Format.shortArray, yUVFormat.getFrameRate(), 16, 31744, 992, 31, 1, n2, 0, -1), new RGBFormat(dimension, n2 * dimension.height, Format.shortArray, yUVFormat.getFrameRate(), 16, 63488, 2016, 31, 1, n2, 0, -1), new RGBFormat(dimension, n2 * dimension.height * 3 + 1, Format.byteArray, yUVFormat.getFrameRate(), 24, 1, 2, 3, 3, n2 * 3, 0, -1), new RGBFormat(dimension, n2 * dimension.height * 3 + 1, Format.byteArray, yUVFormat.getFrameRate(), 24, 3, 2, 1, 3, n2 * 3, 0, -1), new RGBFormat(dimension, n2 * dimension.height, Format.intArray, yUVFormat.getFrameRate(), 32, 0xFF0000, 65280, 255, 1, n2, 0, -1), new RGBFormat(dimension, n2 * dimension.height, Format.intArray, yUVFormat.getFrameRate(), 32, 255, 65280, 0xFF0000, 1, n2, 0, -1)} : new RGBFormat[]{new RGBFormat(dimension, n2 * dimension.height, Format.intArray, yUVFormat.getFrameRate(), 32, 0xFF0000, 65280, 255, 1, n2, 0, -1), new RGBFormat(dimension, n2 * dimension.height, Format.intArray, yUVFormat.getFrameRate(), 32, 255, 65280, 0xFF0000, 1, n2, 0, -1)};
            return formatArray;
        }
        return new Format[0];
    }

    private native int initConverter(int var1, int var2, int var3, int var4, boolean var5);

    public synchronized void open() throws ResourceUnavailableException {
        if (!loaded) {
            try {
                JMFSecurityManager.loadLibrary("jmutil");
                loaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new ResourceUnavailableException(unsatisfiedLinkError.getMessage());
            }
        }
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Incorrect formats set on YUVToRGB converter");
        }
        if (this.peer != 0) {
            this.close();
        }
        try {
            int n2 = this.outputFormat.getRedMask();
            int n3 = this.outputFormat.getGreenMask();
            int n4 = this.outputFormat.getBlueMask();
            int n5 = this.outputFormat.getBitsPerPixel();
            if (n5 == 24 && this.outputFormat.getDataType() == Format.byteArray) {
                n2 = 255 << (n2 - 1) * 8;
                n3 = 255 << (n3 - 1) * 8;
                n4 = 255 << (n4 - 1) * 8;
            }
            this.peer = this.initConverter(n2, n3, n4, n5, (this.inputFormat.getYuvType() & 0x40) != 0);
        }
        catch (Throwable throwable) {}
        if (this.peer == 0) {
            throw new ResourceUnavailableException("Unable to initialize YUVToRGB converter");
        }
    }

    public int process(Buffer buffer, Buffer buffer2) {
        boolean bl;
        int n2;
        int n3;
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        if (buffer.isDiscard() || this.dropFrame) {
            buffer2.setDiscard(true);
            return 0;
        }
        long l2 = 0L;
        long l3 = 0L;
        Object object = null;
        Object object2 = null;
        Format format = buffer.getFormat();
        if (format != this.inputFormat && !format.equals(this.inputFormat)) {
            this.setInputFormat(format);
        }
        object = this.getInputData(buffer);
        l2 = this.getNativeData(object);
        object2 = this.getOutputData(buffer2);
        if (object2 == null || buffer2.getFormat() != this.outputFormat || !buffer2.getFormat().equals(this.outputFormat)) {
            RGBFormat rGBFormat = this.outputFormat;
            n3 = rGBFormat.getLineStride();
            n2 = rGBFormat.getSize().height * n3 + 1;
            Class clazz = rGBFormat.getDataType();
            buffer2.setLength(n2);
            buffer2.setFormat(this.outputFormat);
        }
        object2 = this.validateData(buffer2, 0, true);
        l3 = this.getNativeData(object2);
        if (buffer.getLength() < 10) {
            buffer2.setDiscard(true);
            return 0;
        }
        int n4 = this.inputFormat.getStrideY();
        n3 = this.inputFormat.getStrideUV();
        n2 = this.inputFormat.getSize().height;
        int n5 = this.inputFormat.getOffsetY();
        int n6 = this.inputFormat.getOffsetU();
        int n7 = this.inputFormat.getOffsetV();
        int n8 = this.outputFormat.getLineStride();
        int n9 = this.outputFormat.getSize().height;
        int n10 = this.inputFormat.getYuvType();
        int n11 = this.inputFormat.getSize().width;
        int n12 = this.inputFormat.getSize().height;
        switch (n10 & 0xFFFFFFBF) {
            case 2: {
                n10 = 1;
                break;
            }
            case 4: {
                n10 = 2;
                break;
            }
            case 8: {
                n10 = 4;
                break;
            }
            case 512: {
                n10 = 5;
                break;
            }
            case 16: {
                n10 = 3;
                break;
            }
            case 32: {
                n10 = 6;
                break;
            }
        }
        if (this.outputFormat.getBitsPerPixel() == 24) {
            n8 /= 3;
        }
        if (bl = this.convert(this.peer, object, l2, object2, l3, n4, n2, n8, n9, n11, n12, n5, n6, n7, n4, n3, n10, this.outputFormat.getBitsPerPixel() / 8)) {
            buffer2.setTimeStamp(buffer.getTimeStamp());
            buffer2.setLength(this.outputFormat.getLineStride() * this.outputFormat.getSize().height);
            return 0;
        }
        return 1;
    }

    public synchronized void reset() {
    }

    public Format setInputFormat(Format format) {
        boolean bl = false;
        if (!(format instanceof YUVFormat)) {
            return null;
        }
        YUVFormat yUVFormat = (YUVFormat)format;
        Dimension dimension = yUVFormat.getSize();
        int n2 = yUVFormat.getStrideY();
        int n3 = yUVFormat.getStrideUV();
        int n4 = yUVFormat.getYuvType();
        Class clazz = yUVFormat.getDataType();
        int n5 = yUVFormat.getOffsetY();
        int n6 = yUVFormat.getOffsetU();
        int n7 = yUVFormat.getOffsetV();
        if (dimension == null || dimension.width < 1 || dimension.height < 1 || (n4 & 1) != 0 || clazz != Format.byteArray) {
            return null;
        }
        if ((n4 & 0x20) != 0 && (n5 == n6 || n5 == n7 || n7 == n6)) {
            return null;
        }
        if (this.peer != 0) {
            bl = true;
            this.close();
        }
        this.inputFormat = yUVFormat;
        if (this.outputFormat != null && dimension != null && (!dimension.equals(this.outputFormat.getSize()) || bl)) {
            int n8 = dimension.width;
            if ((n8 & 1) != 0) {
                ++n8;
            }
            this.outputFormat = new RGBFormat(dimension, (n8 *= this.outputFormat.getPixelStride()) * dimension.height + 4, this.outputFormat.getDataType(), this.outputFormat.getFrameRate(), this.outputFormat.getBitsPerPixel(), this.outputFormat.getRedMask(), this.outputFormat.getGreenMask(), this.outputFormat.getBlueMask(), this.outputFormat.getPixelStride(), n8, this.outputFormat.getFlipped(), this.outputFormat.getEndian());
        }
        if (bl) {
            try {
                this.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                return null;
            }
        }
        return format;
    }

    public Format setOutputFormat(Format format) {
        if (!(format instanceof RGBFormat)) {
            return null;
        }
        RGBFormat rGBFormat = (RGBFormat)format;
        Dimension dimension = rGBFormat.getSize();
        int n2 = rGBFormat.getPixelStride();
        int n3 = rGBFormat.getLineStride();
        if (dimension == null || n2 < 1 || n3 < dimension.width) {
            return null;
        }
        this.outputFormat = rGBFormat;
        return format;
    }
}

