/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jpeg;

import com.sun.media.codec.video.jpeg.RTPDePacketizer;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.format.VideoFormat;

class JPEGFrame {
    public long rtptimestamp = -1L;
    public int dataLength = 0;
    private RTPDePacketizer depacketizer;
    private int hdrOffset = 0;
    private long firstSeq;
    private long numPkts = 0L;
    final int FRAME_BUFFER_INITIAL_SIZE = 32000;
    int lquantOffset = 2 + APP0.length + 2 + 2 + 1;
    int cquantOffset = this.lquantOffset + 64 + 2 + 2 + 1;
    static final byte[] APP0;
    static int[] lum_dc_codelens;
    static int[] lum_dc_symbols;
    static int[] lum_ac_codelens;
    static int[] lum_ac_symbols;
    static int[] chm_dc_codelens;
    static int[] chm_dc_symbols;
    static int[] chm_ac_codelens;
    static int[] chm_ac_symbols;
    static int[] ZigZag;
    static int[] jpeg_luma_quantizer;
    static int[] jpeg_chroma_quantizer;

    static {
        byte[] byArray = new byte[18];
        byArray[0] = -1;
        byArray[1] = -32;
        byArray[3] = 16;
        byArray[4] = 74;
        byArray[5] = 70;
        byArray[6] = 73;
        byArray[7] = 70;
        byArray[9] = 1;
        byArray[10] = 1;
        byArray[13] = 1;
        byArray[15] = 1;
        APP0 = byArray;
        int[] nArray = new int[16];
        nArray[1] = 1;
        nArray[2] = 5;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 1;
        lum_dc_codelens = nArray;
        int[] nArray2 = new int[12];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        nArray2[6] = 6;
        nArray2[7] = 7;
        nArray2[8] = 8;
        nArray2[9] = 9;
        nArray2[10] = 10;
        nArray2[11] = 11;
        lum_dc_symbols = nArray2;
        int[] nArray3 = new int[16];
        nArray3[1] = 2;
        nArray3[2] = 1;
        nArray3[3] = 3;
        nArray3[4] = 3;
        nArray3[5] = 2;
        nArray3[6] = 4;
        nArray3[7] = 3;
        nArray3[8] = 5;
        nArray3[9] = 5;
        nArray3[10] = 4;
        nArray3[11] = 4;
        nArray3[14] = 1;
        nArray3[15] = 125;
        lum_ac_codelens = nArray3;
        int[] nArray4 = new int[162];
        nArray4[0] = 1;
        nArray4[1] = 2;
        nArray4[2] = 3;
        nArray4[4] = 4;
        nArray4[5] = 17;
        nArray4[6] = 5;
        nArray4[7] = 18;
        nArray4[8] = 33;
        nArray4[9] = 49;
        nArray4[10] = 65;
        nArray4[11] = 6;
        nArray4[12] = 19;
        nArray4[13] = 81;
        nArray4[14] = 97;
        nArray4[15] = 7;
        nArray4[16] = 34;
        nArray4[17] = 113;
        nArray4[18] = 20;
        nArray4[19] = 50;
        nArray4[20] = 129;
        nArray4[21] = 145;
        nArray4[22] = 161;
        nArray4[23] = 8;
        nArray4[24] = 35;
        nArray4[25] = 66;
        nArray4[26] = 177;
        nArray4[27] = 193;
        nArray4[28] = 21;
        nArray4[29] = 82;
        nArray4[30] = 209;
        nArray4[31] = 240;
        nArray4[32] = 36;
        nArray4[33] = 51;
        nArray4[34] = 98;
        nArray4[35] = 114;
        nArray4[36] = 130;
        nArray4[37] = 9;
        nArray4[38] = 10;
        nArray4[39] = 22;
        nArray4[40] = 23;
        nArray4[41] = 24;
        nArray4[42] = 25;
        nArray4[43] = 26;
        nArray4[44] = 37;
        nArray4[45] = 38;
        nArray4[46] = 39;
        nArray4[47] = 40;
        nArray4[48] = 41;
        nArray4[49] = 42;
        nArray4[50] = 52;
        nArray4[51] = 53;
        nArray4[52] = 54;
        nArray4[53] = 55;
        nArray4[54] = 56;
        nArray4[55] = 57;
        nArray4[56] = 58;
        nArray4[57] = 67;
        nArray4[58] = 68;
        nArray4[59] = 69;
        nArray4[60] = 70;
        nArray4[61] = 71;
        nArray4[62] = 72;
        nArray4[63] = 73;
        nArray4[64] = 74;
        nArray4[65] = 83;
        nArray4[66] = 84;
        nArray4[67] = 85;
        nArray4[68] = 86;
        nArray4[69] = 87;
        nArray4[70] = 88;
        nArray4[71] = 89;
        nArray4[72] = 90;
        nArray4[73] = 99;
        nArray4[74] = 100;
        nArray4[75] = 101;
        nArray4[76] = 102;
        nArray4[77] = 103;
        nArray4[78] = 104;
        nArray4[79] = 105;
        nArray4[80] = 106;
        nArray4[81] = 115;
        nArray4[82] = 116;
        nArray4[83] = 117;
        nArray4[84] = 118;
        nArray4[85] = 119;
        nArray4[86] = 120;
        nArray4[87] = 121;
        nArray4[88] = 122;
        nArray4[89] = 131;
        nArray4[90] = 132;
        nArray4[91] = 133;
        nArray4[92] = 134;
        nArray4[93] = 135;
        nArray4[94] = 136;
        nArray4[95] = 137;
        nArray4[96] = 138;
        nArray4[97] = 146;
        nArray4[98] = 147;
        nArray4[99] = 148;
        nArray4[100] = 149;
        nArray4[101] = 150;
        nArray4[102] = 151;
        nArray4[103] = 152;
        nArray4[104] = 153;
        nArray4[105] = 154;
        nArray4[106] = 162;
        nArray4[107] = 163;
        nArray4[108] = 164;
        nArray4[109] = 165;
        nArray4[110] = 166;
        nArray4[111] = 167;
        nArray4[112] = 168;
        nArray4[113] = 169;
        nArray4[114] = 170;
        nArray4[115] = 178;
        nArray4[116] = 179;
        nArray4[117] = 180;
        nArray4[118] = 181;
        nArray4[119] = 182;
        nArray4[120] = 183;
        nArray4[121] = 184;
        nArray4[122] = 185;
        nArray4[123] = 186;
        nArray4[124] = 194;
        nArray4[125] = 195;
        nArray4[126] = 196;
        nArray4[127] = 197;
        nArray4[128] = 198;
        nArray4[129] = 199;
        nArray4[130] = 200;
        nArray4[131] = 201;
        nArray4[132] = 202;
        nArray4[133] = 210;
        nArray4[134] = 211;
        nArray4[135] = 212;
        nArray4[136] = 213;
        nArray4[137] = 214;
        nArray4[138] = 215;
        nArray4[139] = 216;
        nArray4[140] = 217;
        nArray4[141] = 218;
        nArray4[142] = 225;
        nArray4[143] = 226;
        nArray4[144] = 227;
        nArray4[145] = 228;
        nArray4[146] = 229;
        nArray4[147] = 230;
        nArray4[148] = 231;
        nArray4[149] = 232;
        nArray4[150] = 233;
        nArray4[151] = 234;
        nArray4[152] = 241;
        nArray4[153] = 242;
        nArray4[154] = 243;
        nArray4[155] = 244;
        nArray4[156] = 245;
        nArray4[157] = 246;
        nArray4[158] = 247;
        nArray4[159] = 248;
        nArray4[160] = 249;
        nArray4[161] = 250;
        lum_ac_symbols = nArray4;
        int[] nArray5 = new int[16];
        nArray5[1] = 3;
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[4] = 1;
        nArray5[5] = 1;
        nArray5[6] = 1;
        nArray5[7] = 1;
        nArray5[8] = 1;
        nArray5[9] = 1;
        nArray5[10] = 1;
        chm_dc_codelens = nArray5;
        int[] nArray6 = new int[12];
        nArray6[1] = 1;
        nArray6[2] = 2;
        nArray6[3] = 3;
        nArray6[4] = 4;
        nArray6[5] = 5;
        nArray6[6] = 6;
        nArray6[7] = 7;
        nArray6[8] = 8;
        nArray6[9] = 9;
        nArray6[10] = 10;
        nArray6[11] = 11;
        chm_dc_symbols = nArray6;
        int[] nArray7 = new int[16];
        nArray7[1] = 2;
        nArray7[2] = 1;
        nArray7[3] = 2;
        nArray7[4] = 4;
        nArray7[5] = 4;
        nArray7[6] = 3;
        nArray7[7] = 4;
        nArray7[8] = 7;
        nArray7[9] = 5;
        nArray7[10] = 4;
        nArray7[11] = 4;
        nArray7[13] = 1;
        nArray7[14] = 2;
        nArray7[15] = 119;
        chm_ac_codelens = nArray7;
        int[] nArray8 = new int[162];
        nArray8[1] = 1;
        nArray8[2] = 2;
        nArray8[3] = 3;
        nArray8[4] = 17;
        nArray8[5] = 4;
        nArray8[6] = 5;
        nArray8[7] = 33;
        nArray8[8] = 49;
        nArray8[9] = 6;
        nArray8[10] = 18;
        nArray8[11] = 65;
        nArray8[12] = 81;
        nArray8[13] = 7;
        nArray8[14] = 97;
        nArray8[15] = 113;
        nArray8[16] = 19;
        nArray8[17] = 34;
        nArray8[18] = 50;
        nArray8[19] = 129;
        nArray8[20] = 8;
        nArray8[21] = 20;
        nArray8[22] = 66;
        nArray8[23] = 145;
        nArray8[24] = 161;
        nArray8[25] = 177;
        nArray8[26] = 193;
        nArray8[27] = 9;
        nArray8[28] = 35;
        nArray8[29] = 51;
        nArray8[30] = 82;
        nArray8[31] = 240;
        nArray8[32] = 21;
        nArray8[33] = 98;
        nArray8[34] = 114;
        nArray8[35] = 209;
        nArray8[36] = 10;
        nArray8[37] = 22;
        nArray8[38] = 36;
        nArray8[39] = 52;
        nArray8[40] = 225;
        nArray8[41] = 37;
        nArray8[42] = 241;
        nArray8[43] = 23;
        nArray8[44] = 24;
        nArray8[45] = 25;
        nArray8[46] = 26;
        nArray8[47] = 38;
        nArray8[48] = 39;
        nArray8[49] = 40;
        nArray8[50] = 41;
        nArray8[51] = 42;
        nArray8[52] = 53;
        nArray8[53] = 54;
        nArray8[54] = 55;
        nArray8[55] = 56;
        nArray8[56] = 57;
        nArray8[57] = 58;
        nArray8[58] = 67;
        nArray8[59] = 68;
        nArray8[60] = 69;
        nArray8[61] = 70;
        nArray8[62] = 71;
        nArray8[63] = 72;
        nArray8[64] = 73;
        nArray8[65] = 74;
        nArray8[66] = 83;
        nArray8[67] = 84;
        nArray8[68] = 85;
        nArray8[69] = 86;
        nArray8[70] = 87;
        nArray8[71] = 88;
        nArray8[72] = 89;
        nArray8[73] = 90;
        nArray8[74] = 99;
        nArray8[75] = 100;
        nArray8[76] = 101;
        nArray8[77] = 102;
        nArray8[78] = 103;
        nArray8[79] = 104;
        nArray8[80] = 105;
        nArray8[81] = 106;
        nArray8[82] = 115;
        nArray8[83] = 116;
        nArray8[84] = 117;
        nArray8[85] = 118;
        nArray8[86] = 119;
        nArray8[87] = 120;
        nArray8[88] = 121;
        nArray8[89] = 122;
        nArray8[90] = 130;
        nArray8[91] = 131;
        nArray8[92] = 132;
        nArray8[93] = 133;
        nArray8[94] = 134;
        nArray8[95] = 135;
        nArray8[96] = 136;
        nArray8[97] = 137;
        nArray8[98] = 138;
        nArray8[99] = 146;
        nArray8[100] = 147;
        nArray8[101] = 148;
        nArray8[102] = 149;
        nArray8[103] = 150;
        nArray8[104] = 151;
        nArray8[105] = 152;
        nArray8[106] = 153;
        nArray8[107] = 154;
        nArray8[108] = 162;
        nArray8[109] = 163;
        nArray8[110] = 164;
        nArray8[111] = 165;
        nArray8[112] = 166;
        nArray8[113] = 167;
        nArray8[114] = 168;
        nArray8[115] = 169;
        nArray8[116] = 170;
        nArray8[117] = 178;
        nArray8[118] = 179;
        nArray8[119] = 180;
        nArray8[120] = 181;
        nArray8[121] = 182;
        nArray8[122] = 183;
        nArray8[123] = 184;
        nArray8[124] = 185;
        nArray8[125] = 186;
        nArray8[126] = 194;
        nArray8[127] = 195;
        nArray8[128] = 196;
        nArray8[129] = 197;
        nArray8[130] = 198;
        nArray8[131] = 199;
        nArray8[132] = 200;
        nArray8[133] = 201;
        nArray8[134] = 202;
        nArray8[135] = 210;
        nArray8[136] = 211;
        nArray8[137] = 212;
        nArray8[138] = 213;
        nArray8[139] = 214;
        nArray8[140] = 215;
        nArray8[141] = 216;
        nArray8[142] = 217;
        nArray8[143] = 218;
        nArray8[144] = 226;
        nArray8[145] = 227;
        nArray8[146] = 228;
        nArray8[147] = 229;
        nArray8[148] = 230;
        nArray8[149] = 231;
        nArray8[150] = 232;
        nArray8[151] = 233;
        nArray8[152] = 234;
        nArray8[153] = 242;
        nArray8[154] = 243;
        nArray8[155] = 244;
        nArray8[156] = 245;
        nArray8[157] = 246;
        nArray8[158] = 247;
        nArray8[159] = 248;
        nArray8[160] = 249;
        nArray8[161] = 250;
        chm_ac_symbols = nArray8;
        int[] nArray9 = new int[64];
        nArray9[1] = 1;
        nArray9[2] = 8;
        nArray9[3] = 16;
        nArray9[4] = 9;
        nArray9[5] = 2;
        nArray9[6] = 3;
        nArray9[7] = 10;
        nArray9[8] = 17;
        nArray9[9] = 24;
        nArray9[10] = 32;
        nArray9[11] = 25;
        nArray9[12] = 18;
        nArray9[13] = 11;
        nArray9[14] = 4;
        nArray9[15] = 5;
        nArray9[16] = 12;
        nArray9[17] = 19;
        nArray9[18] = 26;
        nArray9[19] = 33;
        nArray9[20] = 40;
        nArray9[21] = 48;
        nArray9[22] = 41;
        nArray9[23] = 34;
        nArray9[24] = 27;
        nArray9[25] = 20;
        nArray9[26] = 13;
        nArray9[27] = 6;
        nArray9[28] = 7;
        nArray9[29] = 14;
        nArray9[30] = 21;
        nArray9[31] = 28;
        nArray9[32] = 35;
        nArray9[33] = 42;
        nArray9[34] = 49;
        nArray9[35] = 56;
        nArray9[36] = 57;
        nArray9[37] = 50;
        nArray9[38] = 43;
        nArray9[39] = 36;
        nArray9[40] = 29;
        nArray9[41] = 22;
        nArray9[42] = 15;
        nArray9[43] = 23;
        nArray9[44] = 30;
        nArray9[45] = 37;
        nArray9[46] = 44;
        nArray9[47] = 51;
        nArray9[48] = 58;
        nArray9[49] = 59;
        nArray9[50] = 52;
        nArray9[51] = 45;
        nArray9[52] = 38;
        nArray9[53] = 31;
        nArray9[54] = 39;
        nArray9[55] = 46;
        nArray9[56] = 53;
        nArray9[57] = 60;
        nArray9[58] = 61;
        nArray9[59] = 54;
        nArray9[60] = 47;
        nArray9[61] = 55;
        nArray9[62] = 62;
        nArray9[63] = 63;
        ZigZag = nArray9;
        jpeg_luma_quantizer = new int[]{16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99};
        jpeg_chroma_quantizer = new int[]{17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
    }

    public JPEGFrame(RTPDePacketizer rTPDePacketizer, Buffer buffer, byte[] byArray) {
        this.depacketizer = rTPDePacketizer;
        this.firstSeq = buffer.getSequenceNumber();
        if (rTPDePacketizer.frameBuffer == null) {
            rTPDePacketizer.frameBuffer = byArray != null ? byArray : new byte[32000];
        }
        this.rtptimestamp = buffer.getTimeStamp();
        int n2 = 0;
        if (!this.hasJFIFHeader(buffer)) {
            n2 = this.generateJFIFHeader(buffer);
        }
        this.add(buffer, n2);
    }

    public void add(Buffer buffer, int n2) {
        int n3 = buffer.getLength() - 8 - n2;
        int n4 = this.depacketizer.getFragOffset((byte[])buffer.getData(), buffer.getOffset());
        if (this.depacketizer.frameBuffer.length >= (n4 += this.hdrOffset) + n3 + 2) {
            System.arraycopy((byte[])buffer.getData(), buffer.getOffset() + 8 + n2, this.depacketizer.frameBuffer, n4, n3);
            this.dataLength += n3;
            ++this.numPkts;
        } else {
            this.increaseFrameBuffer(n4 + n3 + 2);
            this.add(buffer, n2);
        }
    }

    public void completeTransfer(Buffer buffer, Buffer buffer2) {
        int n2 = buffer.getOffset();
        byte[] byArray = (byte[])buffer.getData();
        int n3 = byArray[n2 + 7] & 0xFF;
        int n4 = byArray[n2 + 6] & 0xFF;
        this.depacketizer.quality = byArray[n2 + 5] & 0xFF;
        this.depacketizer.type = byArray[n2 + 4] & 0xFF;
        Dimension dimension = new Dimension(n4 * 8, n3 * 8);
        buffer.setFormat(new VideoFormat("jpeg", dimension, 0, buffer.getFormat().getDataType(), -1.0f));
        if (this.depacketizer.frameBuffer[this.dataLength - 2] != -1 || this.depacketizer.frameBuffer[this.dataLength - 1] != -39) {
            this.depacketizer.frameBuffer[this.dataLength++] = -1;
            this.depacketizer.frameBuffer[this.dataLength++] = -39;
        }
        buffer2.setData(this.depacketizer.frameBuffer);
        buffer2.setSequenceNumber(this.depacketizer.sequenceNumber++);
        buffer2.setLength(this.dataLength);
        this.depacketizer.frameBuffer = null;
    }

    private int generateJFIFHeader(Buffer buffer) {
        int n2 = 0;
        byte[] byArray = (byte[])buffer.getData();
        int n3 = buffer.getOffset();
        int n4 = byArray[n3 + 4] & 0xFF;
        int n5 = byArray[n3 + 5] & 0xFF;
        int n6 = byArray[n3 + 6] & 0xFF;
        int n7 = byArray[n3 + 7] & 0xFF;
        if (n5 == this.depacketizer.lastQuality && n6 == this.depacketizer.lastWidth && n7 == this.depacketizer.lastHeight && n4 == this.depacketizer.lastType) {
            System.arraycopy(this.depacketizer.lastJFIFHeader, 0, this.depacketizer.frameBuffer, 0, this.depacketizer.lastJFIFHeader.length);
            this.hdrOffset = this.depacketizer.lastJFIFHeader.length;
        } else {
            this.hdrOffset = this.makeHeaders(this.depacketizer.frameBuffer, 0, n4, n5, n6, n7);
            this.depacketizer.lastJFIFHeader = new byte[this.hdrOffset];
            System.arraycopy(this.depacketizer.frameBuffer, 0, this.depacketizer.lastJFIFHeader, 0, this.hdrOffset);
            this.depacketizer.lastQuality = n5;
            this.depacketizer.lastType = n4;
            this.depacketizer.lastWidth = n6;
            this.depacketizer.lastHeight = n7;
        }
        if (n5 >= 100) {
            n2 = 132;
            System.arraycopy(byArray, n3 + 8 + 4, this.depacketizer.frameBuffer, this.lquantOffset, 64);
            System.arraycopy(byArray, n3 + 8 + 4 + 64, this.depacketizer.frameBuffer, this.cquantOffset, 64);
        }
        this.dataLength += this.depacketizer.lastJFIFHeader.length;
        return n2;
    }

    public boolean gotAllPackets(long l2) {
        return l2 - this.firstSeq + 1L == this.numPkts;
    }

    private boolean hasJFIFHeader(Buffer buffer) {
        int n2;
        byte[] byArray = (byte[])buffer.getData();
        return (byArray[(n2 = buffer.getOffset()) + 8] & 0xFF) == 255 && (byArray[n2 + 9] & 0xFF) == 216;
    }

    private void increaseFrameBuffer(int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.depacketizer.frameBuffer, 0, byArray, 0, this.depacketizer.frameBuffer.length);
        this.depacketizer.frameBuffer = byArray;
    }

    private int makeHeaders(byte[] byArray, int n2, int n3, int n4, int n5, int n6) {
        int[] nArray = new int[64];
        int[] nArray2 = new int[64];
        n5 *= 8;
        n6 *= 8;
        this.makeQTables(n4, nArray, nArray2);
        byArray[n2++] = -1;
        byArray[n2++] = -40;
        int n7 = 0;
        while (n7 < APP0.length) {
            byArray[n2++] = APP0[n7];
            ++n7;
        }
        n2 = this.makeQuantHeader(byArray, n2, nArray, 0);
        n2 = this.makeQuantHeader(byArray, n2, nArray2, 1);
        n2 = this.makeHuffmanHeader(byArray, n2, lum_dc_codelens, lum_dc_codelens.length, lum_dc_symbols, lum_dc_symbols.length, 0, 0);
        n2 = this.makeHuffmanHeader(byArray, n2, lum_ac_codelens, lum_ac_codelens.length, lum_ac_symbols, lum_ac_symbols.length, 0, 1);
        n2 = this.makeHuffmanHeader(byArray, n2, chm_dc_codelens, chm_dc_codelens.length, chm_dc_symbols, chm_dc_symbols.length, 1, 0);
        n2 = this.makeHuffmanHeader(byArray, n2, chm_ac_codelens, chm_ac_codelens.length, chm_ac_symbols, chm_ac_symbols.length, 1, 1);
        byArray[n2++] = -1;
        byArray[n2++] = -64;
        byArray[n2++] = 0;
        byArray[n2++] = 17;
        byArray[n2++] = 8;
        byArray[n2++] = (byte)(n6 >> 8 & 0xFF);
        byArray[n2++] = (byte)(n6 & 0xFF);
        byArray[n2++] = (byte)(n5 >> 8 & 0xFF);
        byArray[n2++] = (byte)(n5 & 0xFF);
        byArray[n2++] = 3;
        byArray[n2++] = 0;
        byArray[n2++] = n3 == 2 ? 17 : (n3 == 1 ? 34 : 33);
        byArray[n2++] = 0;
        byArray[n2++] = 1;
        byArray[n2++] = 17;
        byArray[n2++] = 1;
        byArray[n2++] = 2;
        byArray[n2++] = 17;
        byArray[n2++] = 1;
        byArray[n2++] = -1;
        byArray[n2++] = -38;
        byArray[n2++] = 0;
        byArray[n2++] = 12;
        byArray[n2++] = 3;
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        byArray[n2++] = 1;
        byArray[n2++] = 17;
        byArray[n2++] = 2;
        byArray[n2++] = 17;
        byArray[n2++] = 0;
        byArray[n2++] = 63;
        byArray[n2++] = 0;
        return n2;
    }

    private int makeHuffmanHeader(byte[] byArray, int n2, int[] nArray, int n3, int[] nArray2, int n4, int n5, int n6) {
        byArray[n2++] = -1;
        byArray[n2++] = -60;
        byArray[n2++] = 0;
        byArray[n2++] = (byte)(3 + n3 + n4);
        byArray[n2++] = (byte)(n6 << 4 | n5);
        int n7 = 0;
        while (n7 < n3) {
            byArray[n2++] = (byte)nArray[n7];
            ++n7;
        }
        n7 = 0;
        while (n7 < n4) {
            byArray[n2++] = (byte)nArray2[n7];
            ++n7;
        }
        return n2;
    }

    private void makeQTables(int n2, int[] nArray, int[] nArray2) {
        int n3 = n2;
        if (n2 < 1) {
            n3 = 1;
        }
        if (n2 > 99) {
            n3 = 99;
        }
        n2 = n2 < 50 ? 5000 / n3 : 200 - n3 * 2;
        int n4 = 0;
        while (n4 < 64) {
            int n5 = (jpeg_luma_quantizer[ZigZag[n4]] * n2 + 50) / 100;
            int n6 = (jpeg_chroma_quantizer[ZigZag[n4]] * n2 + 50) / 100;
            if (n5 < 1) {
                n5 = 1;
            } else if (n5 > 255) {
                n5 = 255;
            }
            nArray[n4] = n5;
            if (n6 < 1) {
                n6 = 1;
            } else if (n6 > 255) {
                n6 = 255;
            }
            nArray2[n4] = n6;
            ++n4;
        }
    }

    private int makeQuantHeader(byte[] byArray, int n2, int[] nArray, int n3) {
        byArray[n2++] = -1;
        byArray[n2++] = -37;
        byArray[n2++] = 0;
        byArray[n2++] = 67;
        byArray[n2++] = (byte)n3;
        int n4 = 0;
        while (n4 < 64) {
            byArray[n2++] = (byte)nArray[n4];
            ++n4;
        }
        return n2;
    }
}

