/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.Matrix;
import com.sun.media.content.application.x_shockwave_flash.Rect;
import java.awt.Point;

class Curve {
    int anchor1x;
    int anchor1y;
    int controlx;
    int controly;
    int anchor2x;
    int anchor2y;
    boolean isLine = false;

    Curve() {
    }

    Curve(Curve curve) {
        this.anchor1x = curve.anchor1x;
        this.anchor1y = curve.anchor1y;
        this.anchor2x = curve.anchor2x;
        this.anchor2y = curve.anchor2y;
        this.controlx = curve.controlx;
        this.controly = curve.controly;
        this.isLine = curve.isLine;
    }

    final int XRaySect(Point point, int n2) {
        Rect rect = new Rect(this.anchor1x, this.anchor1y, this.anchor2x, this.anchor2y);
        if (this.controlx < rect.xmin) {
            rect.xmin = this.controlx;
        } else if (this.controlx > rect.xmax) {
            rect.xmax = this.controlx;
        }
        if (this.controly < rect.ymin) {
            rect.ymin = this.controly;
        } else if (this.controly > rect.ymax) {
            rect.ymax = this.controly;
        }
        if (rect.xmax < point.x || rect.ymin > point.y || rect.ymax <= point.y) {
            return 0;
        }
        if (rect.pointIn(point) && n2 < 12 && Matrix.fastLength(rect.xmax - rect.xmin, rect.ymax - rect.ymin) > 4) {
            Curve curve = new Curve(this);
            Curve curve2 = curve.divide(32768);
            return curve.XRaySect(point, ++n2) + curve2.XRaySect(point, n2);
        }
        int n3 = this.anchor1y;
        int n4 = this.anchor2y;
        if (n3 == n4) {
            return 0;
        }
        if (n3 > n4) {
            int n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        if (point.y >= n3 && point.y < n4) {
            return 1;
        }
        return 0;
    }

    final Curve divide(int n2) {
        Curve curve = new Curve();
        curve.anchor2x = this.anchor2x;
        curve.anchor2y = this.anchor2y;
        curve.controlx = Matrix.mul(n2, this.anchor2x - this.controlx) + this.controlx;
        curve.controly = Matrix.mul(n2, this.anchor2y - this.controly) + this.controly;
        this.controlx = Matrix.mul(n2, this.controlx - this.anchor1x) + this.anchor1x;
        this.controly = Matrix.mul(n2, this.controly - this.anchor1y) + this.anchor1y;
        this.anchor2x = curve.anchor1x = Matrix.mul(n2, curve.controlx - this.controlx) + this.controlx;
        this.anchor2y = curve.anchor1y = Matrix.mul(n2, curve.controly - this.controly) + this.controly;
        curve.isLine = this.isLine;
        return curve;
    }

    final int flatness() {
        return Matrix.fastLength(this.controlx - (this.anchor1x + this.anchor2x) / 2, this.controly - (this.anchor1y + this.anchor2y) / 2);
    }

    final void set(Point point, Point point2) {
        this.anchor1x = point.x;
        this.anchor1y = point.y;
        this.anchor2x = point2.x;
        this.anchor2y = point2.y;
        this.controlx = (this.anchor1x + this.anchor2x) / 2;
        this.controly = (this.anchor1y + this.anchor2y) / 2;
        this.isLine = true;
    }

    final void set(Point point, Point point2, Point point3) {
        this.anchor1x = point.x;
        this.anchor1y = point.y;
        this.anchor2x = point3.x;
        this.anchor2y = point3.y;
        this.controlx = point2.x;
        this.controly = point2.y;
        this.isLine = false;
    }
}

