/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.Rect;
import java.awt.Point;

class Matrix {
    int a = 65536;
    int b = 0;
    int c = 0;
    int d = 65536;
    int tx = 0;
    int ty = 0;
    static final int one = 65536;
    static final int sqrt2 = 92682;
    private static final int[] lengthTable = new int[]{0x40000000, 1073872888, 1074265984, 1074920825, 1075836932, 1077013639, 1078450093, 1080145258, 1082097918, 1084306681, 1086769986, 1089486107, 1092453157, 1095669100, 1099131748, 1102838780, 1106787739, 1110976045, 1115401003, 1120059807, 1124949552, 1130067241, 1135409791, 1140974043, 1146756771, 1152754686, 1158964447, 1165382668, 1172005924, 1178830760, 1185853694, 1193071229, 1200479854, 1208076055, 1215856315, 1223817123, 1231954981, 1240266402, 1248747921, 1257396097, 1266207514, 1275178788, 1284306569, 1293587545, 1303018442, 1312596028, 1322317116, 1332178565, 0x50000000, 1352310217, 1362574382, 1372966831, 1383484673, 1394125071, 1404885240, 1415762448, 1426754019, 1437857331, 1449069814, 1460388955, 1471812291, 1483337417, 1494961978, 1506683672, 1518500250, 1518500250};

    Matrix() {
    }

    Matrix(Matrix matrix) {
        this.a = matrix.a;
        this.b = matrix.b;
        this.c = matrix.c;
        this.d = matrix.d;
        this.tx = matrix.tx;
        this.ty = matrix.ty;
    }

    static final int abs(int n2) {
        return n2 > 0 ? n2 : -n2;
    }

    static final Matrix concat(Matrix matrix, Matrix matrix2) {
        Matrix matrix3 = new Matrix();
        matrix3.a = Matrix.mul(matrix.a, matrix2.a);
        matrix3.d = Matrix.mul(matrix.d, matrix2.d);
        matrix3.tx = Matrix.mul(matrix.tx, matrix2.a) + matrix2.tx;
        matrix3.ty = Matrix.mul(matrix.ty, matrix2.d) + matrix2.ty;
        if (matrix.b != 0 || matrix.c != 0 || matrix2.b != 0 || matrix2.c != 0) {
            matrix3.a += Matrix.mul(matrix.b, matrix2.c);
            matrix3.d += Matrix.mul(matrix.c, matrix2.b);
            matrix3.b += Matrix.mul(matrix.a, matrix2.b) + Matrix.mul(matrix.b, matrix2.d);
            matrix3.c += Matrix.mul(matrix.c, matrix2.a) + Matrix.mul(matrix.d, matrix2.c);
            matrix3.tx += Matrix.mul(matrix.ty, matrix2.c);
            matrix3.ty += Matrix.mul(matrix.tx, matrix2.b);
        }
        return matrix3;
    }

    final void deltaTransform(Point point) {
        int n2 = Matrix.mul(this.a, point.x);
        if (this.c != 0) {
            n2 += Matrix.mul(this.c, point.y);
        }
        int n3 = Matrix.mul(this.d, point.y);
        if (this.b != 0) {
            n3 += Matrix.mul(this.b, point.x);
        }
        point.x = n2;
        point.y = n3;
    }

    static final int div(int n2, int n3) {
        if (n3 != 0) {
            return (int)(((long)n2 << 16) / (long)n3);
        }
        return Integer.MAX_VALUE;
    }

    static final int fastLength(int n2, int n3) {
        int n4 = Matrix.abs(n2);
        int n5 = Matrix.abs(n3);
        return n4 + n5 - (Math.min(n4, n5) >> 1);
    }

    final Matrix invert() {
        Matrix matrix = new Matrix();
        if (this.b == 0 && this.c == 0) {
            matrix.a = Matrix.div(65536, this.a);
            matrix.d = Matrix.div(65536, this.d);
            matrix.tx = -Matrix.mul(matrix.a, this.tx);
            matrix.ty = -Matrix.mul(matrix.d, this.ty);
        } else {
            double d2 = (double)this.a * 1.52587890625E-5;
            double d3 = (double)this.d * 1.52587890625E-5;
            double d4 = (double)this.b * 1.52587890625E-5;
            double d5 = (double)this.c * 1.52587890625E-5;
            double d6 = d2 * d3 - d4 * d5;
            if (d6 != 0.0) {
                d6 = 1.0 / d6;
                matrix.a = (int)(d3 * d6 * 65536.0);
                matrix.b = -((int)(d4 * d6 * 65536.0));
                matrix.c = -((int)(d5 * d6 * 65536.0));
                matrix.d = (int)(d2 * d6 * 65536.0);
                Point point = new Point(this.tx, this.ty);
                matrix.deltaTransform(point);
                matrix.tx = -point.x;
                matrix.ty = -point.y;
            }
        }
        return matrix;
    }

    static final int length(int n2, int n3) {
        int n4;
        int n5;
        int n6 = Matrix.abs(n2);
        if (n6 > (n5 = Matrix.abs(n3))) {
            n4 = n6;
            n6 = n5;
            n5 = n4;
        }
        if (n5 == 0) {
            return 0;
        }
        n4 = Matrix.div(n6, n5);
        int n7 = n4 >> 10;
        int n8 = (n4 & 0x3FF) << 6;
        int n9 = Matrix.mul(65536 - n8, lengthTable[n7]) + Matrix.mul(n8, lengthTable[n7 + 1]);
        return Matrix.mul(n5, n9 >>= 14);
    }

    static final int mul(int n2, int n3) {
        return (int)((long)n2 * (long)n3 + 32768L >> 16);
    }

    final void scale(int n2, int n3) {
        this.a = n2;
        this.d = n3;
        this.c = 0;
        this.b = 0;
        this.ty = 0;
        this.tx = 0;
    }

    int transform(int n2) {
        Point point = new Point(n2, n2);
        this.deltaTransform(point);
        int n3 = Matrix.mul(46341, Matrix.length(point.x, point.y));
        if (n2 > 0) {
            n3 = Math.max(1, n3);
        }
        return n3;
    }

    final Rect transform(Rect rect) {
        Rect rect2 = new Rect();
        if (!rect.isEmpty()) {
            Point point = new Point(rect.xmin, rect.ymin);
            Point point2 = new Point(0, 0);
            this.transform(point, point2);
            rect2.union(point2);
            point.x = rect.xmax;
            this.transform(point, point2);
            rect2.union(point2);
            point.y = rect.ymax;
            this.transform(point, point2);
            rect2.union(point2);
            point.x = rect.xmin;
            this.transform(point, point2);
            rect2.union(point2);
        }
        return rect2;
    }

    final void transform(Point point) {
        int n2 = Matrix.mul(this.a, point.x) + this.tx;
        if (this.c != 0) {
            n2 += Matrix.mul(this.c, point.y);
        }
        int n3 = Matrix.mul(this.d, point.y) + this.ty;
        if (this.b != 0) {
            n3 += Matrix.mul(this.b, point.x);
        }
        point.x = n2;
        point.y = n3;
    }

    final void transform(Point point, Point point2) {
        int n2 = Matrix.mul(this.a, point.x) + this.tx;
        if (this.c != 0) {
            n2 += Matrix.mul(this.c, point.y);
        }
        int n3 = Matrix.mul(this.d, point.y) + this.ty;
        if (this.b != 0) {
            n3 += Matrix.mul(this.b, point.x);
        }
        point2.x = n2;
        point2.y = n3;
    }
}

