/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol;

import java.io.IOException;
import javax.media.Duration;
import javax.media.Time;
import javax.media.protocol.PullBufferDataSource;

public abstract class BasicPullBufferDataSource
extends PullBufferDataSource {
    protected Object[] controls = new Object[0];
    protected boolean started = false;
    protected String contentType = "content/unknown";
    protected boolean connected = false;
    protected Time duration = Duration.DURATION_UNKNOWN;

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.connected = true;
    }

    public void disconnect() {
        try {
            if (this.started) {
                this.stop();
            }
        }
        catch (IOException iOException) {}
        this.connected = false;
    }

    public String getContentType() {
        if (!this.connected) {
            System.err.println("Error: DataSource not connected");
            return null;
        }
        return this.contentType;
    }

    public Object getControl(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object[] objectArray = this.getControls();
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (clazz.isInstance(objectArray[n2])) {
                    return objectArray[n2];
                }
                ++n2;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object[] getControls() {
        return this.controls;
    }

    public Time getDuration() {
        return this.duration;
    }

    public void start() throws IOException {
        if (!this.connected) {
            throw new Error("DataSource must be connected before it can be started");
        }
        if (this.started) {
            return;
        }
        this.started = true;
    }

    public void stop() throws IOException {
        if (!this.connected || !this.started) {
            return;
        }
        this.started = false;
    }
}

