/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.rtp;

import com.sun.media.protocol.BasicPushBufferDataSource;
import com.sun.media.protocol.BufferListener;
import com.sun.media.protocol.RTPSource;
import com.sun.media.protocol.Streamable;
import com.sun.media.rtp.RTPControlImpl;
import com.sun.media.rtp.RTPSessionMgr;
import com.sun.media.rtp.RTPSourceStream;
import com.sun.media.rtp.SSRCInfo;
import java.io.IOException;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.RTPControl;

public class DataSource
extends BasicPushBufferDataSource
implements Streamable,
RTPSource {
    static int SSRC_UNDEFINED = 0;
    private RTPSourceStream[] srcStreams = null;
    private boolean stopped = true;
    Player streamplayer = null;
    RTPSessionMgr mgr = null;
    RTPControl rtpcontrol = null;
    DataSource childsrc = null;
    int ssrc = SSRC_UNDEFINED;

    public DataSource() {
        this.srcStreams = new RTPSourceStream[1];
        this.rtpcontrol = new MyRTPControl();
        this.setContentType("rtp");
    }

    public void connect() throws IOException {
        if (this.srcStreams != null) {
            int n2 = 0;
            while (n2 < this.srcStreams.length) {
                if (this.srcStreams[n2] != null) {
                    this.srcStreams[n2].connect();
                }
                ++n2;
            }
        }
        this.connected = true;
    }

    public void disconnect() {
        if (this.srcStreams != null) {
            int n2 = 0;
            while (n2 < this.srcStreams.length) {
                this.srcStreams[n2].close();
                ++n2;
            }
        }
    }

    public void flush() {
        this.srcStreams[0].reset();
    }

    public String getCNAME() {
        if (this.mgr == null) {
            return null;
        }
        SSRCInfo sSRCInfo = this.mgr.getSSRCInfo(this.ssrc);
        if (sSRCInfo != null) {
            return sSRCInfo.getCNAME();
        }
        return null;
    }

    public Object getControl(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        Object[] objectArray = this.getControls();
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (clazz.isInstance(objectArray[n2])) {
                return objectArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public Object[] getControls() {
        Object[] objectArray = new RTPControl[]{this.rtpcontrol};
        return objectArray;
    }

    public RTPSessionMgr getMgr() {
        return this.mgr;
    }

    public Player getPlayer() {
        return this.streamplayer;
    }

    public int getSSRC() {
        return this.ssrc;
    }

    public PushBufferStream[] getStreams() {
        if (!this.connected) {
            return null;
        }
        return this.srcStreams;
    }

    public boolean isPrefetchable() {
        return false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void prebuffer() {
        this.started = true;
        this.srcStreams[0].prebuffer();
    }

    public void setBufferListener(BufferListener bufferListener) {
        this.srcStreams[0].setBufferListener(bufferListener);
    }

    public void setBufferWhenStopped(boolean bl) {
        this.srcStreams[0].setBufferWhenStopped(bl);
    }

    public void setChild(DataSource dataSource) {
        this.childsrc = dataSource;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public void setControl(Object object) {
        this.rtpcontrol = (RTPControl)object;
    }

    public void setLocator(MediaLocator mediaLocator) {
        super.setLocator(mediaLocator);
    }

    public void setMgr(RTPSessionMgr rTPSessionMgr) {
        this.mgr = rTPSessionMgr;
    }

    public void setPlayer(Player player) {
        this.streamplayer = player;
    }

    public void setSSRC(int n2) {
        this.ssrc = n2;
    }

    public void setSourceStream(RTPSourceStream rTPSourceStream) {
        if (this.srcStreams != null) {
            this.srcStreams[0] = rTPSourceStream;
        }
    }

    public void start() throws IOException {
        super.start();
        if (this.childsrc != null) {
            this.childsrc.start();
        }
        if (this.srcStreams != null) {
            int n2 = 0;
            while (n2 < this.srcStreams.length) {
                this.srcStreams[n2].start();
                ++n2;
            }
        }
    }

    public void stop() throws IOException {
        super.stop();
        if (this.childsrc != null) {
            this.childsrc.stop();
        }
        if (this.srcStreams != null) {
            int n2 = 0;
            while (n2 < this.srcStreams.length) {
                this.srcStreams[n2].stop();
                ++n2;
            }
        }
    }

    class MyRTPControl
    extends RTPControlImpl {
        MyRTPControl() {
        }

        public String getCNAME() {
            if (DataSource.this.mgr == null) {
                return null;
            }
            SSRCInfo sSRCInfo = DataSource.this.mgr.getSSRCInfo(DataSource.this.ssrc);
            if (sSRCInfo != null) {
                return sSRCInfo.getCNAME();
            }
            return null;
        }

        public int getSSRC() {
            return DataSource.this.ssrc;
        }
    }
}

