/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.video;

import com.sun.media.JMFSecurityManager;
import com.sun.media.NBA;
import com.sun.media.renderer.video.BasicVideoRenderer;
import com.sun.media.util.WindowUtil;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.IndexedColorFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class GDIRenderer
extends BasicVideoRenderer {
    private static boolean available = false;
    private int blitter = 0;
    protected Object data = null;
    private int defbitsPerPixel;
    private int defrMask;
    private int defgMask;
    private int defbMask;
    private int offsetX = 0;
    private int offsetY = 0;
    private int bytesPerPixel = 4;
    private int bitsPerPixel;
    private int rMask;
    private int gMask;
    private int bMask;
    private int pixelStride;
    private int lineStride;
    private boolean flipped;
    private int handle = 0;
    protected VideoFormat defaultFormat;

    static {
        try {
            JMFSecurityManager.loadLibrary("jmgdi");
            available = true;
        }
        catch (Exception exception) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
    }

    public GDIRenderer() {
        super("Windows GDI Renderer");
        if (available) {
            if (this.gdiInitialize()) {
                Class clazz = this.defbitsPerPixel <= 8 ? Format.byteArray : (this.defbitsPerPixel <= 16 ? Format.shortArray : (this.defbitsPerPixel <= 24 ? Format.byteArray : Format.intArray));
                this.defaultFormat = new RGBFormat(null, -1, clazz, -1.0f, this.defbitsPerPixel, this.defrMask, this.defgMask, this.defbMask, this.defbitsPerPixel == 24 ? 3 : 1, -1, -1, -1);
                this.supportedFormats = new VideoFormat[8];
                this.supportedFormats[0] = this.defaultFormat;
                this.supportedFormats[1] = new RGBFormat(null, -1, Format.shortArray, -1.0f, 16, 31744, 992, 31, 1, -1, -1, -1);
                this.supportedFormats[2] = new RGBFormat(null, -1, Format.byteArray, -1.0f, 16, 31744, 992, 31, 2, -1, -1, 1);
                this.supportedFormats[3] = new RGBFormat(null, -1, Format.shortArray, -1.0f, 16, 63488, 2016, 31, 1, -1, -1, -1);
                this.supportedFormats[4] = new RGBFormat(null, -1, Format.byteArray, -1.0f, 16, 63488, 2016, 31, 2, -1, -1, 1);
                this.supportedFormats[5] = new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, -1, -1, -1);
                this.supportedFormats[6] = new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255, 1, -1, -1, -1);
                this.supportedFormats[7] = new RGBFormat(null, -1, Format.byteArray, -1.0f, 32, 3, 2, 1, 4, -1, -1, -1);
            } else {
                System.err.println("GDIRenderer. gdiInitialize() failed");
                available = false;
            }
        }
    }

    public void close() {
        if (available) {
            this.gdiFree();
        }
    }

    protected int doProcess(Buffer buffer) {
        return this.doProcess(buffer, false);
    }

    protected synchronized int doProcess(Buffer buffer, boolean bl) {
        if (!available || this.component == null) {
            return 0;
        }
        if (this.handle == 0) {
            this.handle = WindowUtil.getWindowHandle(this.component);
        }
        if (this.handle == 0) {
            return 0;
        }
        if (!bl && !buffer.getFormat().equals(this.inputFormat) && this.setInputFormat(buffer.getFormat()) == null) {
            return 1;
        }
        if (!bl) {
            this.data = this.getInputData(buffer);
        }
        int n2 = 1;
        if (this.data instanceof short[]) {
            n2 = 2;
        } else if (this.data instanceof int[]) {
            n2 = 4;
        }
        this.bytesPerPixel = this.bitsPerPixel / 8;
        long l2 = 0L;
        if (this.data instanceof NBA) {
            l2 = ((NBA)this.data).data;
        }
        if (this.data == null) {
            return 0;
        }
        if (this.outWidth > 0 && this.outHeight > 0) {
            int n3 = this.gdiDraw(this.data, l2, n2, this.bytesPerPixel, this.inWidth, this.inHeight, this.lineStride / this.pixelStride, this.outWidth, this.outHeight, this.rMask, this.gMask, this.bMask, this.flipped, this.handle) ? 0 : 1;
            return n3;
        }
        return 0;
    }

    private synchronized native boolean gdiDraw(Object var1, long var2, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, boolean var14, int var15);

    private synchronized native boolean gdiFree();

    private synchronized native boolean gdiInitialize();

    private synchronized native boolean gdiSetComponent(int var1);

    private synchronized native boolean gdiSetOutputSize(int var1, int var2);

    public void open() throws ResourceUnavailableException {
        if (!available) {
            throw new ResourceUnavailableException("GDI not available !!!");
        }
        this.handle = 0;
        if (this.blitter == 0) {
            this.gdiInitialize();
        }
        if (this.blitter == 0) {
            throw new ResourceUnavailableException("GDIRenderer couldn't open");
        }
    }

    protected synchronized void repaint() {
        if (!this.isStarted() && this.data != null) {
            this.doProcess(null, true);
        }
    }

    public synchronized void reset() {
        this.handle = 0;
    }

    protected synchronized void setAvailable(boolean bl) {
        super.setAvailable(bl);
        this.handle = 0;
    }

    public Format setInputFormat(Format format) {
        if (!available) {
            return null;
        }
        if (super.setInputFormat(format) != null) {
            if (this.inputFormat instanceof RGBFormat) {
                RGBFormat rGBFormat = (RGBFormat)this.inputFormat;
                this.bitsPerPixel = rGBFormat.getBitsPerPixel();
                this.rMask = rGBFormat.getRedMask();
                this.gMask = rGBFormat.getGreenMask();
                this.bMask = rGBFormat.getBlueMask();
                this.lineStride = rGBFormat.getLineStride();
                this.pixelStride = rGBFormat.getPixelStride();
                boolean bl = this.flipped = rGBFormat.getFlipped() == 1;
                if (this.inputFormat.getDataType() == Format.byteArray && this.bitsPerPixel > 16) {
                    int n2 = this.bitsPerPixel / 8;
                    this.rMask = 255 << (this.rMask - 1) * 8;
                    this.gMask = 255 << (this.gMask - 1) * 8;
                    this.bMask = 255 << (this.bMask - 1) * 8;
                }
            } else if (this.inputFormat instanceof IndexedColorFormat) {
                this.bitsPerPixel = 8;
                this.lineStride = ((IndexedColorFormat)format).getLineStride();
            } else {
                return null;
            }
            if (this.outWidth == -1 || this.outHeight == -1) {
                this.outWidth = this.inWidth;
                this.outHeight = this.inHeight;
            }
            if (this.component != null) {
                this.component.setSize(this.outWidth, this.outHeight);
            }
            return format;
        }
        return null;
    }
}

