/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPCompoundPacket;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import com.sun.media.rtp.util.PacketFilter;
import com.sun.media.rtp.util.RTPPacketSender;
import com.sun.media.rtp.util.UDPPacket;
import com.sun.media.rtp.util.UDPPacketSender;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.media.rtp.SessionAddress;

public class RTCPRawSender
extends PacketFilter {
    private InetAddress destaddr;
    private int destport;

    public RTCPRawSender(int n2, String string) throws UnknownHostException, IOException {
        this.destaddr = InetAddress.getByName(string);
        this.destport = n2 | 1;
        this.destAddressList = null;
    }

    public RTCPRawSender(int n2, String string, UDPPacketSender uDPPacketSender) throws UnknownHostException, IOException {
        this(n2, string);
        this.setConsumer(uDPPacketSender);
        this.destAddressList = null;
    }

    public RTCPRawSender(RTPPacketSender rTPPacketSender) {
        this.setConsumer(rTPPacketSender);
    }

    public void addDestAddr(InetAddress inetAddress) {
        int n2 = 0;
        if (this.destAddressList == null) {
            this.destAddressList = new Vector();
            this.destAddressList.addElement(this.destaddr);
        }
        n2 = 0;
        while (n2 < this.destAddressList.size()) {
            InetAddress inetAddress2 = (InetAddress)this.destAddressList.elementAt(n2);
            if (inetAddress2.equals(inetAddress)) break;
            ++n2;
        }
        if (n2 == this.destAddressList.size()) {
            this.destAddressList.addElement(inetAddress);
        }
    }

    public void assemble(RTCPCompoundPacket rTCPCompoundPacket) {
        int n2 = rTCPCompoundPacket.calcLength();
        rTCPCompoundPacket.assemble(n2, false);
    }

    public String filtername() {
        return "RTCP Raw Packet Sender";
    }

    public InetAddress getRemoteAddr() {
        return this.destaddr;
    }

    public Packet handlePacket(Packet packet) {
        this.assemble((RTCPCompoundPacket)packet);
        PacketConsumer packetConsumer = this.getConsumer();
        if (packetConsumer instanceof RTPPacketSender) {
            return packet;
        }
        UDPPacket uDPPacket = new UDPPacket();
        uDPPacket.received = false;
        uDPPacket.data = packet.data;
        uDPPacket.offset = packet.offset;
        uDPPacket.length = packet.length;
        uDPPacket.remoteAddress = this.destaddr;
        uDPPacket.remotePort = this.destport;
        return uDPPacket;
    }

    public Packet handlePacket(Packet packet, int n2) {
        this.assemble((RTCPCompoundPacket)packet);
        UDPPacket uDPPacket = new UDPPacket();
        uDPPacket.received = false;
        uDPPacket.data = packet.data;
        uDPPacket.offset = packet.offset;
        uDPPacket.length = packet.length;
        uDPPacket.remoteAddress = (InetAddress)this.destAddressList.elementAt(n2);
        uDPPacket.remotePort = this.destport;
        return uDPPacket;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionAddress) {
        this.assemble((RTCPCompoundPacket)packet);
        PacketConsumer packetConsumer = this.getConsumer();
        if (packetConsumer instanceof RTPPacketSender) {
            return packet;
        }
        UDPPacket uDPPacket = new UDPPacket();
        uDPPacket.received = false;
        uDPPacket.data = packet.data;
        uDPPacket.offset = packet.offset;
        uDPPacket.length = packet.length;
        uDPPacket.remoteAddress = sessionAddress.getControlAddress();
        uDPPacket.remotePort = sessionAddress.getControlPort();
        return uDPPacket;
    }

    public void setDestAddresses(Vector vector) {
        this.destAddressList = vector;
    }
}

