/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.Log;
import com.sun.media.rtp.OverallStats;
import com.sun.media.rtp.util.BadFormatException;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketFilter;
import com.sun.media.rtp.util.RTPPacket;
import com.sun.media.rtp.util.RTPPacketReceiver;
import com.sun.media.rtp.util.UDPPacketReceiver;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPPushDataSource;
import javax.media.rtp.SessionAddress;

public class RTPRawReceiver
extends PacketFilter {
    private OverallStats stats = null;
    private boolean recvBufSizeSet = false;
    public DatagramSocket socket;
    private RTPConnector rtpConnector = null;

    public RTPRawReceiver() {
    }

    public RTPRawReceiver(int n2, String string, OverallStats overallStats) throws UnknownHostException, IOException, SocketException {
        UDPPacketReceiver uDPPacketReceiver = new UDPPacketReceiver(n2 & 0xFFFFFFFE, string, -1, null, 2000, null);
        this.setSource(uDPPacketReceiver);
        this.socket = uDPPacketReceiver.getSocket();
        this.stats = overallStats;
    }

    public RTPRawReceiver(DatagramSocket datagramSocket, OverallStats overallStats) {
        this.setSource(new UDPPacketReceiver(datagramSocket, 2000));
        this.stats = overallStats;
    }

    public RTPRawReceiver(RTPConnector rTPConnector, OverallStats overallStats) {
        try {
            this.setSource(new RTPPacketReceiver(rTPConnector.getDataInputStream()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.rtpConnector = rTPConnector;
        this.stats = overallStats;
    }

    public RTPRawReceiver(RTPPushDataSource rTPPushDataSource, OverallStats overallStats) {
        this.setSource(new RTPPacketReceiver(rTPPushDataSource));
        this.stats = overallStats;
    }

    public RTPRawReceiver(SessionAddress sessionAddress, SessionAddress sessionAddress2, OverallStats overallStats, DatagramSocket datagramSocket) throws UnknownHostException, IOException, SocketException {
        this.stats = overallStats;
        UDPPacketReceiver uDPPacketReceiver = new UDPPacketReceiver(sessionAddress.getDataPort(), sessionAddress.getDataHostAddress(), sessionAddress2.getDataPort(), sessionAddress2.getDataHostAddress(), 2000, datagramSocket);
        this.setSource(uDPPacketReceiver);
        this.socket = uDPPacketReceiver.getSocket();
    }

    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.getSource() instanceof RTPPacketReceiver) {
            this.getSource().closeSource();
        }
    }

    public String filtername() {
        return "RTP Raw Packet Receiver";
    }

    public int getRecvBufSize() {
        try {
            if (this.socket != null) {
                Class<?> clazz = this.socket.getClass();
                Method method = clazz.getMethod("getReceiveBufferSize", null);
                Integer n2 = (Integer)method.invoke((Object)this.socket, null);
                return n2;
            }
            if (this.rtpConnector != null) {
                return this.rtpConnector.getReceiveBufferSize();
            }
        }
        catch (Exception exception) {}
        return -1;
    }

    public Packet handlePacket(Packet packet) {
        RTPPacket rTPPacket;
        this.stats.update(0, 1);
        this.stats.update(1, packet.length);
        try {
            rTPPacket = this.parse(packet);
        }
        catch (BadFormatException badFormatException) {
            this.stats.update(2, 1);
            return null;
        }
        if (!this.recvBufSizeSet) {
            this.recvBufSizeSet = true;
            switch (rTPPacket.payloadType) {
                case 14: 
                case 26: 
                case 34: 
                case 42: {
                    this.setRecvBufSize(64000);
                    break;
                }
                case 31: {
                    this.setRecvBufSize(128000);
                    break;
                }
                case 32: {
                    this.setRecvBufSize(128000);
                    break;
                }
                default: {
                    if (rTPPacket.payloadType < 96 || rTPPacket.payloadType > 127) break;
                    this.setRecvBufSize(64000);
                    break;
                }
            }
        }
        return rTPPacket;
    }

    public Packet handlePacket(Packet packet, int n2) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionAddress) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionAddress, boolean bl) {
        return null;
    }

    public RTPPacket parse(Packet packet) throws BadFormatException {
        RTPPacket rTPPacket = new RTPPacket(packet);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(rTPPacket.data, rTPPacket.offset, rTPPacket.length));
        try {
            int n2;
            int n3 = dataInputStream.readUnsignedByte();
            if ((n3 & 0xC0) != 128) {
                throw new BadFormatException();
            }
            if ((n3 & 0x10) != 0) {
                rTPPacket.extensionPresent = true;
            }
            int n4 = 0;
            if ((n3 & 0x20) != 0) {
                n4 = rTPPacket.data[rTPPacket.offset + rTPPacket.length - 1] & 0xFF;
            }
            n3 &= 0xF;
            rTPPacket.payloadType = dataInputStream.readUnsignedByte();
            rTPPacket.marker = rTPPacket.payloadType >> 7;
            rTPPacket.payloadType &= 0x7F;
            rTPPacket.seqnum = dataInputStream.readUnsignedShort();
            rTPPacket.timestamp = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
            rTPPacket.ssrc = dataInputStream.readInt();
            int n5 = 0;
            if (rTPPacket.extensionPresent) {
                rTPPacket.extensionType = dataInputStream.readUnsignedShort();
                n2 = dataInputStream.readUnsignedShort();
                rTPPacket.extension = new byte[n2 <<= 2];
                dataInputStream.readFully(rTPPacket.extension);
                n5 += n2 + 4;
            }
            rTPPacket.csrc = new int[n3];
            n2 = 0;
            while (n2 < rTPPacket.csrc.length) {
                rTPPacket.csrc[n2] = dataInputStream.readInt();
                ++n2;
            }
            rTPPacket.payloadlength = rTPPacket.length - ((n5 += 12 + (rTPPacket.csrc.length << 2)) + n4);
            if (rTPPacket.payloadlength < 1) {
                throw new BadFormatException();
            }
            rTPPacket.payloadoffset = n5 + rTPPacket.offset;
        }
        catch (EOFException eOFException) {
            throw new BadFormatException("Unexpected end of RTP packet");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Impossible Exception");
        }
        return rTPPacket;
    }

    public void setRecvBufSize(int n2) {
        try {
            if (this.socket != null) {
                Class<?> clazz = this.socket.getClass();
                Method method = clazz.getMethod("setReceiveBufferSize", Integer.TYPE);
                method.invoke((Object)this.socket, new Integer(n2));
            } else if (this.rtpConnector != null) {
                this.rtpConnector.setReceiveBufferSize(n2);
            }
        }
        catch (Exception exception) {
            Log.comment("Cannot set receive buffer size: " + exception);
        }
    }
}

