/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.OverallStats;
import com.sun.media.rtp.OverallTransStats;
import com.sun.media.rtp.PassiveSSRCInfo;
import com.sun.media.rtp.RTPEventHandler;
import com.sun.media.rtp.RTPSessionMgr;
import com.sun.media.rtp.RTPSourceInfoCache;
import com.sun.media.rtp.RecvSSRCInfo;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.SendSSRCInfo;
import com.sun.media.rtp.TrueRandom;
import com.sun.media.rtp.util.SSRCTable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.event.LocalCollisionEvent;
import javax.media.rtp.event.RTPEvent;
import javax.media.rtp.event.RemoteCollisionEvent;

public class SSRCCache {
    SSRCTable cache = new SSRCTable();
    RTPSourceInfoCache sourceInfoCache;
    OverallStats stats = null;
    OverallTransStats transstats = null;
    RTPEventHandler eventhandler;
    int[] clockrate = new int[128];
    static final int DATA = 1;
    static final int CONTROL = 2;
    static final int SRCDATA = 3;
    static final int RTCP_MIN_TIME = 5000;
    static final int BYE_THRESHOLD = 50;
    int sendercount = 0;
    double rtcp_bw_fraction = 0.0;
    double rtcp_sender_bw_fraction = 0.0;
    int rtcp_min_time = 5000;
    private static final int NOTIFYPERIOD = 500;
    int sessionbandwidth = 0;
    boolean initial = true;
    boolean byestate = false;
    boolean rtcpsent = false;
    int avgrtcpsize = 128;
    Hashtable conflicttable = new Hashtable(5);
    SSRCInfo ourssrc = null;
    public RTPSessionMgr sm;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    SSRCCache(RTPSessionMgr rTPSessionMgr) {
        if (jmfSecurity != null) {
            String string = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    string = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    string = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable throwable) {
                if (string.endsWith("group")) {
                    jmfSecurity.permissionFailureNotification(32);
                }
                jmfSecurity.permissionFailureNotification(16);
            }
        }
        this.stats = rTPSessionMgr.defaultstats;
        this.transstats = rTPSessionMgr.transstats;
        this.sourceInfoCache = new RTPSourceInfoCache();
        this.sourceInfoCache.setMainCache(this.sourceInfoCache);
        this.sourceInfoCache.setSSRCCache(this);
        this.sm = rTPSessionMgr;
        this.eventhandler = new RTPEventHandler(rTPSessionMgr);
        this.setclockrates();
    }

    SSRCCache(RTPSessionMgr rTPSessionMgr, RTPSourceInfoCache rTPSourceInfoCache) {
        this.stats = rTPSessionMgr.defaultstats;
        this.transstats = rTPSessionMgr.transstats;
        this.sourceInfoCache = rTPSourceInfoCache;
        rTPSourceInfoCache.setSSRCCache(this);
        this.sm = rTPSessionMgr;
        this.eventhandler = new RTPEventHandler(rTPSessionMgr);
    }

    private void LocalCollision(int n2) {
        int n3 = 0;
        while (this.lookup(n3 = (int)TrueRandom.rand()) != null) {
        }
        PassiveSSRCInfo passiveSSRCInfo = new PassiveSSRCInfo(this.ourssrc);
        passiveSSRCInfo.ssrc = n3;
        this.cache.put(n3, passiveSSRCInfo);
        this.changessrc(passiveSSRCInfo);
        this.ourssrc = passiveSSRCInfo;
        this.stats.update(3, 1);
        ++this.transstats.local_coll;
    }

    int aliveCount() {
        int n2 = 0;
        Enumeration enumeration = this.cache.elements();
        while (enumeration.hasMoreElements()) {
            SSRCInfo sSRCInfo = (SSRCInfo)enumeration.nextElement();
            if (!sSRCInfo.alive) continue;
            ++n2;
        }
        return n2;
    }

    double calcReportInterval(boolean bl, boolean bl2) {
        this.rtcp_min_time = 5000;
        double d2 = this.rtcp_bw_fraction;
        if (this.initial) {
            this.rtcp_min_time /= 2;
        }
        int n2 = this.aliveCount();
        if (this.sendercount > 0 && (double)this.sendercount < (double)n2 * this.rtcp_sender_bw_fraction) {
            if (bl) {
                d2 *= this.rtcp_sender_bw_fraction;
                n2 = this.sendercount;
            } else {
                d2 *= 1.0 - this.rtcp_sender_bw_fraction;
                n2 -= this.sendercount;
            }
        }
        if (bl2 && d2 == 0.0) {
            d2 = 0.05;
            if (this.sendercount > 0 && (double)this.sendercount < (double)n2 * 0.25) {
                if (bl) {
                    d2 *= 0.25;
                    n2 = this.sendercount;
                } else {
                    d2 *= 0.75;
                    n2 -= this.sendercount;
                }
            }
        }
        double d3 = 0.0;
        if (d2 != 0.0 && (d3 = (double)(this.avgrtcpsize * n2) / d2) < (double)this.rtcp_min_time) {
            d3 = this.rtcp_min_time;
        }
        if (bl2) {
            return d3;
        }
        return d3 * (Math.random() + 0.5);
    }

    private void changessrc(SSRCInfo sSRCInfo) {
        sSRCInfo.setOurs(true);
        if (this.ourssrc != null) {
            sSRCInfo.sourceInfo = this.sourceInfoCache.get(this.ourssrc.sourceInfo.getCNAME(), sSRCInfo.ours);
            sSRCInfo.sourceInfo.addSSRC(sSRCInfo);
        }
        sSRCInfo.reporter.releasessrc("Local Collision Detected");
        this.ourssrc = sSRCInfo;
        sSRCInfo.reporter.restart = true;
    }

    synchronized void destroy() {
        this.cache.removeAll();
        if (this.eventhandler != null) {
            this.eventhandler.close();
        }
    }

    SSRCInfo get(int n2, InetAddress inetAddress, int n3) {
        SSRCCache sSRCCache = this;
        synchronized (sSRCCache) {
            SSRCInfo sSRCInfo;
            SSRCInfo sSRCInfo2 = sSRCInfo = this.lookup(n2);
            Object var7_7 = null;
            return sSRCInfo2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SSRCInfo get(int n2, InetAddress inetAddress, int n3, int n4) {
        Object object = null;
        boolean bl = false;
        SSRCCache sSRCCache = this;
        synchronized (sSRCCache) {
            Object object2;
            if (this.ourssrc != null && this.ourssrc.ssrc == n2 && this.ourssrc.address != null && !this.ourssrc.address.equals(inetAddress)) {
                bl = true;
                this.LocalCollision(n2);
            }
            if ((object = this.lookup(n2)) != null) {
                SSRCInfo sSRCInfo = object;
                synchronized (sSRCInfo) {
                    if (((SSRCInfo)object).address == null || !((SSRCInfo)object).alive) {
                        ((SSRCInfo)object).address = inetAddress;
                        ((SSRCInfo)object).port = n3;
                    } else if (!((SSRCInfo)object).address.equals(inetAddress)) {
                        if (((SSRCInfo)object).probation > 0) {
                            ((SSRCInfo)object).probation = 2;
                            ((SSRCInfo)object).address = inetAddress;
                            ((SSRCInfo)object).port = n3;
                        } else {
                            this.stats.update(4, 1);
                            ++this.transstats.remote_coll;
                            RemoteCollisionEvent remoteCollisionEvent = new RemoteCollisionEvent(this.sm, ((SSRCInfo)object).ssrc);
                            this.eventhandler.postEvent(remoteCollisionEvent);
                            return null;
                        }
                    }
                }
            }
            if (object != null && n4 == 1 && !(object instanceof RecvSSRCInfo)) {
                if (((SSRCInfo)object).ours) {
                    return null;
                }
                object = object2 = new RecvSSRCInfo((SSRCInfo)object);
                this.cache.put(n2, object);
            }
            if (object != null && n4 == 2 && !(object instanceof PassiveSSRCInfo)) {
                if (((SSRCInfo)object).ours) {
                    return null;
                }
                System.out.println("changing to Passive");
                System.out.println("existing one " + object);
                object2 = new PassiveSSRCInfo((SSRCInfo)object);
                System.out.println("new one is " + object2);
                object = object2;
                this.cache.put(n2, object);
            }
            if (object == null) {
                if (n4 == 3) {
                    if (this.ourssrc != null && this.ourssrc.ssrc == n2) {
                        return this.ourssrc;
                    }
                    object = new SendSSRCInfo(this, n2);
                    ((SSRCInfo)object).initsource((int)TrueRandom.rand());
                }
                if (n4 == 1) {
                    object = new RecvSSRCInfo(this, n2);
                }
                if (n4 == 2) {
                    object = new PassiveSSRCInfo(this, n2);
                }
                if (object == null) {
                    return null;
                }
                ((SSRCInfo)object).address = inetAddress;
                ((SSRCInfo)object).port = n3;
                this.cache.put(n2, object);
            }
            if (((SSRCInfo)object).address == null && ((SSRCInfo)object).port == 0) {
                ((SSRCInfo)object).address = inetAddress;
                ((SSRCInfo)object).port = n3;
            }
            if (!bl) return object;
            object2 = null;
            object2 = object instanceof RecvSSRCInfo ? new LocalCollisionEvent(this.sm, (ReceiveStream)object, this.ourssrc.ssrc) : new LocalCollisionEvent(this.sm, null, this.ourssrc.ssrc);
            this.eventhandler.postEvent((RTPEvent)object2);
            return object;
        }
    }

    SSRCTable getMainCache() {
        return this.cache;
    }

    RTPSourceInfoCache getRTPSICache() {
        return this.sourceInfoCache;
    }

    int getSessionBandwidth() {
        if (this.sessionbandwidth == 0) {
            throw new IllegalArgumentException("Session Bandwidth not set");
        }
        return this.sessionbandwidth;
    }

    SSRCInfo lookup(int n2) {
        return (SSRCInfo)this.cache.get(n2);
    }

    void remove(int n2) {
        SSRCInfo sSRCInfo = (SSRCInfo)this.cache.remove(n2);
        if (sSRCInfo != null) {
            sSRCInfo.delete();
        }
    }

    public void reset(int n2) {
        this.initial = true;
        this.sendercount = 0;
        this.avgrtcpsize = n2;
    }

    void setclockrates() {
        int n2 = 0;
        while (n2 < 16) {
            this.clockrate[n2] = 8000;
            ++n2;
        }
        this.clockrate[6] = 16000;
        this.clockrate[10] = 44100;
        this.clockrate[11] = 44100;
        this.clockrate[14] = 90000;
        this.clockrate[16] = 11025;
        this.clockrate[17] = 22050;
        this.clockrate[18] = 44100;
        int n3 = 24;
        while (n3 < 34) {
            this.clockrate[n3] = 90000;
            ++n3;
        }
        int n4 = 96;
        while (n4 < 128) {
            Format format = this.sm.formatinfo.get(n4);
            this.clockrate[n4] = format != null && format instanceof AudioFormat ? (int)((AudioFormat)format).getSampleRate() : 90000;
            ++n4;
        }
    }

    synchronized void updateavgrtcpsize(int n2) {
        this.avgrtcpsize = (int)(0.0625 * (double)n2 + 0.9375 * (double)this.avgrtcpsize);
    }
}

