/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.sun.media.CircularBuffer;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketSource;
import com.sun.media.rtp.util.UDPPacket;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import javax.media.rtp.RTPPushDataSource;

public class RTPPacketReceiver
implements PacketSource,
SourceTransferHandler {
    RTPPushDataSource rtpsource = null;
    CircularBuffer bufQue = new CircularBuffer(2);
    boolean closed = false;
    boolean dataRead = false;

    public RTPPacketReceiver(PushSourceStream pushSourceStream) {
        pushSourceStream.setTransferHandler(this);
    }

    public RTPPacketReceiver(RTPPushDataSource rTPPushDataSource) {
        this.rtpsource = rTPPushDataSource;
        PushSourceStream pushSourceStream = rTPPushDataSource.getOutputStream();
        pushSourceStream.setTransferHandler(this);
    }

    public void closeSource() {
        CircularBuffer circularBuffer = this.bufQue;
        synchronized (circularBuffer) {
            this.closed = true;
            this.bufQue.notifyAll();
        }
    }

    public Packet receiveFrom() throws IOException {
        Buffer buffer;
        Object object = this.bufQue;
        synchronized (object) {
            if (this.dataRead) {
                this.bufQue.readReport();
                this.bufQue.notify();
            }
            while (!this.bufQue.canRead() && !this.closed) {
                try {
                    this.bufQue.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.closed) {
                buffer = null;
                this.dataRead = false;
            } else {
                buffer = this.bufQue.read();
                this.dataRead = true;
            }
        }
        object = buffer != null ? (Object)((byte[])buffer.getData()) : (Object)new byte[1];
        UDPPacket uDPPacket = new UDPPacket();
        uDPPacket.receiptTime = System.currentTimeMillis();
        uDPPacket.data = (byte[])object;
        uDPPacket.offset = 0;
        uDPPacket.length = buffer == null ? 0 : buffer.getLength();
        return uDPPacket;
    }

    public String sourceString() {
        String string = "RTPPacketReceiver for " + this.rtpsource;
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transferData(PushSourceStream pushSourceStream) {
        Buffer buffer;
        CircularBuffer circularBuffer = this.bufQue;
        synchronized (circularBuffer) {
            while (true) {
                if (this.bufQue.canWrite() || this.closed) {
                    if (!this.closed) break;
                    return;
                }
                try {
                    this.bufQue.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            buffer = this.bufQue.getEmptyBuffer();
        }
        int n2 = pushSourceStream.getMinimumTransferSize();
        byte[] byArray = (byte[])buffer.getData();
        int n3 = 0;
        if (byArray == null || byArray.length < n2) {
            byArray = new byte[n2];
            buffer.setData(byArray);
        }
        try {
            n3 = pushSourceStream.read(byArray, 0, n2);
        }
        catch (IOException iOException) {}
        buffer.setLength(n3);
        buffer.setOffset(0);
        CircularBuffer circularBuffer2 = this.bufQue;
        synchronized (circularBuffer2) {
            this.bufQue.writeReport();
            this.bufQue.notify();
            return;
        }
    }
}

