/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import javax.media.Format;

class FormatTable {
    public Format[] keys;
    public Format[][] table;
    public int[] hits;
    public int last;

    public FormatTable(int n2) {
        this.keys = new Format[n2];
        this.table = new Format[n2][];
        this.hits = new int[n2];
        this.last = 0;
    }

    public int findLeastHit() {
        int n2 = this.hits[0];
        int n3 = 0;
        int n4 = 1;
        while (n4 < this.last) {
            if (this.hits[n4] < n2) {
                n2 = this.hits[n4];
                n3 = n4;
            }
            ++n4;
        }
        return n3;
    }

    Format[] get(Format format) {
        Format[] formatArray = null;
        int n2 = 0;
        while (n2 < this.last) {
            if (formatArray == null && this.keys[n2].matches(format)) {
                formatArray = this.table[n2];
                this.hits[n2] = this.keys.length;
            } else {
                this.hits[n2] = this.hits[n2] - 1;
            }
            ++n2;
        }
        return formatArray;
    }

    public void save(Format format, Format[] formatArray) {
        int n2 = this.last >= this.keys.length ? this.findLeastHit() : this.last++;
        this.keys[n2] = format;
        this.table[n2] = formatArray;
        this.hits[n2] = this.keys.length;
    }
}

