/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;

public class ProcessorModel {
    private Format[] formats = null;
    private MediaLocator inputLocator = null;
    private DataSource inputDataSource = null;
    private ContentDescriptor outputContentDescriptor = null;

    public ProcessorModel() {
    }

    public ProcessorModel(MediaLocator mediaLocator, Format[] formatArray, ContentDescriptor contentDescriptor) {
        this.inputLocator = mediaLocator;
        this.formats = formatArray;
        this.outputContentDescriptor = contentDescriptor;
    }

    public ProcessorModel(DataSource dataSource, Format[] formatArray, ContentDescriptor contentDescriptor) {
        this.inputDataSource = dataSource;
        this.formats = formatArray;
        this.outputContentDescriptor = contentDescriptor;
    }

    public ProcessorModel(Format[] formatArray, ContentDescriptor contentDescriptor) {
        this.outputContentDescriptor = contentDescriptor;
        this.formats = formatArray;
    }

    public ContentDescriptor getContentDescriptor() {
        return this.outputContentDescriptor;
    }

    public DataSource getInputDataSource() {
        return this.inputDataSource;
    }

    public MediaLocator getInputLocator() {
        return this.inputLocator;
    }

    public Format getOutputTrackFormat(int n2) {
        if (this.formats != null && this.formats.length > n2) {
            return this.formats[n2];
        }
        return null;
    }

    public int getTrackCount(int n2) {
        if (this.formats != null) {
            return this.formats.length;
        }
        return -1;
    }

    public boolean isFormatAcceptable(int n2, Format format) {
        if (this.formats != null && this.formats.length > n2) {
            return format.matches(this.formats[n2]);
        }
        return true;
    }
}

