/*
 * Decompiled with CFR 0.152.
 */
package javax.media.bean.playerbean;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerAdapter;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerListener;
import javax.media.Duration;
import javax.media.EndOfMediaEvent;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.TransitionEvent;
import javax.media.bean.playerbean.MediaPlayerResource;
import javax.media.format.FormatChangeEvent;
import javax.media.protocol.DataSource;

public class MediaPlayer
extends Container
implements Player,
Externalizable {
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private String urlString = "";
    private MediaLocator mrl;
    private URL url;
    private AppletContext mpAppletContext = null;
    private boolean panelVisible = true;
    private boolean cachingVisible = false;
    private boolean fixedAspectRatio = true;
    private boolean fitVideo = true;
    private boolean looping = true;
    transient Player player = null;
    transient Panel panel;
    transient Panel vPanel;
    transient Panel newPanel;
    transient Component visualComponent;
    transient Component controlComponent;
    transient Component cachingComponent;
    private transient int controlPanelHeight = 0;
    private transient int urlFieldHeight = 0;
    private int preferredHeight;
    private int preferredWidth;
    private int state;
    private Vector controlListeners = new Vector();
    PopupMenu zoomMenu = null;
    private URL mpCodeBase = null;
    protected transient GainControl gainControl;
    protected transient String curVolumeLevel = MediaPlayerResource.getString("THREE");
    protected transient float curVolumeValue = 0.6f;
    protected transient String curZoomLevel = MediaPlayerResource.getString("SCALE_NORMAL");
    protected transient float curZoomValue = 1.0f;
    protected transient Time mediaTime;
    private InternalControllerAdapter selfListener;
    private long contentLength = 0L;
    private boolean fixtedFirstTime = true;
    private boolean displayURL = false;
    private boolean isPopupActive = true;
    private transient TextField urlName;
    private transient visualMouseAdapter mouseListen;
    Method errMeth = null;

    public MediaPlayer() {
        this.setLayout(null);
        if (this.panel == null) {
            this.panel = new Panel();
            this.panel.setLayout(new BorderLayout());
            this.panel.setVisible(false);
            this.add("Center", this.panel);
        }
    }

    private void Fatal(String string) {
        try {
            Object[] objectArray;
            if (this.errMeth == null) {
                objectArray = Class.forName("com.sun.media.Log");
                Class[] classArray = new Class[]{Class.forName("java.lang.Object")};
                this.errMeth = objectArray.getMethod("error", classArray);
            }
            objectArray = new Object[]{string};
            this.errMeth.invoke(null, objectArray);
        }
        catch (Throwable throwable) {
            System.err.println(string);
        }
    }

    static /* synthetic */ int access$12(MediaPlayer mediaPlayer) {
        return mediaPlayer.preferredHeight;
    }

    static /* synthetic */ int access$14(MediaPlayer mediaPlayer) {
        return mediaPlayer.preferredWidth;
    }

    static /* synthetic */ int access$3(MediaPlayer mediaPlayer) {
        return mediaPlayer.state;
    }

    public void addController(Controller controller) {
        try {
            if (this.player != null) {
                this.player.addController(controller);
            }
        }
        catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
            this.Fatal(MediaPlayerResource.getString("PLAYER_NO_COMPATIBLE_TIME_BASE"));
            return;
        }
    }

    public void addControllerListener(ControllerListener controllerListener) {
        if (this.player != null) {
            this.player.addControllerListener(controllerListener);
        }
        if (!this.controlListeners.contains(controllerListener)) {
            this.controlListeners.addElement(controllerListener);
        }
    }

    private void addPopupMenu(Component component) {
        this.zoomMenu = new PopupMenu("Zoom");
        popupActionListener popupActionListener2 = new popupActionListener();
        component.add(this.zoomMenu);
        MenuItem menuItem = new MenuItem("Scale 1:2");
        this.zoomMenu.add(menuItem);
        menuItem.addActionListener(popupActionListener2);
        menuItem = new MenuItem("Scale 1:1");
        this.zoomMenu.add(menuItem);
        menuItem.addActionListener(popupActionListener2);
        menuItem = new MenuItem("Scale 2:1");
        this.zoomMenu.add(menuItem);
        menuItem.addActionListener(popupActionListener2);
        menuItem = new MenuItem("Scale 4:1");
        this.zoomMenu.add(menuItem);
        menuItem.addActionListener(popupActionListener2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    private float aspectRatio(float f2, float f3, int n2) {
        return f2 / (f3 - (float)n2);
    }

    private void calculateSize() {
        if (this.player == null) {
            return;
        }
        this.debug("claculateSize");
        this.visualComponent = this.player.getVisualComponent();
        if (this.visualComponent != null) {
            this.preferredHeight = this.visualComponent.getPreferredSize().height;
            this.preferredWidth = this.visualComponent.getPreferredSize().width;
        }
        if ((this.controlComponent = this.player.getControlPanelComponent()) != null && this.isControlPanelVisible() || this.displayURL) {
            if (this.controlComponent != null && this.isControlPanelVisible()) {
                this.controlPanelHeight = this.controlComponent.getPreferredSize().height;
                this.preferredHeight += this.controlPanelHeight;
                if (this.preferredWidth == 0) {
                    this.preferredWidth = 320;
                }
            }
            if (this.displayURL) {
                this.urlFieldHeight = this.urlName.getPreferredSize().height;
                this.preferredHeight += this.urlFieldHeight;
            }
        }
        if (this.visualComponent != null) {
            Dimension dimension = this.visualComponent.getPreferredSize();
            int n2 = 0;
            if (this.controlComponent != null) {
                n2 += this.controlComponent.getPreferredSize().height;
            }
            if (this.displayURL) {
                n2 += this.urlName.getPreferredSize().height;
            }
            if (this.fixedAspectRatio && (double)this.curZoomValue == 1.0) {
                if (dimension.width != 0 && dimension.height != 0) {
                    this.curZoomValue = (float)this.getSize().width / (float)dimension.width >= (float)(this.getSize().height - n2) / (float)dimension.height ? (float)(this.getSize().height - n2) / (float)dimension.height : (float)this.getSize().width / (float)dimension.width;
                }
                if ((double)this.curZoomValue < 0.5) {
                    this.curZoomValue = 1.0f;
                }
            }
            if (this.newPanel != null) {
                this.newPanel.setSize(this.visualComponent.getPreferredSize().width, this.controlPanelHeight + this.urlFieldHeight);
            }
        }
    }

    private void center(Container container, Panel panel, boolean bl, int n2) {
        int n3 = container.getSize().width;
        int n4 = container.getSize().height;
        int n5 = panel.getSize().width;
        int n6 = panel.getSize().height;
        if (bl) {
            float f2 = this.aspectRatio(n5, n6, n2);
            if (n5 > n3) {
                n6 = (int)((float)n3 / f2) + n2;
                if (n6 > n4) {
                    n5 = (int)(f2 * (float)(n4 - n2));
                    n6 = n4;
                } else {
                    n5 = n3;
                }
                panel.setBounds(container.getBounds().x, container.getBounds().y, n5, n6);
            } else if (n6 > n4) {
                n5 = (int)(f2 * (float)(n4 - n2));
                n6 = n4;
                panel.setBounds(container.getBounds().x, container.getBounds().y, n5, n6);
            }
        }
        panel.setLocation(n3 / 2 - n5 / 2, n4 / 2 - n6 / 2);
        panel.setSize(n5, n6);
    }

    public void close() {
        if (this.player == null) {
            return;
        }
        this.panel.removeAll();
        this.player.close();
        this.player = null;
    }

    public void deallocate() {
        if (this.player == null) {
            return;
        }
        this.debug("in deallocate");
        this.player.deallocate();
    }

    private void debug(String string) {
    }

    private synchronized void doRealize() {
        this.debug("in doRealize");
        if (this.player == null) {
            this.Fatal(MediaPlayerResource.getString("SHOULD NOT OCCUR"));
            System.exit(-1);
        }
        this.gainControl = this.player.getGainControl();
        if (this.gainControl != null) {
            float f2 = this.gainControl.setLevel(this.curVolumeValue);
        }
        if ((this.visualComponent = this.player.getVisualComponent()) != null) {
            this.vPanel = new Panel();
            this.vPanel.setLayout(new BorderLayout());
            this.panel.setVisible(false);
            this.visualComponent.setVisible(false);
            this.vPanel.add("Center", this.visualComponent);
            this.panel.add("Center", this.vPanel);
            this.addComponentListener(new visualComponentAdapter(this));
            this.addPopupMenu(this.visualComponent);
            this.setPopupActive();
        }
        this.newPanel = new Panel();
        this.newPanel.setLayout(new BorderLayout());
        this.panel.add("South", this.newPanel);
        this.urlName = new TextField(10);
        this.urlName.setEditable(false);
        if (this.displayURL) {
            this.urlName.setText(this.urlString);
            this.newPanel.add("South", this.urlName);
        }
        if ((this.controlComponent = this.player.getControlPanelComponent()) != null && this.isControlPanelVisible()) {
            this.controlComponent.setVisible(false);
            this.newPanel.add("North", this.controlComponent);
        }
        this.calculateSize();
        if (this.visualComponent == null) {
            if (this.controlComponent != null) {
                this.panel.setSize(this.controlComponent.getPreferredSize().width, this.controlPanelHeight + this.urlFieldHeight);
            } else {
                this.panel.setSize(100, this.urlFieldHeight);
            }
        }
        this.showVisual();
    }

    public Control getControl(String string) {
        if (this.player != null) {
            return this.player.getControl(string);
        }
        return null;
    }

    public Component getControlPanelComponent() {
        if (this.player != null) {
            return this.player.getControlPanelComponent();
        }
        return null;
    }

    public int getControlPanelHeight() {
        if (this.isControlPanelVisible()) {
            return this.controlPanelHeight;
        }
        return 0;
    }

    public Control[] getControls() {
        if (this.player != null) {
            return this.player.getControls();
        }
        return new Control[0];
    }

    public Time getDuration() {
        if (this.player != null) {
            return this.player.getDuration();
        }
        return Duration.DURATION_UNKNOWN;
    }

    public GainControl getGainControl() {
        if (this.player != null) {
            return this.player.getGainControl();
        }
        return null;
    }

    public String getMediaLocation() {
        if (this.mrl != null) {
            return this.mrl.toString();
        }
        return this.urlString;
    }

    public int getMediaLocationHeight() {
        if (this.isMediaLocationVisible()) {
            return this.urlFieldHeight;
        }
        return 0;
    }

    protected MediaLocator getMediaLocator(String string) {
        MediaLocator mediaLocator = null;
        if (string.regionMatches(true, 0, "<codebase>", 0, 10)) {
            try {
                if (this.mpCodeBase == null) {
                    this.initSetCodeBase();
                }
                mediaLocator = new MediaLocator(new URL(this.mpCodeBase, string.substring(11)));
            }
            catch (MalformedURLException malformedURLException) {
                if (this.mpCodeBase != null) {
                    this.log(String.valueOf(MediaPlayerResource.getString("NO IMAGE:BAD_URL")) + string + " " + this.mpCodeBase);
                    this.urlString = " ";
                }
                return null;
            }
        } else {
            mediaLocator = new MediaLocator(string);
        }
        return mediaLocator;
    }

    public long getMediaNanoseconds() {
        if (this.player != null) {
            return this.player.getMediaNanoseconds();
        }
        return Long.MAX_VALUE;
    }

    public Time getMediaTime() {
        if (this.player != null) {
            return this.player.getMediaTime();
        }
        return Controller.LATENCY_UNKNOWN;
    }

    public boolean getPlaybackLoop() {
        return this.looping;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredWidth, this.preferredHeight);
    }

    public float getRate() {
        if (this.player != null) {
            return this.player.getRate();
        }
        return 0.0f;
    }

    public Time getStartLatency() {
        if (this.player != null) {
            return this.player.getStartLatency();
        }
        return Controller.LATENCY_UNKNOWN;
    }

    public int getState() {
        if (this.player != null) {
            return this.player.getState();
        }
        return 100;
    }

    public Time getStopTime() {
        if (this.player != null) {
            return this.player.getStopTime();
        }
        return null;
    }

    public Time getSyncTime() {
        if (this.player != null) {
            return this.player.getSyncTime();
        }
        return Controller.LATENCY_UNKNOWN;
    }

    public int getTargetState() {
        if (this.player != null) {
            return this.player.getTargetState();
        }
        return 100;
    }

    public TimeBase getTimeBase() {
        if (this.player != null) {
            return this.player.getTimeBase();
        }
        return null;
    }

    public Component getVisualComponent() {
        if (this.player != null) {
            return this.player.getVisualComponent();
        }
        return null;
    }

    public String getVolumeLevel() {
        return this.curVolumeLevel;
    }

    public String getZoomTo() {
        return this.curZoomLevel;
    }

    private void initSetCodeBase() {
        if (this.mpCodeBase != null) {
            return;
        }
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Applet) break;
            container = container.getParent();
        }
        if (container != null) {
            this.setCodeBase(((Applet)container).getCodeBase());
            this.mpAppletContext = ((Applet)container).getAppletContext();
        }
    }

    public boolean isCachingControlVisible() {
        return this.cachingVisible;
    }

    public boolean isControlPanelVisible() {
        return this.panelVisible;
    }

    public boolean isFixedAspectRatio() {
        return this.fixedAspectRatio;
    }

    public boolean isMediaLocationVisible() {
        return this.displayURL;
    }

    public boolean isPlayBackLoop() {
        return this.looping;
    }

    private void log(String string) {
        try {
            Object[] objectArray;
            if (this.errMeth == null) {
                objectArray = Class.forName("com.sun.media.Log");
                Class[] classArray = new Class[]{Class.forName("java.lang.Object")};
                this.errMeth = objectArray.getMethod("comment", classArray);
            }
            objectArray = new Object[]{string};
            this.errMeth.invoke(null, objectArray);
        }
        catch (Throwable throwable) {
            System.err.println(string);
        }
    }

    public Time mapToTimeBase(Time time) {
        try {
            if (this.player != null) {
                return this.player.mapToTimeBase(time);
            }
        }
        catch (ClockStoppedException clockStoppedException) {
            this.log(MediaPlayerResource.getString("CALL_A_STOPPED_CLOCK"));
        }
        return Controller.LATENCY_UNKNOWN;
    }

    public void prefetch() {
        if (this.player == null) {
            return;
        }
        this.player.prefetch();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setBounds((Rectangle)objectInput.readObject());
        this.setBackground((Color)objectInput.readObject());
        this.setForeground((Color)objectInput.readObject());
        this.setFont((Font)objectInput.readObject());
        this.setVisible(objectInput.readBoolean());
        this.setEnabled(objectInput.readBoolean());
        String string = (String)objectInput.readObject();
        if (string != null) {
            this.mrl = new MediaLocator(string);
        }
        if (this.mrl != null) {
            try {
                this.setMediaLocator(this.mrl);
            }
            catch (Exception exception) {}
        }
        this.setMediaLocationVisible(objectInput.readBoolean());
        this.panelVisible = objectInput.readBoolean();
        this.cachingVisible = objectInput.readBoolean();
        this.fixedAspectRatio = objectInput.readBoolean();
        this.preferredHeight = objectInput.readInt();
        this.preferredWidth = objectInput.readInt();
        if (objectInput.readBoolean()) {
            int n2 = objectInput.readInt();
            int n3 = objectInput.readInt();
            this.state = 100;
            if (n2 >= 300) {
                long l2 = objectInput.readLong();
                long l3 = objectInput.readLong();
                float f2 = objectInput.readFloat();
                if (n3 >= 500) {
                    this.player.prefetch();
                    this.waitForState(500);
                } else if (n3 >= 300) {
                    this.player.realize();
                    this.waitForState(300);
                }
                this.player.setMediaTime(new Time(l2));
                this.player.setStopTime(new Time(l3));
                this.player.setRate(f2);
                float f3 = objectInput.readFloat();
                if (f3 != -1.0f) {
                    GainControl gainControl = this.player.getGainControl();
                    if (gainControl != null) {
                        boolean bl = objectInput.readBoolean();
                        gainControl.setLevel(f3);
                        gainControl.setMute(bl);
                    } else {
                        objectInput.readBoolean();
                    }
                }
                if (n3 >= 600) {
                    this.player.start();
                }
            }
        }
        this.invalidate();
        this.validate();
    }

    public void realize() {
        if (this.player == null) {
            return;
        }
        this.player.realize();
    }

    public void removeController(Controller controller) {
        if (this.player != null) {
            this.player.removeController(controller);
        }
    }

    public void removeControllerListener(ControllerListener controllerListener) {
        if (this.player != null) {
            this.player.removeControllerListener(controllerListener);
        }
        if (this.controlListeners.contains(controllerListener)) {
            this.controlListeners.removeElement(controllerListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void restoreMediaTime() {
        this.setMediaTime(this.mediaTime);
    }

    public void saveMediaTime() {
        this.mediaTime = this.getMediaTime();
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        this.debug("setBounds " + n2 + " " + n3 + " " + n4 + " " + n5 + " ");
        super.setBounds(n2, n3, n4, n5);
        Dimension dimension = this.getSize();
        int n6 = dimension.height;
        int n7 = dimension.width;
        boolean bl = false;
        int n8 = 0;
        if (this.urlName != null && this.isMediaLocationVisible()) {
            n8 = this.urlFieldHeight = this.urlName.getPreferredSize().height;
            if (n6 < 5 && this.displayURL) {
                n6 = 5;
            }
        }
        if (this.controlComponent != null && this.isControlPanelVisible()) {
            this.controlPanelHeight = this.controlComponent.getPreferredSize().height;
            n8 += this.controlPanelHeight;
            if (dimension.width < 160) {
                dimension.width = 160;
            }
            if (n6 < 2 && this.visualComponent != null) {
                n6 += 2;
            }
        }
        if (this.visualComponent != null) {
            Dimension dimension2 = this.visualComponent.getPreferredSize();
            if (this.fixedAspectRatio) {
                this.curZoomValue = (float)n7 / (float)dimension2.width >= (float)(n6 - n8) / (float)(dimension2.height - n8) ? (float)(n6 - n8) / (float)(dimension2.height - n8) : (float)n7 / (float)dimension2.width;
                if ((double)this.curZoomValue < 1.0) {
                    this.curZoomValue = 1.0f;
                }
                this.zoomTo(this.curZoomValue);
            } else {
                this.panel.setBounds(this.getBounds());
            }
        } else {
            this.panel.setSize(this.getSize());
            this.validate();
        }
    }

    public void setCachingControlVisible(boolean bl) {
        if (this.cachingVisible != bl) {
            boolean bl2 = this.cachingVisible;
            if (this.cachingComponent != null) {
                if (bl) {
                    this.panel.add("South", this.cachingComponent);
                } else {
                    this.panel.remove(this.cachingComponent);
                }
            }
            this.invalidate();
            this.validate();
            this.changes.firePropertyChange("cachingControlVisible", new Boolean(bl2), new Boolean(this.cachingVisible));
        }
        this.cachingVisible = bl;
    }

    public void setCodeBase(URL uRL) {
        this.mpCodeBase = uRL;
    }

    public void setControlPanelVisible(boolean bl) {
        if (this.panelVisible != bl) {
            boolean bl2 = this.panelVisible;
            if (this.controlComponent != null) {
                if (bl) {
                    this.panel.add("South", this.controlComponent);
                } else {
                    this.panel.remove(this.controlComponent);
                }
            }
            this.invalidate();
            this.validate();
            this.panelVisible = bl;
            this.changes.firePropertyChange("controlPanelVisible", new Boolean(bl2), new Boolean(this.panelVisible));
        }
    }

    public void setDataSource(DataSource dataSource) {
        try {
            this.debug("setDataSource");
            if (dataSource != null) {
                if (this.panel != null) {
                    this.panel.removeAll();
                }
                if (this.player != null) {
                    this.player.stop();
                    if (this.controlListeners.contains(this.selfListener)) {
                        this.controlListeners.removeElement(this.selfListener);
                    }
                }
            }
            if (this.urlName != null) {
                if (dataSource.getLocator() != null) {
                    this.urlName.setText(dataSource.getLocator().toExternalForm());
                } else {
                    this.urlName.setText("");
                }
                this.urlName.setFont(this.getFont());
            }
            try {
                this.player = Manager.createPlayer(dataSource);
            }
            catch (Exception exception) {
                this.player = null;
                this.urlString = " ";
                this.Fatal(String.valueOf(MediaPlayerResource.getString("UNABLE_CREATE_PLAYER")) + exception);
                return;
            }
            if (this.player == null) {
                return;
            }
            this.urlString = dataSource.getLocator() != null ? dataSource.getLocator().toExternalForm() : "";
            this.selfListener = new InternalControllerAdapter(this);
            this.player.addControllerListener(this.selfListener);
            if (!this.controlListeners.isEmpty()) {
                int n2 = 0;
                while (n2 < this.controlListeners.size()) {
                    this.player.addControllerListener((ControllerListener)this.controlListeners.elementAt(n2));
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            this.mrl = null;
            exception.printStackTrace();
            this.Fatal(String.valueOf(MediaPlayerResource.getString("UNABLE_CREATE_PLAYER")) + exception);
            return;
        }
    }

    public void setFixedAspectRatio(boolean bl) {
        boolean bl2 = this.fixedAspectRatio;
        this.fixedAspectRatio = bl;
        this.changes.firePropertyChange("fixedAspectRatio", new Boolean(bl2), new Boolean(this.fixedAspectRatio));
    }

    public void setMediaLocation(String string) {
        try {
            String string2 = "";
            if (this.mrl != null) {
                string2 = this.mrl.toExternalForm();
                if (this.panel != null) {
                    this.panel.removeAll();
                }
                if (this.player != null) {
                    this.player.stop();
                    this.player.close();
                    this.panel.validate();
                    if (this.controlListeners.contains(this.selfListener)) {
                        this.controlListeners.removeElement(this.selfListener);
                    }
                }
            }
            this.urlString = string;
            this.mrl = this.getMediaLocator(string);
            if (this.mrl == null) {
                return;
            }
            try {
                this.player = Manager.createPlayer(this.mrl);
            }
            catch (Exception exception) {
                this.player = null;
                this.urlString = " ";
                this.changes.firePropertyChange("mediaLocation", string, string2);
                this.Fatal(String.valueOf(MediaPlayerResource.getString("UNABLE_CREATE_PLAYER")) + exception);
                return;
            }
            if (this.player == null) {
                return;
            }
            if (this.urlName != null) {
                this.urlName.setText(this.urlString);
                this.urlName.setFont(this.getFont());
            }
            this.selfListener = new InternalControllerAdapter(this);
            this.player.addControllerListener(this.selfListener);
            if (!this.controlListeners.isEmpty()) {
                int n2 = 0;
                while (n2 < this.controlListeners.size()) {
                    this.player.addControllerListener((ControllerListener)this.controlListeners.elementAt(n2));
                    ++n2;
                }
            }
            this.changes.firePropertyChange("mediaLocation", string2, string);
        }
        catch (Exception exception) {
            this.mrl = null;
            exception.printStackTrace();
            this.Fatal(String.valueOf(MediaPlayerResource.getString("UNABLE_CREATE_PLAYER")) + exception);
            return;
        }
    }

    public void setMediaLocationVisible(boolean bl) {
        if (this.displayURL != bl) {
            if (this.urlName != null) {
                if (bl) {
                    this.urlName.setText(this.urlString);
                    this.newPanel.add("South", this.urlName);
                } else {
                    this.newPanel.remove(this.urlName);
                }
            }
            this.panel.validate();
            this.validate();
            this.displayURL = bl;
        }
    }

    public void setMediaLocator(MediaLocator mediaLocator) {
        try {
            this.debug("setMediaLocator");
            if (mediaLocator != null) {
                if (this.mrl != null) {
                    if (this.panel != null) {
                        this.panel.removeAll();
                    }
                    if (this.player != null) {
                        this.player.stop();
                        this.player.close();
                        if (this.controlListeners.contains(this.selfListener)) {
                            this.controlListeners.removeElement(this.selfListener);
                        }
                    }
                }
            } else {
                return;
            }
            try {
                this.player = Manager.createPlayer(mediaLocator);
            }
            catch (NoPlayerException noPlayerException) {
                this.player = null;
                this.urlString = " ";
                this.Fatal(String.valueOf(MediaPlayerResource.getString("UNABLE_CREATE_PLAYER")) + noPlayerException);
                return;
            }
            catch (IOException iOException) {
                this.player = null;
                this.urlString = " ";
                this.Fatal(String.valueOf(MediaPlayerResource.getString("IO_EXCEPTION")) + iOException);
                return;
            }
            if (this.player == null) {
                return;
            }
            this.urlString = mediaLocator.toExternalForm();
            this.mrl = mediaLocator;
            if (this.urlName != null) {
                this.urlName.setText(this.urlString);
                this.urlName.setFont(this.getFont());
            }
            this.selfListener = new InternalControllerAdapter(this);
            this.player.addControllerListener(this.selfListener);
            if (!this.controlListeners.isEmpty()) {
                int n2 = 0;
                while (n2 < this.controlListeners.size()) {
                    this.player.addControllerListener((ControllerListener)this.controlListeners.elementAt(n2));
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            this.url = null;
            exception.printStackTrace();
            this.Fatal(String.valueOf(MediaPlayerResource.getString("UNABLE_CREATE_PLAYER")) + exception);
            return;
        }
    }

    public void setMediaTime(Time time) {
        if (this.player != null) {
            this.player.setMediaTime(time);
        }
    }

    public void setPlaybackLoop(boolean bl) {
        boolean bl2 = this.looping;
        this.looping = bl;
        this.changes.firePropertyChange("playbackLoop", new Boolean(bl2), new Boolean(this.looping));
    }

    public void setPlayer(Player player) {
        this.debug("setPlayer");
        if (player == null) {
            return;
        }
        if (player != null) {
            if (this.panel != null) {
                this.panel.removeAll();
            }
            if (this.player != null) {
                this.player.stop();
                if (this.controlListeners.contains(this.selfListener)) {
                    this.controlListeners.removeElement(this.selfListener);
                }
            }
        }
        this.player = player;
        this.urlString = "";
        this.selfListener = new InternalControllerAdapter(this);
        this.player.addControllerListener(this.selfListener);
        switch (this.player.getState()) {
            case 500: {
                this.debug("player state prefetched ");
                break;
            }
            case 400: {
                this.debug("player state prefetching ");
                break;
            }
            case 300: {
                this.debug("player state Realized ");
                break;
            }
            case 200: {
                this.debug("player state  Realizing");
                break;
            }
            case 600: {
                this.debug("player state started ");
                break;
            }
            case 100: {
                this.debug("player state Unrealized ");
                break;
            }
        }
        if (this.player.getState() == 300 || this.player.getState() == 400) {
            this.doRealize();
        }
        if (this.player.getState() == 500 || this.player.getState() == 600) {
            this.doRealize();
        }
        if (!this.controlListeners.isEmpty()) {
            int n2 = 0;
            while (n2 < this.controlListeners.size()) {
                this.player.addControllerListener((ControllerListener)this.controlListeners.elementAt(n2));
                ++n2;
            }
        }
    }

    private void setPopupActive() {
        if (this.isPopupActive) {
            this.mouseListen = new visualMouseAdapter();
            this.visualComponent.addMouseListener(this.mouseListen);
        } else if (this.mouseListen != null) {
            this.visualComponent.removeMouseListener(this.mouseListen);
        }
    }

    public void setPopupActive(boolean bl) {
        if (bl != this.isPopupActive) {
            this.isPopupActive = bl;
            this.setPopupActive();
        }
    }

    public float setRate(float f2) {
        if (this.player != null) {
            return this.player.setRate(f2);
        }
        return 0.0f;
    }

    public void setSource(DataSource dataSource) {
        try {
            if (this.player != null) {
                this.player.setSource(dataSource);
            }
        }
        catch (IOException iOException) {
            this.Fatal(String.valueOf(MediaPlayerResource.getString("IO_EXCEPTION")) + iOException);
            return;
        }
        catch (IncompatibleSourceException incompatibleSourceException) {
            this.Fatal(String.valueOf(MediaPlayerResource.getString("INCOMPATIBLE_SOURCE_EXCEPTION")) + incompatibleSourceException);
            return;
        }
    }

    public void setStopTime(Time time) {
        if (this.player != null) {
            this.player.setStopTime(time);
        }
    }

    public void setTimeBase(TimeBase timeBase) {
        try {
            if (this.player != null) {
                this.player.setTimeBase(timeBase);
            }
        }
        catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
            this.Fatal(String.valueOf(MediaPlayerResource.getString("INCOMPATIBLE_TIME_BASE")) + incompatibleTimeBaseException);
            return;
        }
    }

    public void setVolumeLevel(String string) {
        this.debug("in setVolumeLevel");
        if (string == null) {
            return;
        }
        String string2 = this.curVolumeLevel;
        int n2 = Integer.parseInt(string);
        this.curVolumeLevel = string;
        this.curVolumeValue = (float)n2 * 0.2f;
        if (this.gainControl != null) {
            this.gainControl.setLevel(this.curVolumeValue);
        }
        this.changes.firePropertyChange("volumeLevel", string2, this.curVolumeLevel);
    }

    public void setZoomTo(String string) {
        this.debug("setZoomTo");
        this.curZoomLevel = string;
        if (string.trim().equals(MediaPlayerResource.getString("1:2"))) {
            this.curZoomValue = 0.5f;
        } else if (string.trim().equals(MediaPlayerResource.getString("1:1"))) {
            this.curZoomValue = 1.0f;
        } else if (string.trim().equals(MediaPlayerResource.getString("2:1"))) {
            this.curZoomValue = 2.0f;
        } else if (string.trim().equals(MediaPlayerResource.getString("4:1"))) {
            this.curZoomValue = 4.0f;
        }
        this.fixtedFirstTime = false;
        this.zoomTo(this.curZoomValue);
    }

    private synchronized void showVisual() {
        if (this.cachingComponent != null) {
            this.panel.remove(this.cachingComponent);
            this.validate();
        }
        if (this.visualComponent != null && (this.fixedAspectRatio || !this.fixtedFirstTime)) {
            this.zoomTo(this.curZoomValue);
        } else {
            this.panel.setSize(this.getSize());
        }
        this.panel.setVisible(true);
        if (this.visualComponent != null) {
            this.visualComponent.setVisible(true);
        }
        if (this.controlComponent != null && this.isControlPanelVisible()) {
            this.controlComponent.setVisible(true);
        }
        this.panel.validate();
        this.validate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        if (this.player != null) {
            this.player.start();
            return;
        } else {
            if (this.mrl == null) {
                this.initSetCodeBase();
                this.mrl = this.getMediaLocator(this.urlString);
            }
            if (this.mrl != null) {
                try {
                    this.player = Manager.createPlayer(this.mrl);
                    this.selfListener = new InternalControllerAdapter(this);
                    this.player.addControllerListener(this.selfListener);
                    this.start();
                    if (this.controlListeners.size() <= 0) return;
                    int n2 = 0;
                    while (n2 < this.controlListeners.size()) {
                        this.player.addControllerListener((ControllerListener)this.controlListeners.elementAt(n2));
                        ++n2;
                    }
                    return;
                }
                catch (Exception exception) {
                    this.player = null;
                    this.urlString = " ";
                    this.Fatal(String.valueOf(MediaPlayerResource.getString("UNABLE_CREATE_PLAYER")) + exception);
                    return;
                }
            } else {
                this.Fatal(MediaPlayerResource.getString("COULD_NOT_START_PLAYER"));
            }
        }
    }

    public void stop() {
        if (this.player != null) {
            this.player.stop();
        }
    }

    public void stopAndDeallocate() {
        if (this.player != null) {
            this.player.stop();
        }
    }

    public void syncStart(Time time) {
        this.debug("syncStart ");
        if (this.player != null) {
            this.player.syncStart(time);
        }
    }

    public synchronized void waitForState(int n2) {
        while (this.state != n2) {
            try {
                this.wait(1000L);
            }
            catch (Exception exception) {}
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getBounds());
        objectOutput.writeObject(this.getBackground());
        objectOutput.writeObject(this.getForeground());
        objectOutput.writeObject(this.getFont());
        objectOutput.writeBoolean(this.isVisible());
        objectOutput.writeBoolean(this.isEnabled());
        if (this.mrl != null) {
            objectOutput.writeObject(this.mrl.toExternalForm());
        } else {
            objectOutput.writeObject(null);
        }
        objectOutput.writeBoolean(this.displayURL);
        objectOutput.writeBoolean(this.panelVisible);
        objectOutput.writeBoolean(this.cachingVisible);
        objectOutput.writeBoolean(this.fixedAspectRatio);
        objectOutput.writeInt(this.preferredHeight);
        objectOutput.writeInt(this.preferredWidth);
        if (this.player == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeInt(this.player.getState());
            objectOutput.writeInt(this.player.getTargetState());
            if (this.player.getState() >= 300) {
                objectOutput.writeLong(this.player.getMediaNanoseconds());
                objectOutput.writeLong(this.player.getStopTime().getNanoseconds());
                objectOutput.writeFloat(this.player.getRate());
                GainControl gainControl = this.player.getGainControl();
                if (gainControl != null) {
                    objectOutput.writeFloat(gainControl.getLevel());
                    objectOutput.writeBoolean(gainControl.getMute());
                } else {
                    objectOutput.writeFloat(-1.0f);
                }
            }
        }
    }

    private void zoomTo(float f2) {
        block7: {
            this.debug("zoomTo " + f2);
            int n2 = 0;
            int n3 = 0;
            if (this.visualComponent == null || !this.fitVideo) break block7;
            try {
                Dimension dimension = this.visualComponent.getPreferredSize();
                n2 = (int)((float)dimension.width * f2);
                n3 = (int)((float)dimension.height * f2);
                int n4 = 0;
                if (this.controlComponent != null && this.isControlPanelVisible()) {
                    n4 = this.controlComponent.getPreferredSize().height;
                }
                if (this.displayURL) {
                    n4 += this.urlName.getPreferredSize().height;
                }
                if (this.newPanel != null) {
                    this.newPanel.setSize(n2, n4);
                }
                this.panel.setSize(n2, n3 + n4);
                if (this.fixedAspectRatio || !this.fixedAspectRatio && !this.fixtedFirstTime) {
                    this.center(this, this.panel, true, n4);
                } else {
                    this.center(this, this.panel, false, n4);
                }
                this.panel.validate();
            }
            catch (Exception exception) {
                this.log(String.valueOf(MediaPlayerResource.getString("UNABLE_TO_ZOOM")) + exception);
            }
        }
    }

    class InternalControllerAdapter
    extends ControllerAdapter {
        private MediaPlayer thisBean;

        public InternalControllerAdapter(MediaPlayer mediaPlayer2) {
            this.thisBean = mediaPlayer2;
        }

        public void cachingControl(CachingControlEvent cachingControlEvent) {
            MediaPlayer.this.debug("  Event:  CachingControl");
            if (MediaPlayer.this.isCachingControlVisible()) {
                CachingControl cachingControl = cachingControlEvent.getCachingControl();
                long l2 = cachingControl.getContentLength();
                if (cachingControl != null && MediaPlayer.this.cachingComponent == null && l2 != Long.MAX_VALUE) {
                    MediaPlayer.this.cachingComponent = cachingControl.getControlComponent();
                    if (MediaPlayer.this.cachingComponent == null) {
                        MediaPlayer.this.cachingComponent = cachingControl.getProgressBarComponent();
                    }
                    if (MediaPlayer.this.cachingComponent != null) {
                        MediaPlayer.this.panel.add("South", MediaPlayer.this.cachingComponent);
                        Dimension dimension = MediaPlayer.this.cachingComponent.getPreferredSize();
                        MediaPlayer.this.cachingComponent.setBounds(0, 0, dimension.width, dimension.height);
                        MediaPlayer.this.panel.setSize(dimension.width, dimension.height);
                        MediaPlayer.this.panel.validate();
                    }
                } else if (cachingControl.getContentProgress() == l2 && MediaPlayer.this.cachingComponent != null) {
                    MediaPlayer.this.panel.remove(MediaPlayer.this.cachingComponent);
                    MediaPlayer.this.validate();
                }
            }
        }

        public void controllerError(ControllerErrorEvent controllerErrorEvent) {
            MediaPlayer.this.debug("  Event:ControllerErrorEvent");
            MediaPlayer.this.player = null;
            MediaPlayer.this.Fatal(controllerErrorEvent.getMessage());
        }

        public void endOfMedia(EndOfMediaEvent endOfMediaEvent) {
            MediaPlayer.this.debug("  Event:EndofMediaEvent");
            if (MediaPlayer.this.isPlayBackLoop()) {
                InternalControllerAdapter internalControllerAdapter = this;
                synchronized (internalControllerAdapter) {
                    if (MediaPlayer.this.player == null) {
                        MediaPlayer.this.Fatal(MediaPlayerResource.getString("SHOULD NOT OCCUR"));
                        System.exit(-1);
                    }
                    if (MediaPlayer.this.player != null) {
                        MediaPlayer.this.player.setMediaTime(new Time(0L));
                    }
                    if (MediaPlayer.this.player != null) {
                        MediaPlayer.this.player.start();
                    }
                }
            }
        }

        public void formatChange(FormatChangeEvent formatChangeEvent) {
            MediaPlayer.this.debug(" formatChangeevent");
            Component component = MediaPlayer.this.visualComponent;
            if (MediaPlayer.this.player == null) {
                MediaPlayer.this.Fatal(MediaPlayerResource.getString("SHOULD NOT OCCUR"));
                System.exit(-1);
            }
            if ((MediaPlayer.this.visualComponent = MediaPlayer.this.player.getVisualComponent()) != null) {
                if (component != MediaPlayer.this.visualComponent) {
                    if (component != null) {
                        component.remove(MediaPlayer.this.zoomMenu);
                        MediaPlayer.this.vPanel.remove(component);
                        MediaPlayer.this.panel.remove(MediaPlayer.this.vPanel);
                        Component component2 = MediaPlayer.this.controlComponent;
                        if (component2 != null && MediaPlayer.this.newPanel != null) {
                            MediaPlayer.this.newPanel.remove(component2);
                            if (MediaPlayer.this.displayURL) {
                                MediaPlayer.this.newPanel.remove(MediaPlayer.this.urlName);
                            }
                            MediaPlayer.this.panel.remove(MediaPlayer.this.newPanel);
                        }
                    }
                    MediaPlayer.this.doRealize();
                } else if (MediaPlayer.this.getMediaLocation().endsWith("mvr") || MediaPlayer.this.getMediaLocation().endsWith("MVR")) {
                    MediaPlayer.this.zoomTo(1.0f);
                }
            } else {
                Component component3 = MediaPlayer.this.controlComponent;
                MediaPlayer.this.controlComponent = MediaPlayer.this.player.getControlPanelComponent();
                if (MediaPlayer.this.controlComponent != null && MediaPlayer.this.isControlPanelVisible()) {
                    if (component3 != MediaPlayer.this.controlComponent) {
                        if (component3 != null) {
                            MediaPlayer.this.newPanel.remove(component3);
                            if (MediaPlayer.this.displayURL) {
                                MediaPlayer.this.newPanel.remove(MediaPlayer.this.urlName);
                            }
                            MediaPlayer.this.panel.remove(MediaPlayer.this.newPanel);
                        }
                        MediaPlayer.this.doRealize();
                    }
                } else if (component != null && MediaPlayer.this.vPanel != null) {
                    component.remove(MediaPlayer.this.zoomMenu);
                    MediaPlayer.this.vPanel.remove(component);
                    MediaPlayer.this.panel.remove(MediaPlayer.this.vPanel);
                }
            }
        }

        public void prefetchComplete(PrefetchCompleteEvent prefetchCompleteEvent) {
            MediaPlayer.this.debug("  Event:prefetchComplete");
        }

        public void realizeComplete(RealizeCompleteEvent realizeCompleteEvent) {
            MediaPlayer.this.debug("  Event:  RealizeComplete");
            MediaPlayer.this.doRealize();
        }

        public void replaceURL(Object object) {
            MediaPlayer.this.debug("ReplaceURLEvent ");
            URL uRL = null;
            try {
                Class<?> clazz = Class.forName("com.ibm.media.ReplaceURLEvent");
                Method method = clazz.getMethod("getURL", null);
                uRL = (URL)method.invoke(object, null);
            }
            catch (Throwable throwable) {
                System.err.println(throwable);
            }
            MediaPlayer.this.setMediaLocation(uRL.toExternalForm());
            this.thisBean.start();
        }

        public void showDocument(Object object) {
            MediaPlayer.this.debug("ShowDocumentEvent ");
            MediaPlayer.this.initSetCodeBase();
            URL uRL = null;
            String string = null;
            try {
                Class<?> clazz = Class.forName("com.ibm.media.ShowDocumentEvent");
                Method method = clazz.getMethod("getURL", null);
                uRL = (URL)method.invoke(object, null);
                method = clazz.getMethod("getString", null);
                string = (String)method.invoke(object, null);
            }
            catch (Throwable throwable) {
                System.err.println(throwable);
            }
            if (MediaPlayer.this.mpAppletContext != null) {
                MediaPlayer.this.mpAppletContext.showDocument(uRL, string);
            }
        }

        public void sizeChange(SizeChangeEvent sizeChangeEvent) {
            MediaPlayer.this.debug("  Event:SizeChangeEvent");
            int n2 = 0;
            if (MediaPlayer.this.controlComponent != null && MediaPlayer.this.isControlPanelVisible()) {
                n2 = MediaPlayer.this.controlPanelHeight;
            }
            if (MediaPlayer.this.urlName != null && MediaPlayer.this.isMediaLocationVisible()) {
                n2 += MediaPlayer.this.urlFieldHeight;
            }
            if (MediaPlayer.this.visualComponent != null) {
                MediaPlayer.this.visualComponent.setSize(sizeChangeEvent.getWidth(), sizeChangeEvent.getHeight());
                MediaPlayer.this.preferredHeight = MediaPlayer.this.visualComponent.getPreferredSize().height;
                MediaPlayer.this.preferredWidth = MediaPlayer.this.visualComponent.getPreferredSize().width;
            }
            if (MediaPlayer.this.panel != null) {
                if (MediaPlayer.this.vPanel != null) {
                    MediaPlayer.this.vPanel.setBounds(0, 0, sizeChangeEvent.getWidth(), sizeChangeEvent.getHeight() - n2);
                    MediaPlayer.this.vPanel.validate();
                }
                MediaPlayer.this.panel.setBounds(0, 0, sizeChangeEvent.getWidth(), sizeChangeEvent.getHeight());
                MediaPlayer.this.panel.validate();
            }
            MediaPlayer.this.invalidate();
            MediaPlayer.this.validate();
        }

        public void start(StartEvent startEvent) {
            MediaPlayer.this.debug("  Event:StartEvent ");
        }

        public void transition(TransitionEvent transitionEvent) {
            MediaPlayer.this.debug("TransitionEvent " + transitionEvent);
            MediaPlayer.this.state = transitionEvent.getCurrentState();
        }
    }

    private class visualComponentAdapter
    extends ComponentAdapter {
        private MediaPlayer thisBean;

        public visualComponentAdapter(MediaPlayer mediaPlayer2) {
            this.thisBean = mediaPlayer2;
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (componentEvent.getSource() == this.thisBean) {
                MediaPlayer.this.debug("componentResized");
                int n2 = 0;
                if (MediaPlayer.this.controlComponent != null && MediaPlayer.this.isControlPanelVisible()) {
                    n2 = MediaPlayer.this.controlComponent.getPreferredSize().height;
                }
                MediaPlayer.this.center(this.thisBean, MediaPlayer.this.panel, MediaPlayer.this.isFixedAspectRatio(), n2);
            }
        }
    }

    private class visualMouseAdapter
    extends MouseAdapter {
        visualMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MediaPlayer.this.zoomMenu.show(MediaPlayer.this.visualComponent, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MediaPlayer.this.zoomMenu.show(MediaPlayer.this.visualComponent, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MediaPlayer.this.zoomMenu.show(MediaPlayer.this.visualComponent, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class popupActionListener
    implements ActionListener {
        popupActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            MediaPlayer.this.setZoomTo(string);
        }
    }
}

