/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.media.Control;
import javax.media.bean.playerbean.MediaPlayer;
import javax.media.control.MonitorControl;
import jmapps.ui.JMPanel;

public class VideoPanel
extends JMPanel
implements MouseListener,
ActionListener,
ComponentListener {
    private MediaPlayer mediaPlayer = null;
    private Component compVisual = null;
    private double dScale = 1.0;
    private PopupMenu menuZoom = null;
    private MenuItem menuItemZoom_1_2 = null;
    private MenuItem menuItemZoom_1_1 = null;
    private MenuItem menuItemZoom_2_1 = null;
    private MenuItem menuItemZoom_4_1 = null;
    public static final String MENU_ZOOM = JMFI18N.getResource("mediaplayer.menu.zoom");
    public static final String MENU_ZOOM_1_2 = JMFI18N.getResource("mediaplayer.zoom.1:2");
    public static final String MENU_ZOOM_1_1 = JMFI18N.getResource("mediaplayer.zoom.1:1");
    public static final String MENU_ZOOM_2_1 = JMFI18N.getResource("mediaplayer.zoom.2:1");
    public static final String MENU_ZOOM_4_1 = JMFI18N.getResource("mediaplayer.zoom.4:1");

    public VideoPanel(MediaPlayer mediaPlayer) {
        super(null);
        this.setBackground(Color.black);
        this.addComponentListener(this);
        this.createPopupMenuZoom();
        this.setMediaPlayer(mediaPlayer);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(MENU_ZOOM_1_2)) {
            this.dScale = 0.5;
        } else if (string.equals(MENU_ZOOM_1_1)) {
            this.dScale = 1.0;
        } else if (string.equals(MENU_ZOOM_2_1)) {
            this.dScale = 2.0;
        } else if (string.equals(MENU_ZOOM_4_1)) {
            this.dScale = 4.0;
        }
        this.invalidate();
    }

    public void addMenuZoomActionListener(ActionListener actionListener) {
        if (this.menuItemZoom_1_2 != null) {
            this.menuItemZoom_1_2.addActionListener(actionListener);
        }
        if (this.menuItemZoom_1_1 != null) {
            this.menuItemZoom_1_1.addActionListener(actionListener);
        }
        if (this.menuItemZoom_2_1 != null) {
            this.menuItemZoom_2_1.addActionListener(actionListener);
        }
        if (this.menuItemZoom_4_1 != null) {
            this.menuItemZoom_4_1.addActionListener(actionListener);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.compVisual != null) {
            this.compVisual.addMouseListener(this);
        }
    }

    private void addPopupMenuZoom() {
        if (this.compVisual == null) {
            return;
        }
        this.createPopupMenuZoom();
        this.compVisual.add(this.menuZoom);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.resizeVisualComponent();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    private void createPopupMenuZoom() {
        if (this.menuZoom != null) {
            return;
        }
        this.menuZoom = new PopupMenu(MENU_ZOOM);
        this.menuItemZoom_1_2 = new MenuItem(MENU_ZOOM_1_2);
        this.menuZoom.add(this.menuItemZoom_1_2);
        this.menuItemZoom_1_2.addActionListener(this);
        this.menuItemZoom_1_1 = new MenuItem(MENU_ZOOM_1_1);
        this.menuZoom.add(this.menuItemZoom_1_1);
        this.menuItemZoom_1_1.addActionListener(this);
        this.menuItemZoom_2_1 = new MenuItem(MENU_ZOOM_2_1);
        this.menuZoom.add(this.menuItemZoom_2_1);
        this.menuItemZoom_2_1.addActionListener(this);
        this.menuItemZoom_4_1 = new MenuItem(MENU_ZOOM_4_1);
        this.menuZoom.add(this.menuItemZoom_4_1);
        this.menuItemZoom_4_1.addActionListener(this);
    }

    public Component getMediaPlayer() {
        return this.mediaPlayer;
    }

    public Dimension getPreferredSize() {
        Dimension dimension;
        if (this.compVisual == null || this.mediaPlayer == null) {
            dimension = new Dimension(320, 0);
        } else {
            dimension = this.compVisual.getPreferredSize();
            dimension.width = (int)((double)dimension.width * this.dScale);
            dimension.height = (int)((double)dimension.height * this.dScale);
        }
        return dimension;
    }

    public Component getVisualComponent() {
        return this.mediaPlayer.getVisualComponent();
    }

    public double getZoom() {
        return this.dScale;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.menuZoom.show(this.compVisual, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.menuZoom.show(this.compVisual, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.menuZoom.show(this.compVisual, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void removeMenuZoomActionListener(ActionListener actionListener) {
        if (this.menuItemZoom_1_2 != null) {
            this.menuItemZoom_1_2.removeActionListener(actionListener);
        }
        if (this.menuItemZoom_1_1 != null) {
            this.menuItemZoom_1_1.removeActionListener(actionListener);
        }
        if (this.menuItemZoom_2_1 != null) {
            this.menuItemZoom_2_1.removeActionListener(actionListener);
        }
        if (this.menuItemZoom_4_1 != null) {
            this.menuItemZoom_4_1.removeActionListener(actionListener);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.compVisual != null) {
            this.compVisual.removeMouseListener(this);
        }
    }

    public void resizeVisualComponent() {
        Dimension dimension = this.getSize();
        if (this.mediaPlayer != null && this.mediaPlayer.getParent() == this) {
            this.mediaPlayer.setBounds(0, 0, dimension.width, dimension.height);
        } else if (this.compVisual != null && this.compVisual.getParent() == this) {
            this.compVisual.setBounds(0, 0, dimension.width, dimension.height);
        }
        this.validate();
    }

    public void setMediaPlayer(MediaPlayer mediaPlayer) {
        this.removeAll();
        if (this.compVisual != null) {
            this.compVisual.removeMouseListener(this);
        }
        this.mediaPlayer = mediaPlayer;
        this.compVisual = mediaPlayer.getVisualComponent();
        if (this.compVisual == null) {
            MonitorControl monitorControl = (MonitorControl)mediaPlayer.getControl("javax.media.control.MonitorControl");
            if (monitorControl != null) {
                Panel panel;
                Control[] controlArray = mediaPlayer.getControls();
                Panel panel2 = panel = new Panel(new BorderLayout());
                int n2 = 0;
                while (n2 < controlArray.length) {
                    if (controlArray[n2] instanceof MonitorControl) {
                        monitorControl = (MonitorControl)controlArray[n2];
                        monitorControl.setEnabled(true);
                        Component component = monitorControl.getControlComponent();
                        if (component != null) {
                            panel2.add(component, "Center");
                            Panel panel3 = new Panel(new BorderLayout());
                            panel2.add((Component)panel3, "South");
                            panel2 = panel3;
                        }
                    }
                    ++n2;
                }
                this.compVisual = panel;
                this.add(panel);
            }
        } else {
            this.add(mediaPlayer);
        }
        if (this.compVisual == null) {
            return;
        }
        this.resizeVisualComponent();
        this.addPopupMenuZoom();
    }

    public void setZoom(double d2) {
        this.dScale = d2;
    }
}

