/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.comms;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.dialang.client.comms.EchoClient;
import net.dialang.mytest.debug.Debug;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class Allocator {
    private String oldHost;
    private Debug debug;
    private int debugID;
    private SAXParser parser;
    private ArrayList servers;
    private EchoClient echoClient;

    void setAuthorisation(String string, String string2) {
        this.echoClient.setAuthorisation(string, string2);
    }

    void reset(File file) throws Exception {
        this.reset(new FileInputStream(file));
    }

    void reset(InputStream inputStream) throws Exception {
        this.parseListing(inputStream);
    }

    private final void parseListing(InputStream inputStream) throws Exception {
        this.parser.parse(inputStream, (DefaultHandler)new XMLHandler());
    }

    URL allocate() throws IOException {
        int n = this.servers.size();
        if (n < 1) {
            this.debug.println(this.debugID, (Object)"No allocators specified");
            throw new IOException("Failed to allocate server.");
        }
        long l = Long.MAX_VALUE;
        String string = null;
        Object object = this.servers.iterator();
        while (object.hasNext()) {
            long l2;
            String string2;
            block5: {
                string2 = (String)object.next();
                this.debug.println(this.debugID, (Object)("Getting echo time for host: " + string2));
                l2 = 0L;
                try {
                    this.debug.println(this.debugID, (Object)("About to ping " + string2 + " ..."));
                    l2 = this.echoClient.getEchoTime(string2, 64, 5000);
                    this.debug.println(this.debugID, (Object)(string2 + " pinged !"));
                    if (l2 >= l) break block5;
                    l = l2;
                    string = string2;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    continue;
                }
            }
            this.debug.println(this.debugID, (Object)("Echo time for " + string2 + ": " + Long.toString(l2)));
        }
        if (string == null) {
            this.debug.println(this.debugID, (Object)"Exceptions were thrown during the echo test for every server listed.");
            throw new IOException("Failed to allocate server.");
        }
        this.debug.println(this.debugID, (Object)("Allocated: " + string));
        this.oldHost = string;
        object = new URL("http://" + string);
        return object;
    }

    void dump(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println("<?xml version=\"1.0\"?>");
        printWriter.println("<allocators>");
        Iterator iterator = this.servers.iterator();
        while (iterator.hasNext()) {
            printWriter.println("\t<server hostname=\"" + (String)iterator.next() + "\"/>");
        }
        printWriter.println("</allocators>");
        printWriter.flush();
    }

    private final /* synthetic */ void this() {
        this.oldHost = null;
        this.debugID = 8;
    }

    Allocator(File file, Debug debug) throws Exception {
        this(new FileInputStream(file), debug);
    }

    Allocator(InputStream inputStream, Debug debug) throws Exception {
        this.this();
        if (debug == null) {
            throw new IllegalArgumentException("Null debug instance supplied");
        }
        this.debug = debug;
        this.servers = new ArrayList(3);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(false);
        this.parser = sAXParserFactory.newSAXParser();
        this.parseListing(inputStream);
        this.echoClient = new EchoClient(this.debug, this.debugID);
    }

    private class XMLHandler
    extends DefaultHandler {
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("server")) {
                String string4 = attributes.getValue("hostname");
                if (string4 == null) {
                    throw new SAXException("Invalid allocator list: No hostname for server.");
                }
                Allocator.this.servers.add(string4);
            }
        }

        private XMLHandler() {
        }
    }
}

