/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.comms;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import net.dialang.client.cache.Cache;
import net.dialang.client.cache.CacheEntry;
import net.dialang.client.comms.Allocator;
import net.dialang.client.comms.CommsProtocol;
import net.dialang.client.comms.HTTPSEND;
import net.dialang.client.comms.ICommsHandler;
import net.dialang.client.comms.SetUCHeader;
import net.dialang.common.BasicModule;
import net.dialang.common.ServiceNames;
import net.dialang.mytest.debug.Debug;

public class CommsHandler
implements ICommsHandler,
ServiceNames {
    private static CommsProtocol commsProtocol;
    private static Debug debug;
    private static final int debugID = 8;
    private static HashMap beingCached;
    public static final int MEMORY = 1;
    public static final int DISK = 2;
    public static final int PROTOCOL = 4;
    public static final int STREAM = 8;
    public static final int NOPROTOCOL = 16;
    private URL server;
    private Allocator allocator;
    private File serverListFile;
    private Cache cache;
    private int defaultFlags = 5;

    public void setProtocol(CommsProtocol commsProtocol) {
        CommsHandler.commsProtocol = commsProtocol;
    }

    public void setServerList(File file) throws IOException {
        this.serverListFile = file;
        try {
            this.allocator = new Allocator(this.serverListFile, debug);
        }
        catch (Exception exception) {
            throw new IOException("Failed to setup Allocator");
        }
    }

    public URL connect() throws Exception {
        debug.println(8, (Object)"Connecting ...");
        if (this.allocator == null) {
            debug.println(8, (Object)"No allocator set. Throwing exception ...");
            throw new Exception("Allocator not set.");
        }
        this.server = this.allocator.allocate();
        Allocator allocator = this.allocator;
        synchronized (allocator) {
            CommsHandler commsHandler = this;
            if (commsHandler == null) {
                throw null;
            }
            commsHandler.new AllocatorResetThread().start();
        }
        debug.println(8, (Object)("Connected to " + this.server));
        return this.server;
    }

    public URL getServer() {
        return this.server;
    }

    public CommsProtocol getProtocol() {
        return commsProtocol;
    }

    public void setDefaultFlags(int n) {
        this.defaultFlags = n;
        debug.println(8, (Object)("Flags set to " + Integer.toString(this.defaultFlags)));
    }

    public void setAuthorisation(String string, String string2) {
        this.allocator.setAuthorisation(string, string2);
        commsProtocol.setAuthorisation(string, string2);
    }

    public void setUserAgent(String string) {
        commsProtocol.setUserAgent(string);
    }

    public void setCacheDirectory(File file) throws IOException {
        if (this.cache != null) {
            debug.println(8, (Object)"Failed to set cache. It is already set. Returning.");
            return;
        }
        if (file == null) {
            debug.println(8, (Object)"Failed to set cache. Null cache root dir specified. Returning.");
            return;
        }
        this.cache = new Cache();
        this.cache.setDebug(debug, 2);
        this.cache.setRoot(file);
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setDebug(Debug debug) {
        CommsHandler.debug = debug;
    }

    public Debug getDebug() {
        return debug;
    }

    public void setProxy(String string) {
        commsProtocol.setProxy(string);
        HTTPSEND.setProxy(string);
    }

    public void setDefaultServer(URL uRL) {
        this.server = uRL;
    }

    private void checkServerIsSet(URL uRL) {
        if (uRL == null) {
            throw new IllegalStateException("Comms: server not set!");
        }
    }

    private void checkCacheIsSet() {
        if (this.cache == null) {
            throw new IllegalStateException("Comms: cache not set!");
        }
    }

    private void checkFlagsAreSet(int n) {
        if (n == 0) {
            throw new IllegalStateException("Comms: flags not set!");
        }
    }

    public Object getObject(BasicModule basicModule, String string) throws IOException {
        return this.getObject(this.defaultFlags, basicModule, this.server, string);
    }

    public Object getObject(int n, BasicModule basicModule, String string) throws IOException {
        return this.getObject(n, basicModule, this.server, string);
    }

    public Object getObject(BasicModule basicModule, URL uRL, String string) throws IOException {
        return this.getObject(this.defaultFlags, basicModule, uRL, string);
    }

    public Object getObject(int n, BasicModule basicModule, URL uRL, String string) throws IOException {
        URL uRL2;
        String string2;
        debug.println(8, (Object)("flags " + n), (Object)uRL, (Object)string);
        this.checkFlagsAreSet(n);
        this.checkCacheIsSet();
        if (CommsHandler.isSet(n, 4)) {
            this.checkServerIsSet(uRL);
        }
        if (string.equals("getstream") && !CommsHandler.isSet(n, 8)) {
            debug.println(8, (Object)"Forcing stream flag for stream request ...");
            debug.println(8, (Object)("flags now " + (n |= 8)));
        }
        if (this.cache.isCachedInMemory(string2 = this.toKey(string, basicModule.request))) {
            debug.println(8, (Object)"Cached in memory. Returning cache only read");
            return this.cache.get(string2);
        }
        if (!CommsHandler.isSet(n, 4)) {
            debug.println(8, (Object)"Returning cache only read");
            return this.cache.get(string2);
        }
        try {
            uRL2 = new URL(uRL, "dialang/" + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(malformedURLException.toString());
        }
        debug.println(8, (Object)"Setting request item timestamp to cached item timestamp ...");
        basicModule.timeStamp = this.cache.getTimeStamp(string2);
        debug.println(8, (Object)("Done. Request timestamp: " + Long.toString(basicModule.timeStamp)));
        Object object = null;
        if (!CommsHandler.isSet(n, 16)) {
            object = commsProtocol.io(basicModule, uRL2);
            debug.println(8, (Object)("Request timestamp now: " + Long.toString(basicModule.timeStamp)));
        }
        if (object == null) {
            object = this.cache.get(string2);
            if (object == null) {
                throw new IOException("Comms: No entry in cache for " + string2);
            }
            debug.println(8, (Object)"cache is up to date");
            return object;
        }
        debug.println(8, (Object)"Updating cache entry");
        CacheEntry cacheEntry = new CacheEntry();
        cacheEntry.obj = object;
        cacheEntry.timeStamp = basicModule.timeStamp;
        debug.println(8, (Object)("CacheEntry timestamp set to: " + Long.toString(cacheEntry.timeStamp)));
        cacheEntry.flags |= 8;
        cacheEntry.flags |= 4;
        this.cache.put(cacheEntry, string2);
        if (CommsHandler.isSet(n, 8)) {
            return this.cache.get(string2);
        }
        return object;
    }

    public synchronized void markAsBeingCached(String string) {
        beingCached.put(string, new Object());
    }

    public synchronized void markAsCached(String string) {
        beingCached.remove(string);
    }

    public boolean isBeingCached(String string) {
        return beingCached.containsKey(string);
    }

    public static final boolean isSet(int n, int n2) {
        return (n & n2) > 0;
    }

    private String toKey(String string, String string2) {
        int n = string.length();
        if (string2 != null) {
            n += 1 + string2.length();
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        if (string2 != null) {
            stringBuffer.append("#");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ int access$0() {
        return debugID;
    }

    public CommsHandler() {
    }

    public CommsHandler(CommsProtocol commsProtocol, File file, File file2, Debug debug) throws IOException {
        this.setDebug(debug);
        this.setProtocol(commsProtocol);
        this.setServerList(file);
        this.setCacheDirectory(file2);
    }

    static {
        beingCached = new HashMap();
    }

    private class AllocatorResetThread
    extends Thread {
        public void run() {
            try {
                debug.println(8, (Object)"Resetting allocator ...");
                URL uRL = new URL(CommsHandler.this.server, "/dialang/getallocatorlisting");
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                SetUCHeader.setRequestProperties(httpURLConnection);
                httpURLConnection.setUseCaches(false);
                httpURLConnection.connect();
                int n = httpURLConnection.getResponseCode();
                if (n != 200) {
                    debug.println(8, (Object)("ERROR: Failed to download allocator listing. Status code - " + n));
                    return;
                }
                debug.println(8, (Object)("Writing allocator stream to " + CommsHandler.this.serverListFile.getPath() + " ..."));
                CommsHandler.this.allocator = new Allocator(httpURLConnection.getInputStream(), debug);
                httpURLConnection.disconnect();
                CommsHandler.this.allocator.dump(new FileOutputStream(CommsHandler.this.serverListFile));
                debug.println(8, (Object)"Allocator stream written.");
                debug.println(8, (Object)"Allocator reset.");
            }
            catch (Exception exception) {
                debug.println(8, (Object)("ERROR: IOException caught whilst downloading allocator listing. Reason - " + exception.getMessage()));
            }
        }

        AllocatorResetThread() {
        }
    }
}

