/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.comms;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import net.dialang.mytest.debug.Debug;
import sun.misc.BASE64Encoder;

public final class EchoClient {
    private long echoTime = -1L;
    private String userPass;
    private Debug debug;
    private int debugID;

    public final void setAuthorisation(String string, String string2) {
        if (string == null) {
            return;
        }
        if (string.length() < 1) {
            return;
        }
        if (string2 == null) {
            return;
        }
        if (string2.length() < 1) {
            return;
        }
        this.userPass = string + ":" + string2;
        this.userPass = "Basic " + new BASE64Encoder().encode(this.userPass.getBytes());
    }

    public final long getEchoTime(String string, int n, int n2) throws Throwable {
        EchoClient echoClient = this;
        if (echoClient == null) {
            throw null;
        }
        EchoThread echoThread = echoClient.new EchoThread(new URL("http://" + string + "/dialang/gettimingfile"));
        echoThread.setPriority(10);
        echoThread.start();
        Thread.sleep(n2);
        if (this.echoTime == -1L) {
            echoThread.cancel();
            throw new Throwable("Echo thread timed out");
        }
        return this.echoTime;
    }

    public final boolean isAvailable(String string, String string2, String string3) {
        try {
            this.getEchoTime(string, 2, 5000);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static /* synthetic */ long access$3(EchoClient echoClient) {
        return echoClient.echoTime;
    }

    public EchoClient(Debug debug, int n) {
        this.debug = debug;
        this.debugID = n;
    }

    private final class EchoThread
    extends Thread {
        private URL u = null;
        private boolean runFlag = true;

        public void cancel() {
            this.runFlag = false;
        }

        public void run() {
            Date date = new Date();
            try {
                HttpURLConnection httpURLConnection = (HttpURLConnection)this.u.openConnection();
                if (!this.runFlag) {
                    httpURLConnection.disconnect();
                    return;
                }
                if (EchoClient.this.userPass != null) {
                    httpURLConnection.setRequestProperty("Proxy-Authorization", EchoClient.this.userPass);
                }
                httpURLConnection.setRequestProperty("User-agent", "Dialang V1");
                if (!this.runFlag) {
                    httpURLConnection.disconnect();
                    return;
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                boolean bl = false;
                int n = -1;
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                }
                bufferedReader.close();
                httpURLConnection.disconnect();
                if (!this.runFlag) {
                    return;
                }
                Date date2 = new Date();
                long l = date2.getTime() - date.getTime();
                EchoClient.this.echoTime = l;
            }
            catch (Throwable throwable) {
                EchoClient.this.debug.println(EchoClient.this.debugID, (Object)("Exception caught during echo attempt. Reason: " + throwable.getMessage()));
            }
        }

        public EchoThread(URL uRL) {
            this.u = uRL;
        }
    }
}

