/*
 * Decompiled with CFR 0.152.
 */
package net.dialang.client.comms;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Properties;
import net.dialang.client.comms.CommsException;
import net.dialang.client.comms.CommsProtocol;
import net.dialang.client.comms.NotFoundException;
import net.dialang.client.comms.SetUCHeader;
import net.dialang.common.BasicModule;
import net.dialang.common.ServiceNames;
import net.dialang.mytest.debug.Debug;
import net.dialang.mytest.io.Utils;
import sun.misc.BASE64Encoder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HTTP
implements CommsProtocol,
ServiceNames {
    private String proxy;
    private Debug debug;
    private int debugID;
    private String userAgent;
    private String userPass;

    public void setAuthorisation(String string, String string2) {
        this.debug.println(this.debugID, (Object)"Set auth being run");
        if (string == null) {
            return;
        }
        if (string.length() < 1) {
            return;
        }
        if (string2 == null) {
            return;
        }
        if (string2.length() < 1) {
            return;
        }
        this.userPass = string + ':' + string2;
        this.debug.println(this.debugID, (Object)("Preprocess string: " + this.userPass));
        this.userPass = "Basic " + new BASE64Encoder().encode(this.userPass.getBytes());
        this.debug.println(this.debugID, (Object)("Finishing set Auth: " + this.userPass));
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public void setDebug(Debug debug, int n) {
        this.debug = debug;
        this.debugID = n;
    }

    public Debug getDebug() {
        return this.debug;
    }

    public void setProxy(String string) {
        this.proxy = string;
        if (this.proxy == null) {
            return;
        }
        Properties properties = System.getProperties();
        int n = this.proxy.lastIndexOf(58);
        String string2 = this.proxy.substring(0, n);
        String string3 = this.proxy.substring(n + 1);
        properties.put("proxySet", "true");
        properties.put("proxyHost", string2);
        properties.put("http.proxyHost", string2);
        properties.put("proxyPort", string3);
        properties.put("http.proxyPort", string3);
        properties.put("http.agent", "Dialang V1 Beta");
    }

    public String getProxy() {
        return this.proxy;
    }

    public Object io(BasicModule basicModule, URL uRL) throws IOException {
        this.debug.println(this.debugID, (Object)("Is user/pass null ? " + (this.userPass == null ? "yes" : "no")));
        String string = "http://" + uRL.getHost() + uRL.getPath() + "?timestamp=" + Long.toString(basicModule.timeStamp);
        if (basicModule.request != null) {
            string = string + "&request=";
            string = string + URLEncoder.encode(basicModule.request, "UTF-8");
        }
        this.debug.println(this.debugID, (Object)("URL - '" + string + '\''));
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.debug.println(this.debugID, (Object)"Opening connection...");
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
        if (this.userPass != null) {
            this.debug.println(this.debugID, (Object)("User-pass: " + this.userPass));
            httpURLConnection.setRequestProperty("Proxy-Authorization", this.userPass);
        }
        SetUCHeader.setRequestProperties(httpURLConnection);
        httpURLConnection.connect();
        int n = -1;
        try {
            n = httpURLConnection.getResponseCode();
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                n = httpURLConnection.getResponseCode();
            }
            catch (IOException iOException) {
                String string2 = "fnfe paranoid trap: " + iOException + " req " + basicModule.request;
                this.debug.println(this.debugID, (Object)string2);
                throw new CommsException(string2);
            }
        }
        catch (IOException iOException) {
            this.debug.println(this.debugID, (Object)("getResponseCode threw " + iOException));
            throw iOException;
        }
        String string3 = httpURLConnection.getHeaderField("response");
        String string4 = httpURLConnection.getContentType();
        this.debug.println(this.debugID, (Object)("Response Type - " + string3));
        switch (n) {
            case 200: {
                if (this.shouldStream(string3)) {
                    return this.streamResponseExpected(basicModule, httpURLConnection);
                }
                return this.readResponseObject(basicModule, httpURLConnection);
            }
            case 204: {
                return this.noResponseExpected(httpURLConnection);
            }
            case 404: {
                this.debug.println(this.debugID, (Object)"HTTP_NOT_FOUND returned.");
                String string5 = httpURLConnection.getResponseMessage();
                httpURLConnection.disconnect();
                throw new NotFoundException(n, string5);
            }
        }
        this.debug.println(this.debugID, (Object)("Status code returned: " + n));
        String string6 = httpURLConnection.getResponseMessage();
        this.debug.println(this.debugID, (Object)("Response message: " + string6));
        httpURLConnection.disconnect();
        throw new CommsException(n, string6);
    }

    private final boolean shouldStream(String string) {
        this.debug.println((Object)("Reponse type: " + string));
        return string.equals("getstream") | string.equalsIgnoreCase("getparametertable") | string.equalsIgnoreCase("getinformationtable");
    }

    private final Object readResponseText(BasicModule basicModule, HttpURLConnection httpURLConnection) throws IOException {
        int n = httpURLConnection.getContentLength();
        this.debug.println(this.debugID, (Object)("Response has entity length " + n));
        if (n <= 0) {
            throw new CommsException("no response when expected");
        }
        try {
            Object object = Utils.readGZIPText((InputStream)httpURLConnection.getInputStream(), (int)n);
            httpURLConnection.getInputStream().close();
            basicModule.timeStamp = httpURLConnection.getHeaderFieldDate("timestamp", 0L);
            httpURLConnection.disconnect();
            return object;
        }
        catch (IOException iOException) {
            this.debug.println(this.debugID, (Object)("read entity threw " + iOException));
            httpURLConnection.disconnect();
            throw iOException;
        }
    }

    private final Object readResponseObject(BasicModule basicModule, HttpURLConnection httpURLConnection) throws IOException {
        int n = httpURLConnection.getContentLength();
        this.debug.println(this.debugID, (Object)("Response has entity length " + n));
        if (n <= 0) {
            throw new CommsException("no response when expected");
        }
        try {
            Object object = Utils.readGZIPObject((InputStream)httpURLConnection.getInputStream());
            httpURLConnection.getInputStream().close();
            basicModule.timeStamp = httpURLConnection.getHeaderFieldDate("timestamp", 0L);
            httpURLConnection.disconnect();
            return object;
        }
        catch (IOException iOException) {
            this.debug.println(this.debugID, (Object)("read entity threw " + iOException));
            httpURLConnection.disconnect();
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            httpURLConnection.disconnect();
            throw new CommsException("class not found exception " + classNotFoundException);
        }
    }

    private final Object noResponseExpected(HttpURLConnection httpURLConnection) throws IOException {
        int n = httpURLConnection.getContentLength();
        if (n > 0) {
            httpURLConnection.disconnect();
            throw new CommsException("response when not expected - ignored");
        }
        return null;
    }

    private final Object streamResponseExpected(BasicModule basicModule, HttpURLConnection httpURLConnection) throws IOException {
        this.debug.println(this.debugID, (Object)"STREAM DATA");
        basicModule.timeStamp = httpURLConnection.getHeaderFieldDate("timestamp", 0L);
        return httpURLConnection.getInputStream();
    }

    private final /* synthetic */ void this() {
        this.userPass = null;
    }

    public HTTP() {
        this(null);
    }

    public HTTP(String string) {
        this.this();
        this.setProxy(string);
    }
}

